/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.toolkit.base.region;

import com.github.developframework.toolkit.base.exception.ToolkitException;
import com.github.developframework.toolkit.base.region.Area;
import com.github.developframework.toolkit.base.region.City;
import com.github.developframework.toolkit.base.region.Country;
import com.github.developframework.toolkit.base.region.Province;
import com.github.developframework.toolkit.base.region.Region;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;

public class RegionModule {
    private Country country;

    public RegionModule() {
        try (InputStream is = RegionModule.class.getResourceAsStream("/region.dat");
             ObjectInputStream ois = new ObjectInputStream(is);){
            this.country = (Country)ois.readObject();
        }
        catch (IOException e) {
            throw new ToolkitException("read \"region.dat\" failed.");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Map<String, Province> getAllProvincesInCountry() {
        return this.country.getProvinces();
    }

    public Map<String, City> getAllCitiesInProvince(String provinceCode) {
        return this.getProvince(provinceCode).getCities();
    }

    public Map<String, Area> getAllAreaInCity(String provinceCode, String cityCode) {
        return this.getProvince(provinceCode).getCities().get(cityCode).getAreas();
    }

    public Province getProvince(String provinceCode) {
        Province province = this.country.getProvinces().get(provinceCode);
        if (province == null) {
            throw new ToolkitException("province is not exist by code: " + provinceCode);
        }
        return province;
    }

    public Region getRegion(String code) {
        Region region = this.country.getAllRegions().get(code);
        if (region == null) {
            throw new ToolkitException("region is not exist by code: " + code);
        }
        return region;
    }

    public Country getCountry() {
        return this.country;
    }
}

