/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.wechat.pay.spring;

import com.github.developframework.wechat.pay.entity.WechatPayNotifyResponseBody;
import com.github.developframework.wechat.pay.xml.BaseAnnotationXmlSerializer;
import com.github.developframework.wechat.pay.xml.XmlSerializer;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class WechatPayNotifyResponseProcessor
implements HandlerMethodReturnValueHandler {
    private XmlSerializer<WechatPayNotifyResponseBody> serializer = new BaseAnnotationXmlSerializer();

    public boolean supportsReturnType(MethodParameter returnType) {
        return returnType.getParameterType().equals(WechatPayNotifyResponseBody.class);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Assert.isInstanceOf(WechatPayNotifyResponseBody.class, (Object)returnValue);
        mavContainer.setRequestHandled(true);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        String xml = this.serializer.serialize((Object)((WechatPayNotifyResponseBody)returnValue));
        outputMessage.setStatusCode(HttpStatus.OK);
        outputMessage.getHeaders().add("Content-Type", "application/xml;charset=utf-8");
        IOUtils.write((String)xml, (OutputStream)outputMessage.getBody(), (String)"utf-8");
    }

    protected ServletServerHttpResponse createOutputMessage(NativeWebRequest webRequest) {
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        return new ServletServerHttpResponse(response);
    }
}

