/*
 * Decompiled with CFR 0.152.
 */
package com.github.devswork.interceptor;

import com.alibaba.fastjson.JSON;
import com.dkdy.skip.OursHelperFilter;
import com.github.devswork.util.json.JSONUtil;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class RequestLogInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(RequestLogInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            if (OursHelperFilter.processHandler(request.getRequestURI())) {
                return true;
            }
            Enumeration headerNames = request.getHeaderNames();
            HashMap<String, String> headerMap = new HashMap<String, String>(10);
            do {
                String header = (String)headerNames.nextElement();
                headerMap.put(header, request.getHeader(header));
            } while (headerNames.hasMoreElements());
            log.info("\nADDRESS\t\t\t->\t\t{}\nMETHOD\t\t\t->\t\t{}\nPARAMS\t\t\t->\t\t{}\nFROM\t\t\t->\t\t{}\nHEADER\t\t\t->\t\t{}\nCONTENT-TYPE\t\t\t->\t\t{}\n", new Object[]{request.getRequestURI(), request.getMethod(), JSONUtil.toJSON(request.getParameterMap()), request.getRemoteAddr(), JSON.toJSONString(headerMap), request.getContentType()});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

