/*
 * Decompiled with CFR 0.152.
 */
package com.github.devswork.util;

import com.github.devswork.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RequestUtil {
    public static String getContextPath(HttpServletRequest request, boolean endStr) {
        String contextPath = request.getContextPath();
        String string = contextPath = contextPath.equals("/") ? "" : contextPath;
        if (endStr) {
            contextPath = contextPath + "/";
        }
        return contextPath;
    }

    public static String getPath4Method(HttpServletRequest request) {
        String contextPath = RequestUtil.getContextPath(request, false);
        String uri = request.getRequestURI();
        if (StringUtil.isNotEmpty(contextPath)) {
            uri = uri.replace(contextPath, "");
        }
        String method = RequestUtil.getString(request, "method", "index");
        uri = uri + "?method=" + method;
        return uri;
    }

    public static String getPath4Params(HttpServletRequest request) {
        String method;
        String contextPath = RequestUtil.getContextPath(request, false);
        String uri = request.getRequestURI();
        if (StringUtil.isNotEmpty(contextPath)) {
            uri = uri.replace(contextPath + "/", "");
            uri = uri.replace(contextPath, "");
        } else if (uri.substring(0, 1).equals("/")) {
            uri = uri.substring(1, uri.length());
        }
        String params = request.getQueryString();
        uri = StringUtil.isEmpty(params) ? uri + "?method=index" : ((method = RequestUtil.getString(request, "method", null)) == null ? uri + "?method=index&" + request.getQueryString() : uri + "?" + request.getQueryString());
        return uri;
    }

    public static String encodeUrl(String msg) {
        String ret = "";
        try {
            ret = URLEncoder.encode(msg, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public static String decodeUrl(String msg) {
        String ret = "";
        try {
            ret = URLDecoder.decode(msg, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRequestContent(HttpServletRequest request) {
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer("");
        String content = "";
        try {
            br = request.getReader();
            String line = br.readLine();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            content = sb.toString();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return content;
    }

    public static String appendParam(String url, String param) {
        String ret = url.indexOf("?") >= 0 ? url + "&" + param : url + "?" + param;
        return ret;
    }

    public static String appendParams(String url, Map<String, String> params) {
        if (params != null) {
            for (String key : params.keySet()) {
                url = RequestUtil.appendParam(key, params.get(key));
            }
        }
        return url;
    }

    public static String removeParams(String url, String ... params) {
        String reg = null;
        for (int i = 0; i < params.length; ++i) {
            reg = "(?<=[\\?&])" + params[i] + "=[^&]*&?";
            url = url.replaceAll(reg, "");
        }
        url = url.replaceAll("&+$", "");
        return url;
    }

    public static String updateParam(String url, String key, String value) {
        if (StringUtil.isNotEmpty(url) && StringUtil.isNotEmpty(key)) {
            url = url.replaceAll("(" + key + "=[^&]*)", key + "=" + value);
        }
        return url;
    }

    public static String putParam(String url, String key, String value) {
        return url.contains(key + "=") ? RequestUtil.updateParam(url, key, value) : RequestUtil.appendParam(url, key + "=" + value);
    }

    public static String getCookieValue(HttpServletRequest request, String cookieKey) {
        String cookieValue = null;
        Cookie cookie = RequestUtil.getCookie(request, cookieKey);
        if (cookie != null) {
            cookieValue = cookie.getValue();
        }
        return cookieValue;
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieKey) {
        Cookie cookieValue = null;
        Cookie[] cookies = request.getCookies();
        if (null == cookies) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            try {
                String key = URLDecoder.decode(cookie.getName(), "UTF8");
                if (!cookieKey.equals(key)) continue;
                cookieValue = cookie;
                break;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return cookieValue;
    }

    public static void setCookieValue(HttpServletResponse response, String cookieKey, String value, int expire) {
        Cookie cookie = new Cookie(cookieKey, value);
        cookie.setPath("/");
        cookie.setDomain("houbaoyan.com");
        if (expire > 0) {
            cookie.setMaxAge(expire);
        }
        response.addCookie(cookie);
    }

    public static void removeCookie(HttpServletResponse response, String cookieKey) {
        RequestUtil.setCookieValue(response, cookieKey, "", 0);
    }

    public static String getString(HttpServletRequest request, String name, Object defaultValue, boolean emptyThrowException) {
        String str = null;
        String param = request.getParameter(name);
        if (StringUtil.isNotEmpty(param)) {
            str = param;
        } else {
            if (emptyThrowException) {
                String errorMsg = request.getRequestURL() + "\u4e2d\u7684" + name + "\u53c2\u6570\u4e3a\u7a7aNULL";
                throw new RuntimeException(errorMsg);
            }
            if (defaultValue != null) {
                str = String.valueOf(defaultValue);
            }
        }
        return str;
    }

    public static boolean getBoolean(HttpServletRequest request, String name, boolean defaultValue, boolean emptyThrowException) {
        boolean ret = false;
        String str = RequestUtil.getString(request, name, String.valueOf(defaultValue), emptyThrowException);
        try {
            ret = Boolean.parseBoolean(str);
        }
        catch (NumberFormatException var) {
            String errorMsg = request.getRequestURL() + "\u4e2d\u7684" + name + "\u53c2\u6570\u503c\u7c7b\u578b\u4e0d\u5408\u6cd5";
            throw new IllegalArgumentException(errorMsg);
        }
        return ret;
    }

    public static Integer getInt(HttpServletRequest request, String name, Integer defaultValue, boolean emptyThrowException) {
        Integer i = null;
        String str = RequestUtil.getString(request, name, defaultValue, emptyThrowException);
        if (str != null) {
            try {
                i = Integer.parseInt(str);
            }
            catch (NumberFormatException var) {
                String errorMsg = request.getRequestURL() + "\u4e2d\u7684" + name + "\u53c2\u6570\u503c\u7c7b\u578b\u4e0d\u5408\u6cd5";
                throw new IllegalArgumentException(errorMsg);
            }
        }
        return i;
    }

    public static Long getLong(HttpServletRequest request, String name, Long defaultValue, boolean emptyThrowException) {
        Long l = null;
        String str = RequestUtil.getString(request, name, defaultValue, emptyThrowException);
        if (l != null) {
            try {
                l = Long.parseLong(str);
            }
            catch (NumberFormatException var) {
                String errorMsg = request.getRequestURL() + "\u4e2d\u7684" + name + "\u53c2\u6570\u503c\u7c7b\u578b\u4e0d\u5408\u6cd5";
                throw new IllegalArgumentException(errorMsg);
            }
        }
        return l;
    }

    public static Double getDouble(HttpServletRequest request, String name, double defaultValue, boolean emptyThrowException) {
        Double d = null;
        String str = RequestUtil.getString(request, name, defaultValue, emptyThrowException);
        if (str != null) {
            try {
                d = Double.parseDouble(str);
            }
            catch (NumberFormatException var) {
                String errorMsg = request.getRequestURL() + "\u4e2d\u7684" + name + "\u53c2\u6570\u503c\u7c7b\u578b\u4e0d\u5408\u6cd5";
                throw new IllegalArgumentException(errorMsg);
            }
        }
        return d;
    }

    public static BigDecimal getDecimal(HttpServletRequest request, String name, boolean emptyThrowException) {
        BigDecimal bd = null;
        String str = RequestUtil.getString(request, name, emptyThrowException);
        if (str != null) {
            try {
                bd = new BigDecimal(str);
            }
            catch (Exception e) {
                String errorMsg = request.getRequestURL() + "\u4e2d\u7684" + name + "\u53c2\u6570\u503c\u7c7b\u578b\u4e0d\u5408\u6cd5";
                throw new IllegalArgumentException(errorMsg);
            }
        }
        return bd;
    }

    public static String[] getArray(HttpServletRequest request, String name, boolean emptyThrowException) {
        String[] str = request.getParameterValues(name);
        if (str == null && emptyThrowException) {
            String errorMsg = request.getRequestURL() + "\u4e2d\u7684" + name + "\u53c2\u6570\u4e3a\u7a7aNULL";
            throw new RuntimeException(errorMsg);
        }
        return str;
    }

    public static boolean getBoolean(HttpServletRequest request, String name) {
        return RequestUtil.getBoolean(request, name, false, false);
    }

    public static boolean getBoolean(HttpServletRequest request, String name, boolean defaultValue) {
        return RequestUtil.getBoolean(request, name, defaultValue, false);
    }

    public static Long getLong(HttpServletRequest request, String name) {
        return RequestUtil.getLong(request, name, null, false);
    }

    public static Long getLong(HttpServletRequest request, String name, long defaultValue) {
        return RequestUtil.getLong(request, name, defaultValue, false);
    }

    public static String getString(HttpServletRequest request, String name) {
        return RequestUtil.getString(request, name, null, false);
    }

    public static String getString(HttpServletRequest request, String name, String defaultValue) {
        return RequestUtil.getString(request, name, defaultValue, false);
    }

    public static String getString(HttpServletRequest request, String name, boolean emptyThrowException) {
        return RequestUtil.getString(request, name, "", emptyThrowException);
    }

    public static String getAjaxString(HttpServletRequest request, String name, boolean emptyThrowException) {
        String str = RequestUtil.getString(request, name, "", emptyThrowException);
        try {
            str = new String(str.getBytes("GBK"), "utf-8");
        }
        catch (Exception var5) {
            request.setAttribute("", (Object)"");
        }
        return str;
    }

    public static Integer getInt(HttpServletRequest request, String name) {
        return RequestUtil.getInt(request, name, null, false);
    }

    public static Integer getInt(HttpServletRequest request, String name, Integer defaultValue) {
        return RequestUtil.getInt(request, name, defaultValue, false);
    }

    public static Integer getInt(HttpServletRequest request, String name, boolean emptyThrowException) {
        return RequestUtil.getInt(request, name, null, emptyThrowException);
    }

    public static String[] getArray(HttpServletRequest request, String name) {
        String[] str = request.getParameterValues(name);
        return str;
    }

    public static String getRequestAtt(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer("");
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            sb.append(name + ":" + request.getAttribute(name).toString() + ";");
        }
        return sb.toString();
    }

    public static String getRequestParam(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer("");
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            sb.append(name + ":" + request.getParameter(name).toString() + ";");
        }
        return sb.toString();
    }

    public static Map<String, String> getRequestParam2Map(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            params.put(name, request.getParameter(name).toString());
        }
        return params;
    }

    public static String getSessionAtt(HttpSession s) {
        StringBuffer sb = new StringBuffer("");
        Enumeration e = s.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            sb.append(name + ":" + s.getAttribute(name).toString() + ";");
        }
        return sb.toString();
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return request.getHeader("x-requested-with") != null && request.getHeader("x-requested-with").toString().trim().equalsIgnoreCase("xmlhttprequest") && request.getParameter("isHtml") == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendText(HttpServletResponse response, String content) {
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.print(content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendJS(HttpServletResponse response, String jsContent) {
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.println("<script type=\"text/javascript\">");
            out.println(jsContent);
            out.println("</script>");
        }
    }

    public static void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

