/*
 * Decompiled with CFR 0.152.
 */
package com.github.devswork.util.excel;

import com.github.devswork.util.excel.DataCell;
import com.github.devswork.util.excel.DataRecord;
import com.github.devswork.util.excel.DataRow;
import java.io.File;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public interface FileToExcelManager {
    default public void saveAsCSV(HttpServletRequest request, HttpServletResponse response, String filename, DataRecord dataRecords) {
        if (dataRecords == null) {
            throw new IllegalArgumentException("can not create Excel");
        }
        if (filename.indexOf(".csv") == -1) {
            filename = filename + ".csv";
        }
        StringBuilder str = new StringBuilder();
        String[] columnName = dataRecords.getColumnName();
        for (int k = 0; k < columnName.length; ++k) {
            if (k > 0) {
                str.append(",");
            }
            str.append("\"");
            str.append(columnName[k]);
            str.append("\"");
        }
        DataRow[] rows = dataRecords.getRow();
        for (int k = 0; k < rows.length; ++k) {
            str.append("\r\n");
            DataCell[] cells = rows[k].getCell();
            for (int i = 0; i < cells.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append("\"");
                str.append(this.toCsvString(cells[i].getContent()));
                str.append("\"");
            }
        }
        response.setCharacterEncoding("UTF-8");
        try {
            response.setContentType("application/vnd.ms-excel; charset=UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=\"" + new String(filename.getBytes("gbk"), "iso8859-1") + "\"");
            ServletOutputStream out_ = response.getOutputStream();
            out_.flush();
            out_.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    default public String toCsvString(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        String newContent = content.replaceAll("\"", "\"\"");
        if (((newContent = newContent.trim()).matches("[\\d]+") || newContent.matches("[\\d.]+")) && (newContent.length() > 11 || newContent.startsWith("0"))) {
            return "\t" + newContent;
        }
        return newContent;
    }

    public void save(HttpServletRequest var1, HttpServletResponse var2, String var3, DataRecord ... var4) throws Exception;

    public List<List<String>> readExcel(File var1) throws Exception;

    public List<List<String>> readExcel(File var1, String var2) throws Exception;

    public List<List<List<String>>> readExcelBySheets(File var1, int ... var2) throws Exception;
}

