/*
 * Decompiled with CFR 0.152.
 */
package com.github.devswork.util.excel;

import com.github.devswork.util.DateUtil;
import com.github.devswork.util.excel.DataCell;
import com.github.devswork.util.excel.DataRecord;
import com.github.devswork.util.excel.FileToExcelManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileToExcelManagerImpl4POI
implements FileToExcelManager {
    private static final Logger log = LoggerFactory.getLogger(FileToExcelManagerImpl4POI.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(HttpServletRequest request, HttpServletResponse response, String fileName, DataRecord ... dataRecords) throws Exception {
        if (fileName.indexOf(".xls") == -1) {
            fileName = fileName + ".xls";
        }
        HSSFWorkbook wb = this.doSheet(dataRecords);
        response.setCharacterEncoding("UTF-8");
        try {
            response.setContentType("application/vnd.ms-excel; charset=UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=\"" + new String(fileName.getBytes("gbk"), "iso8859-1") + "\"");
            ServletOutputStream out_ = response.getOutputStream();
            wb.write((OutputStream)out_);
            out_.flush();
            out_.close();
        }
        catch (Exception e) {
            if (e.getClass().getSimpleName().equals("ClientAbortException")) {
                log.debug(e.getMessage());
            } else {
                log.error("output excel exception", (Throwable)e);
            }
        }
        finally {
            wb = null;
        }
    }

    private HSSFWorkbook doSheet(DataRecord ... dataRecords) throws Exception {
        if (dataRecords == null) {
            throw new IllegalArgumentException("can not create sheet");
        }
        int sheetNum = dataRecords.length;
        if (sheetNum == 0) {
            throw new IllegalArgumentException("can not create sheet");
        }
        HSSFSheet[] sheets = new HSSFSheet[sheetNum];
        DataRecord dataRecord = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle styleTitle = wb.createCellStyle();
        HSSFCellStyle styleColumn = wb.createCellStyle();
        HSSFCellStyle styleContentText = wb.createCellStyle();
        HSSFCellStyle styleContentBlank = wb.createCellStyle();
        HSSFCellStyle styleContentDate = wb.createCellStyle();
        HSSFCellStyle styleContentDatetime = wb.createCellStyle();
        HSSFCellStyle styleContentNumeric = wb.createCellStyle();
        HSSFCellStyle styleContentInteger = wb.createCellStyle();
        this.initStyle(wb, styleTitle, styleColumn, styleContentText, styleContentDate, styleContentDatetime, styleContentNumeric, styleContentInteger);
        for (int i = 0; i < sheetNum; ++i) {
            short[] columnWith;
            int c;
            dataRecord = dataRecords[i];
            if (dataRecord == null) {
                throw new Exception("DataRecord is disabled");
            }
            sheets[i] = wb.createSheet();
            HSSFSheet sheet = sheets[i];
            sheet.setGridsPrinted(true);
            sheet.setHorizontallyCenter(true);
            sheet.setAutobreaks(true);
            wb.setSheetName(i, dataRecord.getSheetName());
            String[] columnName = dataRecord.getColumnName();
            int colunmLength = 0;
            if (columnName != null) {
                colunmLength = columnName.length;
            }
            int rowNumber = 0;
            HSSFRow row = sheet.createRow(rowNumber++);
            row.setHeightInPoints(25.0f);
            HSSFCell cell = row.createCell(0);
            if (colunmLength > 0) {
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, colunmLength - 1));
            }
            cell.setCellValue(dataRecord.getTitle());
            cell.setCellStyle(styleTitle);
            if (dataRecord.getSubTitle() != null) {
                row = sheet.createRow(rowNumber++);
                row.setHeightInPoints(25.0f);
                cell = row.createCell(0);
                if (colunmLength > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(rowNumber - 1, rowNumber - 1, 0, colunmLength - 1));
                }
                cell.setCellValue(dataRecord.getSubTitle());
                cell.setCellStyle(styleContentText);
            }
            boolean isAllNull = true;
            for (c = 0; c < colunmLength; ++c) {
                if (!StringUtils.isNotBlank((CharSequence)columnName[c])) continue;
                isAllNull = false;
                break;
            }
            if (!isAllNull) {
                row = sheet.createRow(rowNumber++);
                row.setHeightInPoints(20.0f);
                for (c = 0; c < colunmLength; ++c) {
                    cell = row.createCell(c);
                    cell.setCellValue(columnName[c]);
                    cell.setCellStyle(styleColumn);
                    cell.setAsActiveCell();
                }
            }
            if ((columnWith = dataRecord.getColumnWith()) != null) {
                for (int j = 0; j < columnWith.length; ++j) {
                    sheet.setColumnWidth(j, new Integer(columnWith[j] * 200).intValue());
                }
            }
            for (int index = 0; index < dataRecord.getRow().length; ++index) {
                row = sheet.createRow(rowNumber++);
                row.setHeightInPoints(20.0f);
                DataCell[] dataCells = dataRecord.getRow()[index].getCell();
                block17: for (int col = 0; col < dataCells.length; ++col) {
                    cell = row.createCell(col);
                    DataCell dataCell = dataCells[col];
                    if (dataCell == null) continue;
                    switch (dataCell.getType()) {
                        case 1: {
                            cell.setCellStyle(styleContentText);
                            cell.setCellValue(dataCell.getContent());
                            continue block17;
                        }
                        case 3: {
                            cell.setCellStyle(styleContentBlank);
                            cell.setCellType(3);
                            cell.setCellValue(dataCell.getContent());
                            continue block17;
                        }
                        case 5: {
                            cell.setCellStyle(styleContentDate);
                            cell.setCellValue(dataCell.getContent());
                            continue block17;
                        }
                        case 6: {
                            cell.setCellStyle(styleContentDatetime);
                            cell.setCellValue(dataCell.getContent());
                            continue block17;
                        }
                        case 0: {
                            cell.setCellStyle(styleContentNumeric);
                            cell.setCellType(0);
                            if (StringUtils.isBlank((CharSequence)dataCell.getContent())) {
                                cell.setCellValue("");
                                continue block17;
                            }
                            try {
                                cell.setCellValue(Double.parseDouble(dataCell.getContent()));
                            }
                            catch (NumberFormatException e) {
                                cell.setCellValue(dataCell.getContent());
                            }
                            continue block17;
                        }
                        case 7: {
                            cell.setCellStyle(styleContentInteger);
                            if (StringUtils.isBlank((CharSequence)dataCell.getContent())) {
                                cell.setCellValue("");
                                continue block17;
                            }
                            try {
                                cell.setCellValue((double)Long.parseLong(dataCell.getContent()));
                            }
                            catch (NumberFormatException e) {
                                cell.setCellValue(dataCell.getContent());
                            }
                            continue block17;
                        }
                        default: {
                            cell.setCellStyle(styleContentText);
                            cell.setCellValue(dataCell.getContent());
                        }
                    }
                }
                HSSFPrintSetup print = sheet.getPrintSetup();
                sheet.setAutobreaks(true);
                print.setPaperSize((short)9);
                print.setFitHeight((short)1);
                print.setFitWidth((short)1);
            }
        }
        return wb;
    }

    private void initStyle(HSSFWorkbook wb, HSSFCellStyle styleTitle, HSSFCellStyle styleColumn, HSSFCellStyle styleContentText, HSSFCellStyle styleContentDate, HSSFCellStyle styleContentDatetime, HSSFCellStyle styleContentNumeric, HSSFCellStyle styleContentInteger) {
        HSSFDataFormat format = wb.createDataFormat();
        HSSFFont fontTitle = wb.createFont();
        fontTitle.setBoldweight((short)700);
        fontTitle.setFontHeightInPoints((short)16);
        styleTitle.setFont(fontTitle);
        styleTitle.setVerticalAlignment((short)1);
        styleTitle.setAlignment((short)2);
        styleTitle.setDataFormat(format.getFormat("text"));
        HSSFFont fontCulumn = wb.createFont();
        fontCulumn.setBoldweight((short)700);
        styleColumn.setFont(fontCulumn);
        styleColumn.setVerticalAlignment((short)1);
        styleColumn.setAlignment((short)2);
        styleColumn.setDataFormat(format.getFormat("text"));
        HSSFFont fontContent = wb.createFont();
        styleContentText.setFont(fontContent);
        styleContentText.setVerticalAlignment((short)1);
        styleContentText.setHidden(true);
        styleContentText.setWrapText(true);
        styleContentText.setDataFormat(format.getFormat("text"));
        styleContentDate.setFont(fontContent);
        styleContentDate.setVerticalAlignment((short)1);
        styleContentDate.setHidden(true);
        styleContentDate.setWrapText(true);
        styleContentDate.setDataFormat(format.getFormat("yyyy-m-d"));
        styleContentDatetime.setFont(fontContent);
        styleContentDatetime.setVerticalAlignment((short)1);
        styleContentDatetime.setHidden(true);
        styleContentDatetime.setWrapText(true);
        styleContentDatetime.setDataFormat(format.getFormat("yyyy-m-d H:mm:ss"));
        styleContentNumeric.setFont(fontContent);
        styleContentNumeric.setVerticalAlignment((short)1);
        styleContentNumeric.setHidden(true);
        styleContentNumeric.setWrapText(true);
        styleContentNumeric.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00"));
        styleContentInteger.setFont(fontContent);
        styleContentInteger.setVerticalAlignment((short)1);
        styleContentInteger.setHidden(true);
        styleContentInteger.setWrapText(true);
        styleContentInteger.setDataFormat(format.getFormat("0"));
    }

    @Override
    public List<List<String>> readExcel(File file) throws Exception {
        List<List<List<String>>> data = this.readExcelBySheets(file, 0);
        if (data != null && !data.isEmpty()) {
            return data.get(0);
        }
        return null;
    }

    @Override
    public List<List<String>> readExcel(File file, String type) throws Exception {
        List<List<List<String>>> data = this.readExcelBySheets(file, type, 0);
        if (data != null && !data.isEmpty()) {
            return data.get(0);
        }
        return null;
    }

    @Override
    public List<List<List<String>>> readExcelBySheets(File file, int ... sheetpages) throws Exception {
        return this.readExcelBySheets(file, null, sheetpages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<List<String>>> readExcelBySheets(File file, String type, int ... sheetpages) throws Exception {
        if (!file.exists()) {
            throw new FileNotFoundException("file not existed");
        }
        if (sheetpages == null || sheetpages.length < 1) {
            throw new FileNotFoundException("have no sheet");
        }
        ArrayList<List<List<String>>> excellists = new ArrayList<List<List<String>>>();
        InputStream in = null;
        try {
            XSSFWorkbook wb = null;
            try {
                in = new FileInputStream(file);
                wb = new XSSFWorkbook(in);
            }
            catch (Exception e) {
                in = new FileInputStream(file);
                wb = new HSSFWorkbook(in);
            }
            for (int i = 0; i < sheetpages.length; ++i) {
                ArrayList excellist = new ArrayList();
                Sheet sheet = null;
                try {
                    sheet = wb.getSheetAt(sheetpages[i]);
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
                int firstRow = sheet.getFirstRowNum();
                int lastRow = sheet.getLastRowNum();
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setGroupingUsed(false);
                for (int s = firstRow; s <= lastRow; ++s) {
                    ArrayList<String> rowlist = new ArrayList<String>();
                    Row row = sheet.getRow(s);
                    if (row != null) {
                        int firstcell = row.getFirstCellNum();
                        short lastcell = row.getLastCellNum();
                        for (int k = 0; k < firstcell; ++k) {
                            rowlist.add("");
                        }
                        for (int m = firstcell; m <= lastcell; ++m) {
                            Cell cell = row.getCell(m);
                            try {
                                if (cell != null && StringUtils.isNotBlank((CharSequence)type)) {
                                    cell.setCellType(Integer.valueOf(type).intValue());
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            String cellValue = "";
                            if (cell != null) {
                                if (cell.getCellType() == 1) {
                                    cellValue = cell.getStringCellValue();
                                } else if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                    cellValue = DateUtil.getStandard19DateAndTime(cell.getDateCellValue());
                                } else if (cell.getCellType() == 0) {
                                    cellValue = numberFormat.format(cell.getNumericCellValue());
                                } else if (cell.getCellType() == 2) {
                                    cell.setCellType(0);
                                    cellValue = String.valueOf(cell.getNumericCellValue());
                                }
                            }
                            rowlist.add(cellValue);
                        }
                    }
                    excellist.add(rowlist);
                }
                excellists.add(excellist);
            }
            wb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            List<List<List<String>>> list = null;
            return list;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return excellists;
    }
}

