/*
 * Decompiled with CFR 0.152.
 */
package com.github.devswork.util.exception;

import com.github.devswork.util.exception.IResultMessage;
import java.text.MessageFormat;
import org.apache.commons.lang3.ArrayUtils;

public class BizException
extends RuntimeException {
    private int errorCode;
    private String errorMsg;
    private String errorMsgForDev;

    public BizException() {
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getErrorMsgForDev() {
        return this.errorMsgForDev;
    }

    public <T extends IResultMessage> BizException(T resultMsg, Object ... args) {
        super("errorCode:" + resultMsg.getCode() + ", errorMsg:" + MessageFormat.format(resultMsg.getMsgForDev(), args));
        this.errorCode = resultMsg.getCode();
        Object[] arguments = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            arguments[i] = String.valueOf(args[i]);
        }
        this.errorMsg = resultMsg.getMsg();
        if (!ArrayUtils.isEmpty((Object[])args)) {
            this.errorMsg = MessageFormat.format(resultMsg.getMsg(), arguments);
        }
        this.errorMsgForDev = resultMsg.getMsgForDev();
        if (!ArrayUtils.isEmpty((Object[])args)) {
            this.errorMsgForDev = MessageFormat.format(resultMsg.getMsgForDev(), arguments);
        }
    }
}

