/*
 * Decompiled with CFR 0.152.
 */
package com.github.devswork.util.json;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSON4FastJSON {
    public static Object toJSON(Object javaObject) {
        ParserConfig mapping = ParserConfig.getGlobalInstance();
        if (javaObject == null) {
            return null;
        }
        if (javaObject instanceof JSON4FastJSON) {
            return javaObject;
        }
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            JSONObject json = null;
            json = javaObject instanceof LinkedHashMap ? new JSONObject(map.size(), true) : new JSONObject(map.size());
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                String jsonKey = TypeUtils.castToString(key);
                Object jsonValue = JSON4FastJSON.toJSON(entry.getValue());
                json.put(jsonKey, jsonValue);
            }
            return json;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            JSONArray array = new JSONArray(collection.size());
            for (Object item : collection) {
                Object jsonValue = JSON4FastJSON.toJSON(item);
                array.add(jsonValue);
            }
            return array;
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isEnum()) {
            return ((Enum)javaObject).name();
        }
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            JSONArray array = new JSONArray(len);
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(javaObject, i);
                Object jsonValue = JSON4FastJSON.toJSON(item);
                array.add(jsonValue);
            }
            return array;
        }
        if (mapping.isPrimitive(clazz)) {
            return javaObject;
        }
        try {
            List getters = TypeUtils.computeGetters(clazz, null);
            JSONObject json = new JSONObject(getters.size());
            for (FieldInfo field : getters) {
                Object value = field.get(javaObject);
                Object jsonValue = JSON4FastJSON.toJSON(value);
                json.put(field.name, jsonValue);
            }
            return json;
        }
        catch (IllegalAccessException e) {
            throw new JSONException("toJSON error", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JSONException("toJSON error", (Throwable)e);
        }
    }
}

