/*
 * Decompiled with CFR 0.152.
 */
package com.github.devswork.util.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.devswork.util.json.JSON4FastJSON;
import com.github.devswork.util.json.OursPropertyFilter;
import com.github.devswork.util.json.OursValueFilter;
import java.util.List;
import java.util.Map;

public class JSONUtil {
    public static final String FORMAT_DATE = "yyyy-MM-dd";
    public static final String FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";

    public static JSONObject parseJsonToJSONObject(String json) {
        return JSON.parseObject((String)json);
    }

    public static Map<String, Object> parseJsonToMap(String jsonString) {
        return JSONUtil.parseJsonToObject(jsonString, Map.class);
    }

    public static <T> T parseJsonToObject(String jsonString, Class<T> c) {
        Object result = null;
        if (jsonString != null && jsonString.length() != 0) {
            result = JSON.parseObject((String)jsonString, c);
        }
        return (T)result;
    }

    public static <T> T parseJsonToObject(String jsonString, Class<T> c, ParseProcess process) {
        Object result = null;
        if (jsonString != null && jsonString.length() != 0) {
            result = JSON.parseObject((String)jsonString, c, (ParseProcess)process, (Feature[])new Feature[0]);
        }
        return (T)result;
    }

    public static <T> List<T> parseJsonToListBean(String jsonString) {
        List result = null;
        if (jsonString != null && jsonString.length() != 0) {
            result = (List)JSON.parseObject((String)jsonString, (TypeReference)new TypeReference<List<T>>(){}, (Feature[])new Feature[0]);
        }
        return result;
    }

    public static List<String> parseJsonToListString(String jsonString) {
        List result = null;
        if (jsonString != null && jsonString.length() != 0) {
            result = (List)JSON.parseObject((String)jsonString, (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
        }
        return result;
    }

    public static List<Map<String, Object>> parseJsonToListMap(String jsonString) {
        List result = null;
        if (jsonString != null && jsonString.length() != 0) {
            result = (List)JSON.parseObject((String)jsonString, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        }
        return result;
    }

    public static <T> T parseObject(String json, TypeReference<T> type) {
        return (T)JSON.parseObject((String)json, type, (Feature[])new Feature[0]);
    }

    public static String[] parseJsonToArray(String jsonString) {
        String[] result = null;
        if (jsonString != null && jsonString.length() != 0) {
            result = (String[])JSON.parseObject((String)jsonString, (TypeReference)new TypeReference<String[]>(){}, (Feature[])new Feature[0]);
        }
        return result;
    }

    public static String toJSON(Object o) {
        return JSON.toJSONString((Object)o, (SerializeFilter)new OursValueFilter(null, null, true), (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object o, String dataFormat) {
        return JSON.toJSONString((Object)o, (SerializeFilter)new OursValueFilter(dataFormat, dataFormat, true), (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object o, String dateFormat, String dateTimeFormat) {
        return JSON.toJSONString((Object)o, (SerializeFilter)new OursValueFilter(dateFormat, dateTimeFormat, true), (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object o, String dataFormat, String dateTimeFormat, boolean isIncludeOrExclude, List<String> fields) {
        OursPropertyFilter filter1 = new OursPropertyFilter(o.getClass(), isIncludeOrExclude, fields);
        OursValueFilter filter2 = new OursValueFilter(dataFormat, dateTimeFormat, true);
        return JSON.toJSONString((Object)o, (SerializeFilter[])new SerializeFilter[]{filter1, filter2}, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object o, boolean isIncludeOrExclude, List<String> fields) {
        OursPropertyFilter filter1 = new OursPropertyFilter(o.getClass(), isIncludeOrExclude, fields);
        return JSON.toJSONString((Object)o, (SerializeFilter[])new SerializeFilter[]{filter1}, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object o, SerializeFilter[] filter) {
        return JSON.toJSONString((Object)o, (SerializeFilter[])filter, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJSON(Object o, SerializeFilter[] filter, SerializerFeature[] features) {
        return JSON.toJSONString((Object)o, (SerializeFilter[])filter, (SerializerFeature[])features);
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> c) {
        if (map == null || c == null) {
            return null;
        }
        Object t = null;
        JSONObject obj = new JSONObject(map);
        t = JSON.toJavaObject((JSON)obj, c);
        return (T)t;
    }

    public static Map<String, Object> beanToMap(Object o) {
        Map map = (Map)JSON4FastJSON.toJSON(o);
        return map;
    }

    public static String[] convert2StringArray(Object obj) {
        if (obj instanceof JSONArray) {
            JSONArray jArray = (JSONArray)obj;
            return JSONUtil.convert2JavaArray(jArray, new String[jArray.size()]);
        }
        return null;
    }

    public static <T> T[] convert2JavaArray(Object obj, T[] t) {
        Object[] ret = null;
        if (obj instanceof JSONArray) {
            JSONArray jArray = (JSONArray)obj;
            ret = jArray.toArray((Object[])t);
        }
        return ret;
    }
}

