/*
 * Decompiled with CFR 0.152.
 */
package com.github.devswork.util.json;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class OursPropertyFilter
implements PropertyPreFilter {
    private final Class<?> clazz;
    private final Set<String> includes = new HashSet<String>();
    private final Set<String> excludes = new HashSet<String>();

    public OursPropertyFilter(boolean isIncludeOrExclude, List<String> properties) {
        this(null, isIncludeOrExclude, properties);
    }

    public OursPropertyFilter(Class<?> clazz, boolean isIncludeOrExclude, List<String> properties) {
        this.clazz = clazz;
        for (String item : properties) {
            if (item == null) continue;
            if (isIncludeOrExclude) {
                this.includes.add(item);
                continue;
            }
            this.excludes.add(item);
        }
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public boolean apply(JSONSerializer serializer, Object source, String name) {
        if (source == null) {
            return true;
        }
        if (this.clazz != null && !this.clazz.isInstance(source)) {
            return true;
        }
        if (this.excludes.contains(name)) {
            return false;
        }
        return this.includes.size() == 0 || this.includes.contains(name);
    }
}

