/*
 * Decompiled with CFR 0.152.
 */
package com.github.devswork.util.json;

import com.alibaba.fastjson.serializer.ValueFilter;
import com.github.devswork.util.DateUtil;
import java.sql.Timestamp;
import java.util.Date;

class OursValueFilter
implements ValueFilter {
    private boolean transLong2String = true;
    private String dateFormat = "yyyy-MM-dd";
    private String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";

    public OursValueFilter(boolean transLong2String) {
        this.initParam(this.dateFormat, this.dateTimeFormat, transLong2String);
    }

    public OursValueFilter(String dateFormat, String dateTimeFormat, boolean transLong2String) {
        this.initParam(dateFormat, dateTimeFormat, transLong2String);
    }

    private void initParam(String dateFormat, String dateTimeFormat, boolean transLong2String) {
        if (dateFormat != null) {
            this.dateFormat = dateFormat;
        }
        if (dateTimeFormat != null) {
            this.dateTimeFormat = dateTimeFormat;
        }
        this.transLong2String = transLong2String;
    }

    public Object process(Object object, String name, Object value) {
        if (value instanceof Timestamp) {
            Timestamp d = (Timestamp)value;
            value = DateUtil.getDate(d, this.dateTimeFormat);
        } else if (value instanceof Date) {
            Date d = (Date)value;
            value = DateUtil.getDate(d, this.dateFormat);
        } else if (value instanceof Long && this.transLong2String) {
            value = value.toString();
        }
        return value;
    }
}

