/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import com.di.kit.ModifierUtil;
import com.di.kit.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassUtil {
    public static boolean isUserClass(Class<?> c) {
        return !c.isPrimitive() && c != Byte.class && c != Short.class && c != Integer.class && c != Long.class && c != Double.class && c != Float.class && c != Character.class && c != String.class && c != Boolean.class && c != java.util.Date.class && c != Date.class && !c.isInterface() && !c.isEnum() && c instanceof Object && c != Object.class && c != Class.class;
    }

    public static boolean isJdkClass(Class<?> clz) {
        return clz != null && clz.getClassLoader() == null;
    }

    public static <T> Object invokeMethod(Method m, T o, Object ... args) {
        try {
            return m.invoke(o, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getBeanFieldsMap(Object o) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Field f : o.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            try {
                m.put(f.getName(), f.get(o));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return m;
    }

    public static <T> Object getFieldValue(Field f, T t) {
        try {
            f.setAccessible(true);
            return f.get(t);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> Object getFieldValue(String fieldName, T t) {
        try {
            Field f = ClassUtil.getDeclaredField(t.getClass(), fieldName);
            f.setAccessible(true);
            return f.get(t);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> Object getFieldValueByGetMethod(Field f, T t) {
        try {
            Method m = null;
            m = f.getType() == Boolean.TYPE || f.getType() == Boolean.class ? ClassUtil.getDeclaredMethod(t.getClass(), "is" + StringUtil.firstCharUpper(f.getName()), new Class[0]) : ClassUtil.getDeclaredMethod(t.getClass(), "get" + StringUtil.firstCharUpper(f.getName()), new Class[0]);
            return m.invoke(t, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> Object getFieldValueByGetMethod(String fieldName, T t) {
        try {
            return ClassUtil.getFieldValueByGetMethod(ClassUtil.getDeclaredField(t.getClass(), fieldName), t);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> void setObjectFieldsValue(Map<String, Object> m, T o) {
        try {
            for (Field f : o.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                if (m.get(f.getName()) == null) continue;
                if (f.getType() == Boolean.TYPE || f.getType() == Boolean.class) {
                    f.set(o, Boolean.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Byte.TYPE || f.getType() == Byte.class) {
                    f.set(o, Byte.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Short.TYPE || f.getType() == Short.class) {
                    f.set(o, Short.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Integer.TYPE || f.getType() == Integer.class) {
                    f.set(o, Integer.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Long.TYPE || f.getType() == Long.class) {
                    f.set(o, Long.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Double.TYPE || f.getType() == Double.class) {
                    f.set(o, Double.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Float.TYPE || f.getType() == Float.class) {
                    f.set(o, Float.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Character.TYPE || f.getType() == Character.class) {
                    f.set(o, m.get(f.getName()));
                    continue;
                }
                if (f.getType() == String.class) {
                    f.set(o, m.get(f.getName()).toString());
                    continue;
                }
                if (f.getType() == java.util.Date.class) {
                    if (m.get(f.getName()).getClass() == String.class) {
                        try {
                            f.set(o, new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(m.get(f.getName()).toString()));
                        }
                        catch (ParseException e) {
                            try {
                                f.set(o, new SimpleDateFormat("yyyy-MM-dd").parse(m.get(f.getName()).toString()));
                            }
                            catch (ParseException e1) {
                                e1.printStackTrace();
                            }
                            e.printStackTrace();
                        }
                        continue;
                    }
                    f.set(o, m.get(f.getName()));
                    continue;
                }
                if (f.getType() == List.class || f.getType() == ArrayList.class) {
                    Type type = f.getGenericType();
                    ParameterizedType pt = (ParameterizedType)type;
                    Type type2 = pt.getActualTypeArguments()[0];
                    String typeName = type2.getTypeName();
                    List os = (List)m.get(f.getName());
                    ArrayList os_ = new ArrayList();
                    for (Object oo : os) {
                        Map m0 = (Map)oo;
                        Object o0 = Class.forName(typeName).newInstance();
                        ClassUtil.setObjectFieldsValue(m0, o0);
                        os_.add(o0);
                    }
                    f.set(o, os_);
                    continue;
                }
                if (!(f.getType() instanceof Object)) continue;
                Object fo = f.getType().newInstance();
                Map m0 = (Map)m.get(f.getName());
                ClassUtil.setObjectFieldsValue(m0, fo);
                f.set(o, fo);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static <T> Field getDeclaredField(Class<T> t, String fieldName) {
        for (Class<T> clazz = t; clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static List<Field> getDeclaredFields(Class<?> t) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = t; clazz != Object.class && clazz != Class.class && clazz != Field.class; clazz = clazz.getSuperclass()) {
            try {
                for (Field f : clazz.getDeclaredFields()) {
                    int modifiers = f.getModifiers();
                    if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || Modifier.isNative(modifiers) || Modifier.isTransient(modifiers)) continue;
                    fields.add(f);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fields;
    }

    public static <T> Method getDeclaredMethod(Class<T> t, String methodName, Class<?> ... parameterTypes) {
        for (Class<T> clazz = t; clazz != Object.class && clazz != Class.class; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static <T> List<Method> getDeclaredMethods(Class<T> t) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<T> clazz = t; clazz != Object.class && clazz != Class.class; clazz = clazz.getSuperclass()) {
            try {
                for (Method m : clazz.getDeclaredMethods()) {
                    if (!ModifierUtil.isCommon(m.getModifiers())) continue;
                    methods.add(m);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return methods;
    }

    public static Class<?> getByClassName(String className) {
        if (className.equals("byte.class")) {
            return Byte.TYPE;
        }
        if (className.equals("short.class")) {
            return Short.TYPE;
        }
        if (className.equals("int.class")) {
            return Integer.TYPE;
        }
        if (className.equals("long.class")) {
            return Long.TYPE;
        }
        if (className.equals("double.class")) {
            return Double.TYPE;
        }
        if (className.equals("float.class")) {
            return Float.TYPE;
        }
        if (className.equals("boolean.class")) {
            return Boolean.TYPE;
        }
        if (className.equals("char.class")) {
            return Character.TYPE;
        }
        if (className.equals("String.class")) {
            return String.class;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Class<?> getFieldListType(Field f) {
        ParameterizedType pt = (ParameterizedType)f.getGenericType();
        Type t = pt.getActualTypeArguments()[0];
        return (Class)t;
    }

    public static boolean isListField(Field f) {
        return f.getType() == List.class || f.getType() == Collection.class || f.getType() == ArrayList.class;
    }

    public static Class<?> getFieldArrayType(Field f) {
        return f.getType().getComponentType();
    }
}

