/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import java.security.MessageDigest;

public class EncryptionUtil {
    private static final String CODES = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    public static String base64DecodeString(String input) {
        return new String(EncryptionUtil.base64Decode(input));
    }

    public static byte[] base64Decode(String input) {
        if (input.length() % 4 != 0) {
            throw new IllegalArgumentException("Invalid base64 input");
        }
        byte[] decoded = new byte[input.length() * 3 / 4 - (input.indexOf(61) > 0 ? input.length() - input.indexOf(61) : 0)];
        char[] inChars = input.toCharArray();
        int j = 0;
        int[] b = new int[4];
        for (int i = 0; i < inChars.length; i += 4) {
            b[0] = CODES.indexOf(inChars[i]);
            b[1] = CODES.indexOf(inChars[i + 1]);
            b[2] = CODES.indexOf(inChars[i + 2]);
            b[3] = CODES.indexOf(inChars[i + 3]);
            decoded[j++] = (byte)(b[0] << 2 | b[1] >> 4);
            if (b[2] >= 64) continue;
            decoded[j++] = (byte)(b[1] << 4 | b[2] >> 2);
            if (b[3] >= 64) continue;
            decoded[j++] = (byte)(b[2] << 6 | b[3]);
        }
        return decoded;
    }

    public static String base64Encode(String s) {
        return EncryptionUtil.base64Encode(s.getBytes());
    }

    public static String base64Encode(byte[] in) {
        StringBuilder out = new StringBuilder(in.length * 4 / 3);
        for (int i = 0; i < in.length; i += 3) {
            int b = (in[i] & 0xFC) >> 2;
            out.append(CODES.charAt(b));
            b = (in[i] & 3) << 4;
            if (i + 1 < in.length) {
                out.append(CODES.charAt(b |= (in[i + 1] & 0xF0) >> 4));
                b = (in[i + 1] & 0xF) << 2;
                if (i + 2 < in.length) {
                    out.append(CODES.charAt(b |= (in[i + 2] & 0xC0) >> 6));
                    b = in[i + 2] & 0x3F;
                    out.append(CODES.charAt(b));
                    continue;
                }
                out.append(CODES.charAt(b));
                out.append('=');
                continue;
            }
            out.append(CODES.charAt(b));
            out.append("==");
        }
        return out.toString();
    }

    public String md5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = s.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String shaEncode(String inStr) throws Exception {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }
        byte[] byteArray = inStr.getBytes("UTF-8");
        byte[] md5Bytes = sha.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }
}

