/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileUtil {
    public static void writeString(String path, String content) {
        FileUtil.writeString(path, content, false);
    }

    public static void writeString(String path, String content, boolean append) {
        try {
            File f = new File(path);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f, append);
            fw.write(content);
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File f, String nameAndPath) {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(f);
            out = new FileOutputStream(nameAndPath);
            byte[] bytes = new byte[1024];
            while (((InputStream)in).read(bytes) != -1) {
                out.write(bytes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(byte[] bytes, String nameAndPath) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(nameAndPath);
            ((OutputStream)out).write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String readString(String path, String format) {
        String str = "";
        try {
            FileInputStream in = new FileInputStream(path);
            int size = in.available();
            byte[] buffer = new byte[size];
            in.read(buffer);
            in.close();
            str = new String(buffer, format == null ? "utf-8" : format);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    public static String readStringRelative(String relativePath, String format) {
        return FileUtil.readString(FileUtil.getRealPath(relativePath), format);
    }

    public static byte[] readBytesRelative(String relativePath, String format) {
        return FileUtil.readBytes(FileUtil.getRealPath(relativePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(String path) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int n = 0;
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static byte[] readBytesByNio(String path) throws IOException {
        File f = new File(path);
        if (!f.exists()) {
            throw new FileNotFoundException(path);
        }
        AbstractInterruptibleChannel channel = null;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(f);
            channel = fs.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)((FileChannel)channel).size());
            while (((FileChannel)channel).read(byteBuffer) > 0) {
            }
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                channel.close();
                fs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] readBytesLarge(String filename) throws IOException {
        AbstractInterruptibleChannel fc = null;
        try {
            fc = new RandomAccessFile(filename, "r").getChannel();
            MappedByteBuffer byteBuffer = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)fc).size()).load();
            byte[] result = new byte[(int)((FileChannel)fc).size()];
            if (byteBuffer.remaining() > 0) {
                byteBuffer.get(result, 0, byteBuffer.remaining());
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                fc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getRealPath(String relativePath) {
        String path = relativePath;
        File f = new File(path);
        if (!f.exists()) {
            try {
                path = Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            path = path + relativePath;
            f = new File(path);
            if (!f.exists()) {
                if (path.indexOf("test-classes") != -1) {
                    path = path.replaceFirst("test-classes", "classes");
                }
                if (!(f = new File(path)).exists()) {
                    System.err.println(relativePath + " not found");
                }
            }
        }
        return path;
    }

    public static byte[] readResBytesInJar(Class<?> jarClass, String filename) throws IOException {
        InputStream is = jarClass.getResourceAsStream("/" + filename);
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bs = new byte[1024];
        while (bis.read(bs) != -1) {
            out.write(bs);
        }
        return out.toByteArray();
    }

    public static String readResStringInJar(Class<?> jarClass, String filename, String encode) throws IOException {
        InputStream is = jarClass.getResourceAsStream("/" + filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encode == null || encode.isEmpty() ? "UTF-8" : encode));
        StringBuilder sb = new StringBuilder();
        String s = "";
        while ((s = br.readLine()) != null) {
            sb.append(s).append("\r\n");
        }
        return sb.toString();
    }
}

