/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class IdGenerator {
    private static final SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
    private static AtomicLong lastTime = IdGenerator.getMinute();
    private static final long maxCount = 999998L;
    private static AtomicInteger count = new AtomicInteger(1);
    private static AtomicBoolean run = new AtomicBoolean(false);

    public static void start() {
        run.getAndSet(true);
        Calendar date = Calendar.getInstance();
        date.set(date.get(1), date.get(2), date.get(5), date.get(10), date.get(12), date.get(13));
        long period = 1000L;
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                AtomicLong newTime = IdGenerator.getMinute();
                if (newTime.get() > lastTime.get()) {
                    lastTime = newTime;
                    count.set(1);
                }
                if (!run.get()) {
                    this.cancel();
                }
            }
        }, date.getTime(), period);
    }

    public static final long nextId() throws RuntimeException {
        if ((long)count.get() > 999998L) {
            throw new RuntimeException("\u4ea7\u751f\u7684id\u8d85\u8fc7\u6700\u5927\u9650\u5236");
        }
        return IdGenerator.getId();
    }

    private static long getId() {
        return lastTime.get() + (long)count.getAndIncrement();
    }

    private static AtomicLong getMinute() {
        return new AtomicLong(Long.valueOf(df.format(new Date()) + "000000"));
    }
}

