/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.JDBCType;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public enum JDBCTypeEnum {
    STRING(String.class, JDBCType.CHAR, JDBCType.VARCHAR, JDBCType.LONGVARCHAR, JDBCType.NUMERIC),
    BIGDECIMAL(BigDecimal.class, JDBCType.NUMERIC, JDBCType.DECIMAL),
    BOOLEAN(new Class[]{Boolean.TYPE, Boolean.class}, JDBCType.BIT, JDBCType.BOOLEAN),
    BYTE(new Class[]{Byte.TYPE, Byte.class}, JDBCType.TINYINT),
    SHORT(new Class[]{Short.TYPE, Short.class}, JDBCType.SMALLINT),
    INT(new Class[]{Integer.TYPE, Integer.class}, JDBCType.INTEGER),
    LONG(new Class[]{Long.TYPE, Long.class}, JDBCType.BIGINT),
    FLOAT(new Class[]{Float.TYPE, Float.class}, JDBCType.REAL),
    DOUBLE(new Class[]{Double.TYPE, Double.class}, JDBCType.FLOAT, JDBCType.DOUBLE),
    DATE(java.sql.Date.class, JDBCType.DATE),
    TIME(Time.class, JDBCType.TIME),
    TIMESTAMP(Timestamp.class, JDBCType.TIMESTAMP),
    DATETIME(Date.class, new JDBCType[0]),
    CLOB(Clob.class, JDBCType.CLOB),
    BLOB(Blob.class, JDBCType.DATALINK),
    ARRAY(Array.class, JDBCType.ARRAY),
    REF(Ref.class, JDBCType.REF),
    URL(URL.class, JDBCType.DATALINK),
    BYTE_ARRAY(byte[].class, JDBCType.BINARY, JDBCType.VARBINARY, JDBCType.LONGVARBINARY);

    private JDBCType[] jdbcTypes;
    private Class<?>[] javaTypes;

    private JDBCTypeEnum(Class<?>[] javaTypes, JDBCType ... jdbcTypes) {
        this.jdbcTypes = jdbcTypes;
        this.javaTypes = javaTypes;
    }

    private JDBCTypeEnum(Class<?> javaType, JDBCType ... jdbcTypes) {
        this.jdbcTypes = jdbcTypes;
        this.javaTypes = new Class[]{javaType};
    }

    public JDBCType[] getJdbcTypes() {
        return this.jdbcTypes;
    }

    public Class<?>[] getJavaTypes() {
        return this.javaTypes;
    }

    public Class<?> getJavaType() {
        return this.getJavaType(null);
    }

    public Class<?> getJavaType(Boolean isPrimitive) {
        block3: {
            block2: {
                if (isPrimitive == null || !isPrimitive.booleanValue()) break block2;
                for (Class<?> c : this.javaTypes) {
                    if (!c.isPrimitive()) continue;
                    return c;
                }
                break block3;
            }
            if (isPrimitive == null || isPrimitive.booleanValue()) break block3;
            for (Class<?> c : this.javaTypes) {
                if (c.isPrimitive()) continue;
                return c;
            }
        }
        return this.javaTypes[0];
    }

    public static JDBCTypeEnum getByJdbcType(String jdbcType) {
        jdbcType = jdbcType.replaceAll("UNSIGNED", "").trim();
        for (JDBCTypeEnum e : JDBCTypeEnum.values()) {
            if (e.getJdbcTypes() != null && e.getJavaTypes().length > 0) {
                for (JDBCType jt : e.getJdbcTypes()) {
                    if (!jt.name().equalsIgnoreCase(jdbcType)) continue;
                    return e;
                }
                continue;
            }
            for (Class<?> c : e.getJavaTypes()) {
                if (!c.getSimpleName().equalsIgnoreCase(jdbcType)) continue;
                return e;
            }
        }
        return STRING;
    }
}

