/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import java.io.File;
import java.net.URISyntaxException;

public class PathUtil {
    public static String getClassPath() {
        try {
            return Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static String getMavenProjectPath() {
        String classPath = PathUtil.getClassPath();
        if (null != classPath && classPath.contains("/target/classes/")) {
            classPath = classPath.replaceFirst("/target/classes/", "/");
        } else if (null != classPath && classPath.contains("/target/test-classes/")) {
            classPath = classPath.replaceFirst("/target/test-classes/", "/");
        }
        return classPath;
    }

    public static String getMavenSrcPath() {
        return PathUtil.getMavenProjectPath() + "src/";
    }

    public static String getMavenResPath() {
        return PathUtil.getMavenProjectPath() + "resources/";
    }

    public static String getMavenWebappPath() {
        return PathUtil.getMavenProjectPath() + "src/main/webapp/";
    }

    public static String getAntProjectPath() {
        String classPath = PathUtil.getClassPath();
        if (null != classPath && classPath.contains("/build/classes/")) {
            classPath = classPath.replaceFirst("/build/classes/", "/");
        }
        return classPath;
    }

    public static String getProjectPath() {
        String classPath = PathUtil.getClassPath();
        if (classPath.endsWith("/target/classes/")) {
            classPath = classPath.replaceFirst("/target/classes/", "/");
        } else if (classPath.endsWith("/build/test-classes/")) {
            classPath = classPath.replaceFirst("/build/test-classes/", "/");
        } else if (classPath.endsWith("/build/classes/")) {
            classPath = classPath.replaceFirst("/build/classes/", "/");
        } else if (classPath.endsWith("/WebContent/WEB-INF/lib/")) {
            classPath = classPath.replaceFirst("/WebContent/WEB-INF/lib/", "/");
        } else if (classPath.endsWith("/WebRoot/WEB-INF/lib/")) {
            classPath = classPath.replaceFirst("/WebRoot/WEB-INF/lib/", "/");
        }
        return classPath;
    }

    public static boolean isMaven() {
        File f = new File(PathUtil.getMavenProjectPath() + "pom.xml");
        return f.exists();
    }
}

