/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import com.di.kit.ClassCreate;
import com.di.kit.ClassUtil;
import com.di.kit.Str;
import com.di.kit.StringUtil;
import com.di.kit.data.annotation.Alias;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Xml {
    private static String start = "<![CDATA[";
    private static String end = "]]>";

    public static <T> String toXml(T o) {
        String n = StringUtil.firstCharLower(o.getClass().getSimpleName());
        if (o.getClass().isAnnotationPresent(Alias.class)) {
            if (!o.getClass().getAnnotation(Alias.class).xml().isEmpty()) {
                n = o.getClass().getAnnotation(Alias.class).xml();
            } else if (!o.getClass().getAnnotation(Alias.class).value().isEmpty()) {
                n = o.getClass().getAnnotation(Alias.class).value();
            }
        }
        Str str = new Str();
        str.add("<").add(n).add(">");
        if (o.getClass() == Byte.TYPE || o.getClass() == Short.TYPE || o.getClass() == Integer.TYPE || o.getClass() == Long.TYPE || o.getClass() == Double.TYPE || o.getClass() == Float.TYPE || o.getClass() == Byte.class || o.getClass() == Short.class || o.getClass() == Integer.class || o.getClass() == Long.class || o.getClass() == Double.class || o.getClass() == Float.class || o.getClass() == Boolean.TYPE || o.getClass() == Boolean.class || o.getClass() == String.class || o.getClass() == Character.class) {
            if (String.valueOf(o).indexOf("<") != -1) {
                str.add(start + " ").add(o).add(" " + end);
            } else {
                str.add(o);
            }
            str.add("</").add(n).add(">");
            return str.toString();
        }
        if (o.getClass().isArray()) {
            str = new Str().add("<").add(n).add(">");
            List os = (List)o;
            for (Object o0 : os) {
                str.add(Xml.toXml(o0));
            }
            str.add("</").add(n).add(">");
            return str.toString();
        }
        if (o.getClass() == List.class || o.getClass() == ArrayList.class) {
            str = new Str().add("<").add(n).add(">");
            List os = (List)o;
            for (Object o0 : os) {
                str.add(Xml.toXml(o0));
            }
            str.add("</").add(n).add(">");
            return str.toString();
        }
        if (o.getClass() == Map.class || o.getClass() == LinkedHashMap.class) {
            Map m0 = (Map)o;
            for (Object key : m0.keySet()) {
                str.add("<").add(key).add(">").add(Xml.toXml(m0.get(key))).add("</").add(key).add(">");
            }
        } else if (o instanceof Object) {
            try {
                for (Field f : ClassUtil.getDeclaredFields(o.getClass())) {
                    f.setAccessible(true);
                    if (f.get(o) == null) continue;
                    String n0 = f.getName();
                    if (n0.equals("attributes")) {
                        Object attr = f.get(o);
                        Str str1 = new Str();
                        for (Field ff : attr.getClass().getDeclaredFields()) {
                            ff.setAccessible(true);
                            String nn = ff.getName();
                            if (ff.isAnnotationPresent(Alias.class)) {
                                if (!ff.getAnnotation(Alias.class).xml().isEmpty()) {
                                    nn = ff.getAnnotation(Alias.class).xml();
                                } else if (!ff.getAnnotation(Alias.class).value().isEmpty()) {
                                    nn = ff.getAnnotation(Alias.class).value();
                                }
                            }
                            str1.add(nn).add("=\"").add(ff.get(attr)).add("\" ");
                        }
                        str.replaceFirst("<" + n + ">", "<" + n + " " + str1.deleteLastChar().toString() + ">");
                        continue;
                    }
                    if (f.isAnnotationPresent(Alias.class)) {
                        if (!f.getAnnotation(Alias.class).xml().isEmpty()) {
                            n0 = f.getAnnotation(Alias.class).xml();
                        } else if (!f.getAnnotation(Alias.class).value().isEmpty()) {
                            n0 = f.getAnnotation(Alias.class).value();
                        }
                    }
                    if (Modifier.isFinal(f.getModifiers())) continue;
                    if (f.getType() == Byte.TYPE || f.getType() == Short.TYPE || f.getType() == Integer.TYPE || f.getType() == Long.TYPE || f.getType() == Double.TYPE || f.getType() == Float.TYPE || f.getType() == Byte.class || f.getType() == Short.class || f.getType() == Integer.class || f.getType() == Long.class || f.getType() == Double.class || f.getType() == Float.class || f.getType() == Boolean.TYPE || f.getType() == Boolean.class || f.getType() == String.class || f.getType() == Character.class) {
                        str.add("<").add(n0).add(">");
                        if (String.valueOf(f.get(o)).indexOf("<") != -1) {
                            str.add(start + " ").add(f.get(o)).add(" " + end);
                        } else {
                            str.add(f.get(o));
                        }
                        str.add("</").add(n0).add(">");
                        continue;
                    }
                    if (f.getType() == List.class || f.getType() == ArrayList.class) {
                        str.add("<").add(n0).add(">");
                        List os = (List)f.get(o);
                        for (Object o0 : os) {
                            str.add(Xml.toXml(o0));
                        }
                        str.add("</").add(n0).add(">");
                        continue;
                    }
                    if (f.getType() == Map.class || f.getType() == LinkedHashMap.class) {
                        Map m0 = (Map)f.get(o);
                        str.add("<").add(n0).add(">");
                        for (Object key : m0.keySet()) {
                            str.add("<").add(key).add(">").add(m0.get(key)).add("</").add(key).add(">");
                        }
                        str.add("</").add(n0).add(">");
                        continue;
                    }
                    if (f.getDeclaringClass() == Object.class || !(f.getType() instanceof Object)) continue;
                    str.add(Xml.toXml(f.get(o)));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        str.add("</").add(n).add(">");
        return str.toString();
    }

    public static <T> T toObject(String xml, Class<T> cl) {
        Map<String, Object> o = null;
        if (cl == Collection.class || cl == List.class || cl == ArrayList.class) {
            List<Object> l = Xml.toList(xml);
            return (T)l;
        }
        if (cl == Map.class || cl == LinkedHashMap.class) {
            Map<String, Object> m;
            o = m = Xml.toMap(xml);
        } else {
            try {
                Map<String, Object> m = Xml.toMap(xml);
                o = cl.newInstance();
                Xml.set(m, o);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return (T)o;
    }

    private static <T> void set(Map<String, Object> m, T o) {
        ClassUtil.setObjectFieldsValue(m, o);
    }

    public static Map<String, Object> toMap(String xml) {
        if ((xml = xml.trim()).startsWith("<?xml")) {
            xml = xml.substring(xml.indexOf("?>") + 2).trim();
        }
        if (xml.startsWith("<!DOCTYPE")) {
            xml = xml.substring(xml.indexOf(">") + 1).trim();
        }
        if (xml.startsWith(start)) {
            xml = xml.substring(xml.indexOf(start) + 1).trim();
            xml = xml.substring(xml.lastIndexOf(end) + 1).trim();
        }
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        Xml.put(m, "element attributes", Xml.getAttributes(xml));
        Xml.put(m, "element name", Xml.getWrapperName(xml));
        String wrapperNameValue = Xml.getWrapperValue(xml).trim();
        if (wrapperNameValue.indexOf("<") == -1 || Character.isLetter(wrapperNameValue.charAt(0))) {
            String wrapperName = Xml.getWrapperName(xml);
            String wrapperValue = Xml.getWrapperValue(xml);
            m.put(wrapperName, wrapperValue);
            return m;
        }
        xml = Xml.getWrapperValue(xml);
        List<String> split = Xml.split(xml);
        for (String s : split) {
            String name = Xml.getWrapperName(s);
            if (Xml.getAttributes(s) != null) {
                Xml.put(m, name, split.size() == 1 ? Xml.toMap(Xml.getWrapperValue(s)) : Xml.toMap(s));
                continue;
            }
            String value = Xml.getWrapperValue(s);
            if (!value.startsWith("<") && !value.startsWith(start)) {
                Xml.put(m, name, value);
                continue;
            }
            if (value.startsWith(start)) {
                Xml.put(m, name, Xml.replaceEscape(value));
                continue;
            }
            if (value.startsWith("<") && !Xml.isList(value)) {
                Xml.put(m, name, Xml.toMap(s));
                continue;
            }
            if (!Xml.isList(value)) continue;
            Xml.put(m, name, Xml.toList(value));
        }
        return m;
    }

    private static void put(Map<String, Object> m, String k, Object v) {
        if (m.containsKey(k)) {
            Object val = m.get(k);
            if (val.getClass() == ArrayList.class || val.getClass() == List.class) {
                List os = (List)val;
                os.add(v);
                m.put(k, os);
            } else {
                ArrayList<Object> os = new ArrayList<Object>();
                os.add(val);
                os.add(v);
                m.put(k, os);
            }
        } else {
            m.put(k, v);
        }
    }

    private static boolean isList(String xml) {
        String n1 = Xml.getWrapperName(xml);
        if (xml.indexOf("</" + n1 + ">") == -1) {
            return false;
        }
        return xml.substring(xml.indexOf("</" + n1 + ">")).indexOf("<" + n1 + ">") > -1;
    }

    private static List<Object> toList(String xml) {
        ArrayList<Object> ls = new ArrayList<Object>();
        for (String s : Xml.split(xml)) {
            if (Xml.isList(s)) {
                ls.add(Xml.toList(s));
                continue;
            }
            ls.add(Xml.toMap(s));
        }
        return ls;
    }

    private static Map<String, String> getAttributes(String xml) {
        String s = Xml.sub(xml, "<", ">");
        String[] ss = s.split(" ");
        if (ss.length == 1) {
            return null;
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        for (int i = 1; i < ss.length; ++i) {
            String s0 = ss[i].trim();
            if (s0.isEmpty() || s0.split("=").length <= 1) continue;
            m.put(s0.split("=")[0], Xml.delQuot(s0.split("=")[1]));
        }
        return m;
    }

    private static String sub(String s, String start, String end) {
        int s1 = s.indexOf(start) + start.length();
        int s2 = s.indexOf(end);
        if (0 < s1 && s1 < s2) {
            return s.substring(s1, s2);
        }
        return s.replaceFirst("<", "").replaceFirst(">", "");
    }

    private static String delQuot(String s) {
        int start = 0;
        int end = s.length();
        if (s.indexOf(34) > 0) {
            start = s.indexOf(34);
        }
        if (s.lastIndexOf(34) > start) {
            end = s.lastIndexOf(34);
        }
        return s.substring(start + 1, end);
    }

    private static String getWrapperName(String xml) {
        return xml.substring(xml.indexOf("<") > -1 ? xml.indexOf("<") + 1 : 0, xml.indexOf(">") > -1 ? xml.indexOf(">") : xml.length()).split(" ")[0];
    }

    private static String getWrapperValue(String xml) {
        char[] cs = xml.trim().toCharArray();
        if (cs.length > 5 && cs[0] == '<' && cs[1] != '/' && cs[1] != '[' && cs[cs.length - 1] == '>' && cs[cs.length - 2] != ']') {
            int begin = xml.indexOf(">") > 0 ? xml.indexOf(">") + 1 : 0;
            int end = xml.lastIndexOf("</") > 0 ? xml.lastIndexOf("</") : xml.length();
            xml = xml.substring(begin, end);
        }
        return xml;
    }

    private static String replaceEscape(String xml) {
        return xml.substring(xml.indexOf(start) + 9, xml.lastIndexOf(end));
    }

    private static List<String> split(String xml) {
        int i = 0;
        int left = 0;
        int right = 0;
        int close = 0;
        char[] cs = xml.toCharArray();
        ArrayList<Integer> ls = new ArrayList<Integer>();
        block4: while (i < cs.length) {
            switch (cs[i]) {
                case '<': {
                    if (i == 0 || xml.indexOf(start, i - 1) != i) {
                        if (cs[i + 1] != '/') {
                            ++left;
                            break;
                        }
                        ++close;
                        break;
                    }
                    if (xml.indexOf(start, i - 1) != i) break;
                    i = xml.indexOf(end, i) + 3;
                    continue block4;
                }
                case '>': {
                    if (cs[i - 1] != ']' && cs[i - 2] != ']') {
                        ++right;
                    }
                    if (left + close != right || left != close) break;
                    ls.add(i);
                    break;
                }
            }
            ++i;
        }
        ArrayList<String> ss = new ArrayList<String>();
        if (ls.size() == 0) {
            ss.add(xml);
        } else if (ls.size() == 1) {
            ss.add(xml.substring(0, (Integer)ls.get(0) + 1));
            ss.add(xml.substring((Integer)ls.get(0) + 1));
        } else if (ls.size() > 1) {
            ss.add(xml.substring(0, (Integer)ls.get(0) + 1));
            for (int j = 0; j < ls.size() - 1; ++j) {
                ss.add(xml.substring((Integer)ls.get(j) + 1, (Integer)ls.get(j + 1) + 1));
            }
        }
        return ss;
    }

    public static void createFromXml(String xml, String packag) {
        ClassCreate.createFromXml(xml, packag, "");
    }

    public static void main(String[] args) {
        String s = "SELECT * FROM `user` WHERE `del_flag` <![CDATA[ >= ]]> 0 AND `id` = #{id}";
        String value = Xml.getWrapperValue(s);
        System.out.println(value);
    }

    public static enum XmlEscape {
        AND('&', "a"),
        LESS('<', "&lt;"),
        GREAT('>', "&gt;"),
        QUOT('\"', "&quot;"),
        APOS('\'', "&apos;");

        private char ch;
        private String value;

        private XmlEscape(char ch, String value) {
            this.value = value;
            this.ch = ch;
        }

        public static String escape(char c) {
            for (XmlEscape xe : XmlEscape.values()) {
                if (xe.ch != c) continue;
                return xe.value;
            }
            return null;
        }

        public static char unEscape(String s) {
            for (XmlEscape xe : XmlEscape.values()) {
                if (!xe.value.equals(s)) continue;
                return xe.ch;
            }
            return ' ';
        }
    }
}

