/*
 * Decompiled with CFR 0.152.
 */
package com.di.socket;

import com.di.kit.ClassUtil;
import com.di.kit.Json;
import com.di.socket.Handler;
import com.di.socket.Heartbeat;
import com.di.socket.ServiceMethod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;

public class SimpleSocketServer
implements Runnable,
Handler {
    private Socket socket;
    InputStream inputStream = null;
    OutputStream outputStream = null;
    ByteArrayInputStream in;
    ByteArrayOutputStream out;

    public SimpleSocketServer(Socket socket) throws IOException {
        this.socket = socket;
    }

    @Override
    public void run() {
        try {
            while (!this.socket.isClosed()) {
                long l1 = System.currentTimeMillis();
                BufferedReader br = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                StringBuffer buffer = new StringBuffer();
                String line = "";
                while ((line = br.readLine()) != null) {
                    buffer.append(line);
                }
                System.out.println("\u63a5\u6536\u5ba2\u6237\u7aef\u53cd\u9988: " + buffer.toString());
                if (!this.socket.isInputShutdown()) {
                    this.socket.shutdownInput();
                }
                ServiceMethod method = Json.fromJson(buffer.toString(), ServiceMethod.class);
                System.out.println("\u6536\uff1a" + Thread.currentThread().getId() + ":" + buffer.toString());
                Object writeObject = this.handler(method);
                System.out.println("\u53d1:" + Thread.currentThread().getId() + ":" + writeObject);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                bw.write(Json.toJsonString(writeObject));
                bw.flush();
                br.close();
                bw.close();
                if (!this.socket.isClosed() && !this.socket.isOutputShutdown()) {
                    this.socket.shutdownOutput();
                }
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
                long l2 = System.currentTimeMillis();
                System.out.println("\u8017\u65f6:" + (l2 - l1) + "ms");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public Object handler(Object obj) {
        if (obj instanceof Heartbeat) {
            return Integer.MIN_VALUE;
        }
        if (obj instanceof ServiceMethod) {
            ServiceMethod method = (ServiceMethod)obj;
            try {
                Class<?> c = Class.forName(method.getClassName());
                Class[] parameterTypes = null;
                if (method.getParamTypes().length > 0) {
                    parameterTypes = new Class[method.getParamTypes().length];
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        parameterTypes[i] = ClassUtil.getByClassName(method.getParamTypes()[i]);
                    }
                }
                Method declaredMethod = ClassUtil.getDeclaredMethod(c, method.getMethodName(), parameterTypes);
                return declaredMethod.invoke(c.newInstance(), method.getParamValues());
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        ServerSocket ss = new ServerSocket(6666);
        System.out.println("start server");
        while (true) {
            Socket accept = ss.accept();
            System.out.println("start handler request.");
            new SimpleSocketServer(accept).run();
        }
    }
}

