/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ConnectionUtil {
    public static String postMultipart(String requestUrl, Map<String, Object> params) {
        String res = null;
        String BOUNDARY = "--boundary--";
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(3000);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.1; zh-CN; rv:1.9.2.6)");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            StringBuffer sb = new StringBuffer();
            if (params != null) {
                for (String key : params.keySet()) {
                    Object v = params.get(key);
                    if (v == null) continue;
                    sb.append("\r\n--").append(BOUNDARY).append("\r\n");
                    if (v.getClass() == File.class) {
                        File file = (File)v;
                        String fileName = file.getName();
                        String contentType = ContentTypeEnum.getMimeByFileExt(fileName);
                        sb.append("Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + fileName + "\"\r\n");
                        sb.append("Content-Type:" + contentType + "\r\n\r\n");
                        DataInputStream in = new DataInputStream(new FileInputStream(file));
                        byte[] bufferOut = new byte[1024];
                        while (in.read(bufferOut) != -1) {
                            sb.append(new String(bufferOut));
                        }
                        in.close();
                        continue;
                    }
                    sb.append("Content-Disposition: form-data; name=\"" + key + "\"\r\n\r\n").append(String.valueOf(v));
                }
            }
            sb.append("\r\n--" + BOUNDARY + "--\r\n");
            conn.setRequestProperty("Content-Length", sb.toString().getBytes().length + "");
            OutputStream out = conn.getOutputStream();
            out.write(sb.toString().getBytes());
            out.flush();
            out.close();
            StringBuffer strBuf = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                strBuf.append(line);
            }
            res = strBuf.toString();
            reader.close();
            reader = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static <T extends Map<String, ?>> String get(String url, T args) {
        String params;
        StringBuilder sb = new StringBuilder();
        for (String key : args.keySet()) {
            try {
                sb.append(URLEncoder.encode(key, "utf-8")).append("=").append(URLEncoder.encode(args.get(key).toString(), "utf-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        String string = params = sb.toString().length() > 0 ? sb.toString().substring(0, sb.toString().length() - 1) : "";
        if (url.startsWith("https")) {
            return ConnectionUtil.https(url, "get", params);
        }
        return ConnectionUtil.sendGet(url, params);
    }

    public static <T extends Map<String, ?>> String post(String url, T args) {
        String params;
        StringBuilder sb = new StringBuilder();
        for (String key : args.keySet()) {
            try {
                sb.append(URLEncoder.encode(key, "utf-8")).append("=").append(URLEncoder.encode(args.get(key).toString(), "utf-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        String string = params = sb.toString().length() > 0 ? sb.toString().substring(0, sb.toString().length() - 1) : "";
        if (url.startsWith("https")) {
            return ConnectionUtil.https(url, "post", params);
        }
        return ConnectionUtil.sendPost(url, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGet(String url, String params) {
        String result = null;
        BufferedReader in = null;
        try {
            String line;
            String urlName = url + "?" + params;
            URL realUrl = new URL(urlName);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0(compatible;MSIE)");
            conn.connect();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, String params) {
        PrintWriter out = null;
        BufferedReader br = null;
        String result = "";
        try {
            String line;
            URL realURL = new URL(url);
            URLConnection conn = realURL.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0(compatible;MSIE)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(params);
            out.flush();
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = br.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String https(String requestUrl, String requestMethod, String paramsStr) {
        String res = null;
        StringBuffer buffer = new StringBuffer();
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpsURLConnection httpUrlConn = (HttpsURLConnection)url.openConnection();
            httpUrlConn.setSSLSocketFactory(ssf);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            httpUrlConn.connect();
            if (null != paramsStr) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(paramsStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            res = buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String request, PostContentTypeEnum postContentTypeEnum) {
        PrintWriter out = null;
        BufferedReader br = null;
        String result = "";
        try {
            String line;
            URL realURL = new URL(url);
            URLConnection conn = realURL.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0(compatible;MSIE)");
            switch (postContentTypeEnum.getValue()) {
                case "application/json": {
                    conn.setRequestProperty("Content-Type", "application/json;charset=utf-8");
                    break;
                }
                case "text/xml": {
                    conn.setRequestProperty("Content-Type", "text/xml;charset=utf-8");
                    break;
                }
                default: {
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
                }
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(request);
            out.flush();
            br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = br.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static enum ContentTypeEnum {
        BMP(".bmp", "application/x-bmp"),
        DOC(".doc", "application/msword"),
        GIF(".gif", "image/gif"),
        HTML(".html", "text/html"),
        ICO(".ico", "image/x-icon"),
        IMG(".img", "application/x-img"),
        JAVA(".java", "java/*"),
        JPEG(".jpeg", "image/jpeg"),
        JPG(".jpg", "application/x-jpg"),
        JSP(".jsp", "text/html"),
        MP4(".mp4", "video/mpeg4"),
        MPEG(".mpeg", "video/mpg"),
        PNG(".png", "application/x-png"),
        PPT(".ppt", "application/x-ppt"),
        RM(".rm", "application/vnd.rn-realmedia"),
        SWF(".swf", "application/x-shockwave-flash"),
        TIF(".tif", "image/tiff"),
        WAV(".wav", "audio/wav"),
        WMA(".wma", "audio/x-ms-wma"),
        WMV(".wmv", "video/x-ms-wmv"),
        XHTML(".xhtml", "text/html"),
        XLS(".xls", "application/x-xls"),
        XML(".xml", "text/xml"),
        EXE(".exe", "application/x-msdownload"),
        HTM(".htm", "text/html"),
        JS(".js", "application/x-javascript"),
        MP3(".mp3", "audio/mp3"),
        CSS(".css", "text/css");

        String fileExt;
        String mimeType;

        private ContentTypeEnum(String fileExt, String mimeType) {
            this.fileExt = fileExt;
            this.mimeType = mimeType;
        }

        public String getFileExt() {
            return this.fileExt;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public static String getMimeByFileExt(String fileName) {
            for (ContentTypeEnum ct : ContentTypeEnum.values()) {
                if (!fileName.endsWith(ct.getFileExt())) continue;
                return ct.getMimeType();
            }
            return "text/html";
        }
    }

    public static enum ContentType {

    }

    public static enum PostContentTypeEnum {
        application("application/x-www-form-urlencoded"),
        multipart("multipart/form-data"),
        json("application/json"),
        xml("text/xml");

        private String value;

        private PostContentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    static class MyX509TrustManager
    implements X509TrustManager {
        X509TrustManager sunJSSEX509TrustManager;

        MyX509TrustManager() throws Exception {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream("trustedCerts"), "passphrase".toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            tmf.init(ks);
            TrustManager[] tms = tmf.getTrustManagers();
            for (int i = 0; i < tms.length; ++i) {
                if (!(tms[i] instanceof X509TrustManager)) continue;
                this.sunJSSEX509TrustManager = (X509TrustManager)tms[i];
                return;
            }
            throw new Exception("Couldn't initialize");
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.sunJSSEX509TrustManager.checkClientTrusted(chain, authType);
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            try {
                this.sunJSSEX509TrustManager.checkServerTrusted(arg0, arg1);
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.sunJSSEX509TrustManager.getAcceptedIssuers();
        }
    }
}

