/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static Date now() {
        return new Date();
    }

    public static Date todayStart() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.now());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date todayEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.now());
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date addDays(int days) {
        return DateUtil.addDays(DateUtil.now(), days);
    }

    public static Date addDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date addWeeks(int weeks) {
        return DateUtil.addWeeks(DateUtil.now(), weeks);
    }

    public static Date addWeeks(Date date, int weeks) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(3, weeks);
        return calendar.getTime();
    }

    public static Date addMonths(int months) {
        return DateUtil.addMonths(DateUtil.now(), months);
    }

    public static Date addMonths(Date date, int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static Date addYears(int years) {
        return DateUtil.addYears(DateUtil.now(), years);
    }

    public static Date addYears(Date date, int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        return calendar.getTime();
    }

    public static Date previousYear() {
        return DateUtil.addYears(-1);
    }

    public static Date nextYear() {
        return DateUtil.addYears(1);
    }

    public static Date previousMonth() {
        return DateUtil.addMonths(-1);
    }

    public static Date nextMonth() {
        return DateUtil.addMonths(1);
    }

    public static Date previousDay() {
        return DateUtil.addDays(-1);
    }

    public static Date nextDay() {
        return DateUtil.addDays(1);
    }

    public static double daysRangeBySecond(Date date1, Date date2) {
        long time1 = date1.getTime();
        long time2 = date2.getTime();
        double between_days = (time2 - time1) / 86400000L;
        return (double)Math.round(between_days * 10.0) / 10.0;
    }

    public static int daysRangeByDay(Date date1, Date date2) {
        Calendar can1 = Calendar.getInstance();
        can1.setTime(date1);
        Calendar can2 = Calendar.getInstance();
        can2.setTime(date2);
        int year1 = can1.get(1);
        int year2 = can2.get(1);
        int days = 0;
        Calendar can = null;
        if (can1.before(can2)) {
            days -= can1.get(6);
            days += can2.get(6);
            can = can1;
        } else {
            days -= can2.get(6);
            days += can1.get(6);
            can = can2;
        }
        for (int i = 0; i < Math.abs(year2 - year1); ++i) {
            days += can.getActualMaximum(6);
            can.add(1, 1);
        }
        return days;
    }

    public static Date addSeconds(int seconds) {
        return new Date(new Date().getTime() + (long)(seconds * 1000));
    }

    public static Date addMinutes(int minutes) {
        return DateUtil.addSeconds(minutes * 60);
    }

    public static Date addHours(int hours) {
        return DateUtil.addMinutes(hours * 60);
    }

    public static Date currentMonthStart() {
        return DateUtil.addMonthsStart(0);
    }

    public static Date currentMonthEnd() {
        return DateUtil.addMonthsEnd(0);
    }

    public static Date addMonthsStart(int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, months);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date addMonthsEnd(int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, months);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static int currentMonthIndex() {
        SimpleDateFormat sdf = new SimpleDateFormat("MM");
        String format = sdf.format(new Date());
        return Integer.valueOf(format);
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static long currentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long nanoTime() {
        return System.nanoTime();
    }

    public static String format(Date date) {
        return DateUtil.format(date, DATE_TIME_FORMAT);
    }

    public static String format(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static Date parse(String date) {
        return DateUtil.parse(date, DATE_TIME_FORMAT);
    }

    public static Date parse(String date, String pattern) {
        try {
            return new SimpleDateFormat(pattern).parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date max(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (date1.after(date2)) {
            return date1;
        }
        return date2;
    }

    public static Date min(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (date1.before(date2)) {
            return date1;
        }
        return date2;
    }
}

