/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import com.di.kit.Property;
import com.di.kit.StringUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JdbcMeta {
    Connection conn;
    String driver;
    String url;
    String username;
    String password;

    public JdbcMeta setConfig(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
        return this;
    }

    private Connection getConn() throws SQLException {
        if (this.conn == null || this.conn.isClosed()) {
            Property property = new Property("jdbc.properties");
            if (this.url == null || this.url.isEmpty()) {
                this.url = property.get("jdbc.url");
            }
            if (this.username == null || this.username.isEmpty()) {
                this.username = property.get("jdbc.username");
            }
            if (this.password == null || this.password.isEmpty()) {
                this.password = property.get("jdbc.password");
            }
            if (this.driver == null || this.driver.isEmpty()) {
                this.driver = DriverEnum.getByURL(this.url).name;
            }
            try {
                Driver driver1 = (Driver)Class.forName(this.driver).newInstance();
                DriverManager.registerDriver(driver1);
                this.conn = DriverManager.getConnection(this.url, this.username, this.password);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
                e.printStackTrace();
            }
        }
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Table> getTables(String url, String username, String password, String ... tables) {
        try (JdbcMeta jm = new JdbcMeta().setConfig(url, username, password);){
            if (tables == null) {
                List<Table> list = jm.getAllTables();
                return list;
            }
            ArrayList<Table> ts = new ArrayList<Table>();
            for (String t : tables) {
                ts.add(jm.getTable(t));
            }
            ArrayList<Table> arrayList = ts;
            return arrayList;
        }
        return new ArrayList<Table>();
    }

    public Table getTable(String tableName) throws SQLException {
        String catalog = this.getConn().getCatalog();
        Table table = new Table();
        table.setName(tableName);
        ResultSet primaryKeyResultSet = this.getConn().getMetaData().getPrimaryKeys(null, null, tableName);
        HashMap<String, String> primaryKeyMap = new HashMap<String, String>();
        while (primaryKeyResultSet.next()) {
            String primaryKeyColumnName = primaryKeyResultSet.getString("COLUMN_NAME");
            primaryKeyMap.put(primaryKeyColumnName, primaryKeyColumnName);
        }
        ResultSet foreignKeyResultSet = this.getConn().getMetaData().getImportedKeys(catalog, null, tableName);
        HashMap<String, ImportKey> foreignKeyMap = new HashMap<String, ImportKey>();
        while (foreignKeyResultSet.next()) {
            ImportKey importKey = new ImportKey();
            importKey.setName(foreignKeyResultSet.getString("FKCOLUMN_NAM"));
            importKey.setPkTableName(foreignKeyResultSet.getString("PKTABLE_NAME"));
            importKey.setPkColumnName(foreignKeyResultSet.getString("PKCOLUMN_NAME"));
            foreignKeyMap.put(importKey.getName(), importKey);
        }
        ResultSet columnSet = this.getConn().getMetaData().getColumns(null, "%", tableName, "%");
        ArrayList<Column> columns = new ArrayList<Column>();
        ArrayList<Column> primaryColumns = new ArrayList<Column>();
        ArrayList<Column> allColumns = new ArrayList<Column>();
        while (columnSet.next()) {
            Column c = new Column();
            c.setName(columnSet.getString("COLUMN_NAME"));
            c.setType(Type.getBySql(columnSet.getString("TYPE_NAME")));
            c.setNullable(columnSet.getInt("NULLABLE") != 1);
            c.setRemark(StringUtil.escape(columnSet.getString("REMARKS")));
            c.setPrimaryKey(primaryKeyMap.get(c.getName()) != null);
            c.setImportKey((ImportKey)foreignKeyMap.get(c.getName()));
            c.setLength(columnSet.getInt("COLUMN_SIZE"));
            if (c.isPrimaryKey()) {
                primaryColumns.add(c);
            } else {
                columns.add(c);
            }
            allColumns.add(c);
        }
        table.setColumns(columns);
        table.setPrimaryKeys(primaryColumns);
        table.setAllColumns(allColumns);
        table.setComment(this.getComment(tableName));
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Table> getAllTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        ResultSet tablesResultSet = null;
        try {
            String catalog = this.getConn().getCatalog();
            tablesResultSet = this.getConn().getMetaData().getTables(catalog, null, null, new String[]{"TABLE"});
            while (tablesResultSet.next()) {
                String tableName = tablesResultSet.getString("TABLE_NAME");
                tables.add(this.getTable(tableName));
            }
        }
        catch (SQLException e) {
            System.err.println("get all tables error:" + e.getMessage());
        }
        finally {
            try {
                if (tablesResultSet != null && !tablesResultSet.isClosed()) {
                    tablesResultSet.close();
                    tablesResultSet = null;
                }
            }
            catch (SQLException sQLException) {}
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getComment(String table) {
        String comment = "";
        ResultSet rs = null;
        try {
            rs = this.getConn().createStatement().executeQuery("SHOW CREATE TABLE " + table);
            if (rs != null && rs.next()) {
                String create = rs.getString(2);
                int index = create.indexOf("COMMENT='");
                if (index < 0) {
                    String string = "";
                    return string;
                }
                comment = create.substring(index + 9);
                comment = comment.substring(0, comment.length() - 1);
                try {
                    comment = new String(comment.getBytes("utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SQLException e) {
            System.err.println("get table comment error:" + e.getMessage());
        }
        finally {
            try {
                if (rs != null && rs.isClosed()) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return StringUtil.escape(comment);
    }

    public void close() {
        try {
            if (this.conn != null && this.conn.isClosed()) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static enum DriverEnum {
        MYSQL("com.mysql.jdbc.Driver", "jdbc:mysql"),
        MS_SQL("net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sqlserver"),
        MS_SQL1("net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sybase"),
        ORACLE("oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin"),
        SYBASE("com.sybase.jdbc2.jdbc.SybDriver", "jdbc:sybase:Tds"),
        POSTGRESQL("org.postgresql.Driver", "jdbc:postgresql");

        private String name;
        private String prefix;

        public String getName() {
            return this.name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        private DriverEnum(String name, String prefix) {
            this.name = name;
            this.prefix = prefix;
        }

        public static DriverEnum getByURL(String url) {
            for (DriverEnum d : DriverEnum.values()) {
                if (!url.startsWith(d.getPrefix())) continue;
                return d;
            }
            return MYSQL;
        }
    }

    public static enum Type {
        BIT("bit", Boolean.TYPE, Boolean.class),
        TINYINT("tinyint", Byte.TYPE, Byte.class),
        SMALLINT("smallint", Short.TYPE, Short.class),
        MEDIUMINT("mediumint", Integer.TYPE, Integer.class),
        INT("int", Integer.TYPE, Integer.class),
        INTEGER("integer", Integer.class),
        BIGINT("bigint", Long.TYPE, Long.class),
        DOUBLE("double", Double.TYPE, Double.class),
        FLOAT("float", Float.TYPE, Float.class),
        CHAR("char", String.class),
        VARCHAR("varchar", String.class),
        TEXT("text", String.class),
        DATE("date", Date.class),
        TIME("time", Time.class),
        TIME_STAMP("timestamp", java.util.Date.class, Timestamp.class),
        DATE_TIME("datetime", java.util.Date.class),
        DECIMAL("decimal", BigDecimal.class),
        BINARY("binary", byte[].class),
        VARBINARY("varbinary", byte[].class),
        TINYBLOB("tinyblob", byte[].class),
        BLOB("blob", byte[].class),
        MEDIUMBLOB("mediumblob", byte[].class),
        LONGBLOB("longblob", byte[].class);

        private String sql;
        private Class<?>[] java;

        private Type(String sql, Class<?> ... java) {
            this.java = java;
            this.sql = sql;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public Class<?> getJava() {
            return this.getJava(null);
        }

        public Class<?> getJava(Boolean nullable) {
            if (nullable == null) {
                nullable = false;
            }
            for (Class<?> c : this.java) {
                if (nullable.booleanValue() && !c.isPrimitive()) {
                    return c;
                }
                if (nullable.booleanValue() || !c.isPrimitive()) continue;
                return c;
            }
            return this.java[0];
        }

        public String getJavaString(Boolean nullable) {
            Class<?> java2 = this.getJava(nullable);
            if (java2.getName().startsWith("java.lang.")) {
                return java2.getSimpleName();
            }
            return java2.getName();
        }

        public void setJava(Class<?>[] java) {
            this.java = java;
        }

        public static Type getBySql(String sql) {
            sql = sql.replaceAll("UNSIGNED", "").trim();
            for (Type t : Type.values()) {
                if (!t.getSql().equalsIgnoreCase(sql)) continue;
                return t;
            }
            return VARCHAR;
        }
    }

    public static class ImportKey {
        private String name;
        private String pkTableName;
        private String pkColumnName;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPkTableName() {
            return this.pkTableName;
        }

        public void setPkTableName(String pkTableName) {
            this.pkTableName = pkTableName;
        }

        public String getPkColumnName() {
            return this.pkColumnName;
        }

        public void setPkColumnName(String pkColumnName) {
            this.pkColumnName = pkColumnName;
        }
    }

    public static class Column {
        private String name;
        private boolean primaryKey;
        private Type type;
        private String remark;
        private ImportKey importKey;
        private boolean nullable;
        private int length;

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        public ImportKey getImportKey() {
            return this.importKey;
        }

        public void setImportKey(ImportKey importKey) {
            this.importKey = importKey;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public void setPrimaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }
    }

    public static class Table {
        private String name;
        private List<Column> primaryKeys;
        private List<Column> columns;
        private List<Column> allColumns;
        private String comment;

        public List<Column> getAllColumns() {
            return this.allColumns;
        }

        public void setAllColumns(List<Column> allColumns) {
            this.allColumns = allColumns;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<Column> getColumns() {
            return this.columns;
        }

        public void setColumns(List<Column> columns) {
            this.columns = columns;
        }

        public List<Column> getPrimaryKeys() {
            return this.primaryKeys;
        }

        public void setPrimaryKeys(List<Column> primaryKeys) {
            this.primaryKeys = primaryKeys;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

