/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import com.di.kit.ClassUtil;
import com.di.kit.Str;
import com.di.kit.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Json {
    SimpleDateFormat sdf;
    boolean camelCaseToUnderscores = false;
    static Json json;

    public Json setDateFormat(String pattern) {
        this.sdf = new SimpleDateFormat(pattern);
        return this;
    }

    private SimpleDateFormat getDateFormat() {
        if (this.sdf == null) {
            this.sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return this.sdf;
    }

    public Json setCamelCaseToUnderscores(boolean camelCaseToUnderscores) {
        this.camelCaseToUnderscores = camelCaseToUnderscores;
        return this;
    }

    public static Json getJson() {
        if (json == null) {
            json = new Json();
        }
        return json;
    }

    private List<String> split(String json) {
        int ang1 = 0;
        int ang2 = 0;
        int squa1 = 0;
        int squa2 = 0;
        int quot = 0;
        ArrayList<Integer> is = new ArrayList<Integer>();
        ArrayList<String> ss = new ArrayList<String>();
        block8: for (int off = 0; off < json.length(); ++off) {
            char c = json.charAt(off);
            switch (c) {
                case '\"': {
                    if (off != 0 && json.charAt(off - 1) == '\\') continue block8;
                    ++quot;
                    continue block8;
                }
                case '{': {
                    if (quot % 2 != 0) continue block8;
                    ++ang1;
                    continue block8;
                }
                case '}': {
                    if (quot % 2 != 0) continue block8;
                    ++ang2;
                    continue block8;
                }
                case '[': {
                    if (quot % 2 != 0) continue block8;
                    ++squa1;
                    continue block8;
                }
                case ']': {
                    if (quot % 2 != 0) continue block8;
                    ++squa2;
                    continue block8;
                }
                case ',': {
                    if (quot % 2 != 0 || ang1 != ang2 || squa1 != squa2) continue block8;
                    is.add(off);
                    continue block8;
                }
            }
        }
        if (is.size() > 1) {
            ss.add(json.substring(0, (Integer)is.get(0)));
            for (int i = 0; i < is.size() - 1; ++i) {
                ss.add(json.substring((Integer)is.get(i) + 1, (Integer)is.get(i + 1)));
            }
            ss.add(json.substring((Integer)is.get(is.size() - 1) + 1));
        } else if (is.size() == 1) {
            ss.add(json.substring(0, (Integer)is.get(0)));
            ss.add(json.substring((Integer)is.get(0) + 1));
        } else {
            ss.add(json);
        }
        return ss;
    }

    public static <T> T fromJson(String json, Class<T> c) {
        return Json.getJson().toObject(json, c);
    }

    public static String toJsonString(Object o) {
        return Json.getJson().toJson(o);
    }

    public <T> String toJson(T o) {
        if (o == null) {
            return null;
        }
        if (o.getClass() == Byte.TYPE || o.getClass() == Short.TYPE || o.getClass() == Integer.TYPE || o.getClass() == Long.TYPE || o.getClass() == Double.TYPE || o.getClass() == Float.TYPE || o.getClass() == Byte.class || o.getClass() == Short.class || o.getClass() == Integer.class || o.getClass() == Long.class || o.getClass() == Double.class || o.getClass() == Float.class || o.getClass() == Boolean.TYPE || o.getClass() == Boolean.class || o.getClass() == String.class || o.getClass() == Character.class) {
            return String.valueOf(o);
        }
        if (o.getClass() == java.util.Date.class || o.getClass() == Date.class || o.getClass() == Time.class) {
            return this.getDateFormat().format(o);
        }
        if (o.getClass().isArray()) {
            Object[] os;
            Str str = new Str().add("[");
            for (Object o0 : os = (Object[])o) {
                if (o0.getClass() == String.class || o0.getClass() == java.util.Date.class) {
                    str.add("\"").add(this.toJson(o0)).add("\",");
                    continue;
                }
                str.add(this.toJson(o0)).add(",");
            }
            return str.delLastChar().add("]").toString();
        }
        if (o.getClass() == List.class || o.getClass() == ArrayList.class) {
            Str str = new Str().add("[");
            List os = (List)o;
            for (Object o0 : os) {
                if (o0.getClass() == String.class || o0.getClass() == java.util.Date.class) {
                    str.add("\"").add(this.toJson(o0)).add("\",");
                    continue;
                }
                str.add(this.toJson(o0)).add(",");
            }
            return str.delLastChar().add("]").toString();
        }
        if (o instanceof Object && o.getClass() != Object.class && o.getClass() != Class.class) {
            Str str = new Str().add("{");
            try {
                for (Field f : ClassUtil.getDeclaredFields(o.getClass())) {
                    f.setAccessible(true);
                    if (f.get(o) == null) continue;
                    String n0 = f.getName();
                    Object v = f.get(o);
                    if (f.getType() == String.class || f.getType() == java.util.Date.class) {
                        str.add("\"").add(n0).add("\":\"").add(this.toJson(v)).add("\",");
                        continue;
                    }
                    str.add("\"").add(n0).add("\":").add(this.toJson(v)).add(",");
                }
                str.deleteLastChar();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return str.add("}").toString();
        }
        return null;
    }

    public <T> T toObject(String json, Class<T> c) {
        if (json == null && !c.isPrimitive()) {
            return null;
        }
        if ((json == null || json.isEmpty()) && c.isPrimitive()) {
            throw new IllegalArgumentException("json is null or empty that can't be transform to primitive Class.");
        }
        Object o = null;
        json = json.trim();
        o = this.toObjectVal(this.toObject(json), c);
        return (T)o;
    }

    public <T> List<T> toObjects(String json, Class<T> c) {
        if (json == null && !c.isPrimitive()) {
            return null;
        }
        if ((json == null || json.isEmpty()) && c.isPrimitive()) {
            throw new IllegalArgumentException("json is null or empty that can't be transform to primitive Class.");
        }
        ArrayList list = new ArrayList();
        json = json.trim();
        this.toObjectVal(this.toObject(json), List.class);
        return list;
    }

    private Object toObjectVal(Object val, Class<?> c) {
        try {
            if (val == null) {
                return null;
            }
            if (c == Boolean.TYPE || c == Boolean.class) {
                return Boolean.valueOf(String.valueOf(val));
            }
            if (c == Character.TYPE || c == Character.class) {
                return new Character(String.valueOf(val).charAt(0));
            }
            if (c == Byte.TYPE || c == Byte.class) {
                return Byte.valueOf(String.valueOf(val));
            }
            if (c == Short.TYPE || c == Short.class) {
                return Short.valueOf(String.valueOf(val));
            }
            if (c == Integer.TYPE || c == Integer.class) {
                return Integer.valueOf(String.valueOf(val));
            }
            if (c == Long.TYPE || c == Long.class) {
                return Long.valueOf(String.valueOf(val));
            }
            if (c == Float.TYPE || c == Float.class) {
                return Float.valueOf(String.valueOf(val));
            }
            if (c == Double.TYPE || c == Double.class) {
                return Double.valueOf(String.valueOf(val));
            }
            if (c == java.util.Date.class) {
                return this.getDateFormat().parse(String.valueOf(val));
            }
            if (c == Date.class) {
                return new Date(this.getDateFormat().parse(String.valueOf(val)).getTime());
            }
            if (c == Time.class) {
                return new Time(this.getDateFormat().parse(String.valueOf(val)).getTime());
            }
            if (c == String.class) {
                return String.valueOf(val);
            }
            if (c.isArray() && val != null) {
                List ss = (List)val;
                Class<?> type = c.getComponentType();
                if (type == String.class) {
                    String[] os = new String[ss.size()];
                    for (int i = 0; i < os.length; ++i) {
                        os[i] = this.toObject(String.valueOf(ss.get(i)), String.class);
                    }
                    return os;
                }
                Object[] os = new Object[ss.size()];
                for (int i = 0; i < os.length; ++i) {
                    os[i] = this.toObject(String.valueOf(ss.get(i)), type);
                }
                return os;
            }
            if (c == List.class || c == ArrayList.class) {
                return val;
            }
            if (c == Map.class || c == HashMap.class || c == LinkedHashMap.class) {
                return val;
            }
            if (c != Object.class && c != Class.class && c instanceof Object && val != null) {
                Map map = (Map)val;
                Object o = c.newInstance();
                for (Field f : ClassUtil.getDeclaredFields(c)) {
                    Object v;
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    if ((v = map.get(f.getName())) != null && (f.getType() == List.class || f.getType() == ArrayList.class)) {
                        ParameterizedType pt = (ParameterizedType)f.getGenericType();
                        Type t = pt.getActualTypeArguments()[0];
                        List vs = (List)v;
                        ArrayList<Object> ts = new ArrayList<Object>();
                        for (Object ov : vs) {
                            ts.add(this.toObjectVal(ov, (Class)t));
                        }
                        f.set(o, ts);
                        continue;
                    }
                    f.set(o, this.toObjectVal(v, f.getType()));
                }
                return o;
            }
        }
        catch (ClassCastException e1) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return val;
    }

    public Object toObject(String json) {
        if ((json = json.trim()).startsWith("{")) {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            String s0 = json.substring(json.indexOf("{") + 1, json.lastIndexOf("}")).trim();
            for (String s : this.split(s0)) {
                String k = s.substring(0, s.indexOf(":") - 1).replaceAll("\"", "").trim();
                if (this.camelCaseToUnderscores) {
                    k = StringUtil.snakeCase(k);
                }
                String v = s.substring(s.indexOf(":") + 1).trim();
                m.put(k, this.toObject(v));
            }
            return m;
        }
        if (json.startsWith("[")) {
            String s0 = json.substring(json.indexOf("[") + 1, json.lastIndexOf("]")).trim();
            ArrayList<Object> ls = new ArrayList<Object>();
            if (s0.startsWith("{") || s0.startsWith("[")) {
                for (String s1 : this.split(s0)) {
                    ls.add(this.toObject(s1));
                }
            } else {
                for (String s : s0.split(",")) {
                    ls.add(s.replaceAll("\"", ""));
                }
            }
            return ls;
        }
        return json.replaceAll("\"", "");
    }
}

