/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import com.di.kit.FileUtil;
import com.di.kit.IdWorker;
import com.di.kit.JdbcMeta;
import com.di.kit.PathUtil;
import com.di.kit.Str;
import com.di.kit.StringUtil;
import com.di.kit.XmlBuilder;
import java.io.File;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class MvcGenerater {
    private JdbcMeta jdbcMeta;
    private PersistenceEnum persistence;
    private ControlEnum control;
    private ViewEnum view;
    private Class<?> entityBaseClass;
    private Class<?> mapperBaseClass;
    private Class<?> serviceBaseClass;
    private Class<?> controlBaseClass;
    private String licenses;
    private String author = "MvcGenerator by d";
    private String viewHeader;
    private String viewFooter;
    private boolean entityLicenses = false;
    private boolean serviceLicenses = false;
    private boolean controlLicenses = false;
    private boolean mapperLicenses = false;
    private boolean lombok = false;
    private boolean war = false;
    private boolean swaggerEntity = false;
    private String tablePrefix;
    private boolean primitive = true;
    private boolean baseColumnList = false;
    private boolean generateCrud = true;
    private List<JdbcMeta.Table> tables = new ArrayList<JdbcMeta.Table>();
    private String entityPackage;
    private String mapperPackage;
    private String servicePackage;
    private String controlPackage;
    private boolean jpaAnnotation = false;
    private Class<?> serviceInterface;
    private String serviceInterfacePackage;
    private Class<?> serviceImpl;
    private String serviceImplPackage;
    String path = null;
    private HashMap<JdbcMeta.Type, Class<? extends Serializable>> tyeAdaptor = new HashMap();

    public MvcGenerater() {
        this.path = this.getPath();
    }

    public MvcGenerater(String url, String username, String password) {
        this.jdbcMeta = new JdbcMeta().setConfig(url, username, password);
        this.path = this.getPath();
    }

    public MvcGenerater setGenerateCrud(boolean generateCrud) {
        this.generateCrud = generateCrud;
        return this;
    }

    public MvcGenerater setBaseColumnList(boolean baseColumnList) {
        this.baseColumnList = baseColumnList;
        return this;
    }

    public MvcGenerater setPrimitive(boolean primitive) {
        this.primitive = primitive;
        return this;
    }

    public MvcGenerater setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
        return this;
    }

    String replacePrefix(String s) {
        if (this.tablePrefix != null && !this.tablePrefix.isEmpty()) {
            return s.replaceFirst(this.tablePrefix, "");
        }
        return s;
    }

    public MvcGenerater setPersistence(PersistenceEnum persistence) {
        this.persistence = persistence;
        return this;
    }

    public MvcGenerater setWar(boolean war) {
        this.war = war;
        return this;
    }

    public MvcGenerater setControl(ControlEnum control) {
        this.control = control;
        return this;
    }

    public MvcGenerater setView(ViewEnum view) {
        this.view = view;
        return this;
    }

    public <T> MvcGenerater setEntityBaseClass(Class<T> entityBaseClass) {
        this.entityBaseClass = entityBaseClass;
        return this;
    }

    public <T> MvcGenerater setMapperBaseClass(Class<T> mapperBaseClass) {
        this.mapperBaseClass = mapperBaseClass;
        return this;
    }

    public <T> MvcGenerater setServiceBaseClass(Class<T> serviceBaseClass) {
        this.serviceBaseClass = serviceBaseClass;
        return this;
    }

    public <T> MvcGenerater setControlBaseClass(Class<T> controlBaseClass) {
        this.controlBaseClass = controlBaseClass;
        return this;
    }

    public MvcGenerater setLicenses(String licenses) {
        this.licenses = licenses;
        return this;
    }

    public MvcGenerater setAuthor(String author) {
        this.author = author;
        return this;
    }

    public MvcGenerater setViewHeader(String viewHeader) {
        this.viewHeader = viewHeader;
        return this;
    }

    public MvcGenerater setViewFooter(String viewFooter) {
        this.viewFooter = viewFooter;
        return this;
    }

    public MvcGenerater setEntityLicenses(boolean entityLicenses) {
        this.entityLicenses = entityLicenses;
        return this;
    }

    public MvcGenerater setServiceLicenses(boolean serviceLicenses) {
        this.serviceLicenses = serviceLicenses;
        return this;
    }

    public MvcGenerater setControlLicenses(boolean controlLicenses) {
        this.controlLicenses = controlLicenses;
        return this;
    }

    public MvcGenerater setMapperLicenses(boolean mapperLicenses) {
        this.mapperLicenses = mapperLicenses;
        return this;
    }

    public MvcGenerater setLombok(boolean lombok) {
        this.lombok = lombok;
        return this;
    }

    public MvcGenerater setSwaggerEntity(boolean swaggerEntity) {
        this.swaggerEntity = swaggerEntity;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MvcGenerater setTables(String ... tableNames) {
        try {
            if (tableNames == null || tableNames.length == 0) {
                this.tables = this.jdbcMeta.getAllTables();
            } else {
                for (String n : tableNames) {
                    this.tables.add(this.jdbcMeta.getTable(n));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.jdbcMeta.close();
        }
        return this;
    }

    public MvcGenerater jpaAnnotation(boolean jpaAnnotation) {
        this.jpaAnnotation = jpaAnnotation;
        return this;
    }

    public MvcGenerater createEntity(String entityPackage) {
        return this.createEntity(entityPackage, false);
    }

    public MvcGenerater createEntity(String entityPackage, boolean replace) {
        this.entityPackage = entityPackage;
        for (JdbcMeta.Table t : this.tables) {
            String upper;
            String lower;
            Str s = new Str();
            String className = StringUtil.camelCase(this.replacePrefix(t.getName()));
            className = StringUtil.firstUpper(className);
            if (this.licenses != null && !this.licenses.isEmpty() && this.entityLicenses) {
                s.line(this.licenses);
            }
            s.add("package ").add(entityPackage).line(";").newLine();
            if (this.lombok) {
                s.line("import lombok.Data;");
            }
            if (this.swaggerEntity) {
                s.line("import io.swagger.annotations.ApiModel;");
                s.line("import io.swagger.annotations.ApiModelProperty;");
            }
            if (this.jpaAnnotation) {
                s.line("import javax.persistence.Table;");
            }
            if (this.entityBaseClass == null) {
                s.line("import java.io.Serializable;");
                s.line("/**").add(" * ").line(t.getComment()).line(" * @author " + this.author);
                s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
                s.line(" */");
                if (this.lombok) {
                    s.line("@Data");
                }
                if (this.swaggerEntity) {
                    s.add("@ApiModel(\"").add(t.getComment()).line("\")");
                }
                if (this.jpaAnnotation) {
                    s.add("@Table(name = \"").add(t.getName()).line("\")");
                }
                s.add("public class ").add(className).line(" implements Serializable {");
                s.add("\tprivate static final long serialVersionUID = ").add(IdWorker.nextId()).line("L;");
                for (JdbcMeta.Column c1 : t.getAllColumns()) {
                    lower = StringUtil.camelCase(c1.getName());
                    if (this.contain(this.entityBaseClass, lower)) continue;
                    if (!c1.getRemark().isEmpty()) {
                        if (this.swaggerEntity) {
                            s.add("    @ApiModelProperty(\"").add(c1.getRemark()).line("\")");
                        } else {
                            s.line("    /**").add("\t * ").line(c1.getRemark()).line("\t */");
                        }
                    }
                    if (c1.isPrimaryKey() && this.jpaAnnotation) {
                        s.line("\t@Id");
                    }
                    s.add("    private ").add(this.type(c1)).add(" ");
                    s.add(lower).line(";");
                }
                if (!this.lombok) {
                    for (JdbcMeta.Column c1 : t.getAllColumns()) {
                        lower = StringUtil.camelCase(c1.getName());
                        upper = StringUtil.upperCamelCase(c1.getName());
                        if (this.contain(this.entityBaseClass, lower)) continue;
                        s.newLine().add("    public ").add(this.type(c1)).add(" get").add(upper).line("() {");
                        s.add("        return ").add(lower).line(";");
                        s.line("    }").newLine();
                        s.add("    public void set").add(upper).add("(").add(this.type(c1)).add(" ").add(lower).line(") {");
                        s.add("        this.").add(lower).add(" = ").add(lower).line(";").line("    }");
                    }
                }
            } else {
                s.add("import ").add(this.entityBaseClass.getName()).line(";");
                s.line("/**").add(" * ").line(t.getComment()).line(" * @author " + this.author);
                s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
                s.line(" */");
                if (this.lombok) {
                    s.line("@Data");
                }
                if (this.swaggerEntity) {
                    s.add("@ApiModel(\"").add(t.getComment()).line("\")");
                }
                if (this.jpaAnnotation) {
                    s.add("@Table(name = \"").add(t.getName()).line("\")");
                }
                s.add("public class ").add(className).add(" extends ").add(this.entityBaseClass.getSimpleName());
                if (this.hasParametersType(this.entityBaseClass)) {
                    s.add("<").add(className).add(">");
                }
                s.line(" {");
                s.add("\tprivate static final long serialVersionUID = ").add(IdWorker.nextId()).line("L;");
                for (JdbcMeta.Column c1 : t.getAllColumns()) {
                    String fn = StringUtil.firstLower(StringUtil.camelCase(c1.getName()));
                    if (this.contain(this.entityBaseClass, fn)) continue;
                    if (!c1.getRemark().isEmpty()) {
                        if (this.swaggerEntity) {
                            s.add("    @ApiModelProperty(\"").add(c1.getRemark()).line("\")");
                        } else {
                            s.line("    /**").add("\t * ").line(c1.getRemark()).line("\t */");
                        }
                    }
                    if (c1.isPrimaryKey() && this.jpaAnnotation) {
                        s.line("\t@Id");
                    }
                    s.add("    private ").add(this.type(c1)).add(" ");
                    s.add(fn).line(";");
                }
                if (!this.lombok) {
                    for (JdbcMeta.Column c1 : t.getAllColumns()) {
                        lower = StringUtil.camelCase(c1.getName());
                        upper = StringUtil.upperCamelCase(c1.getName());
                        if (this.contain(this.entityBaseClass, lower)) continue;
                        s.newLine().add("    public ").add(this.type(c1)).add(" get").add(upper).line("() {");
                        s.add("        return ").add(lower).line(";");
                        s.line("    }").newLine();
                        s.add("    public void set").add(upper).add("(").add(this.type(c1)).add(" ").add(lower).line(") {");
                        s.add("        this.").add(lower).add(" = ").add(lower).line(";").line("    }");
                    }
                }
            }
            s.add("}");
            String epath = this.getPath() + entityPackage.replace(".", "/");
            this.out(epath + "/" + className + ".java", s.toString(), replace);
        }
        return this;
    }

    private boolean contain(Class<?> o, String n) {
        boolean b = false;
        try {
            if (o != null && o.getSuperclass() != Object.class) {
                b = this.contain(o.getSuperclass(), n);
            }
            if (!b && o != null) {
                b = o.getDeclaredField(n) != null;
            }
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return b;
    }

    private boolean hasParametersType(Class<?> a) {
        return a.getTypeParameters().length > 0;
    }

    public MvcGenerater createXml(String xmlPath) {
        return this.createXml(xmlPath, false);
    }

    public MvcGenerater createXml(String xmlPath, boolean replace) {
        for (JdbcMeta.Table t : this.tables) {
            Str s = new Str();
            String className = StringUtil.camelCase(this.replacePrefix(t.getName()));
            className = StringUtil.firstUpper(className);
            String keyCol = t.getPrimaryKeys() != null && t.getPrimaryKeys().size() > 0 ? t.getPrimaryKeys().get(0).getName() : "";
            String keyProp = StringUtil.camelCase(keyCol);
            s.line("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            s.line("<!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\" >");
            s.add("<mapper namespace=\"").add(this.mapperPackage).add(".").add(className).line("Mapper\">");
            if (this.baseColumnList) {
                s.line("\t<sql id=\"Base_Column_List\" >");
                s.add("\t\t");
                for (JdbcMeta.Column c : t.getAllColumns()) {
                    s.add("`").add(c.getName()).add("`,");
                }
                s.deleteLastChar();
                s.newLine().line("\t</sql>");
            }
            if (this.generateCrud) {
                String pro;
                String s0;
                s.add("\t<insert id=\"insert\"");
                if (this.persistence.isUseGeneratedKeys()) {
                    s.add(" useGeneratedKeys=\"true\" keyProperty=\"").add(StringUtil.firstLower(StringUtil.camelCase(t.getPrimaryKeys().get(0).getName()))).add("\"");
                }
                s.line(">");
                s.add("\t\tinsert into `").add(t.getName()).line("` (");
                for (JdbcMeta.Column c : t.getAllColumns()) {
                    s.add("\t\t`").add(c.getName()).add("`,").newLine();
                }
                s.deleteLastChar();
                s.line("\t\t)values (");
                for (JdbcMeta.Column c : t.getAllColumns()) {
                    s0 = StringUtil.firstLower(StringUtil.camelCase(c.getName()));
                    s.add("\t\t#{").add(s0).add("},").newLine();
                }
                s.deleteLastChar();
                s.line("\t\t)").line("\t</insert>");
                s.add("\t<insert id=\"insertSelective\"");
                if (this.persistence.isUseGeneratedKeys()) {
                    s.add(" useGeneratedKeys=\"true\" keyProperty=\"").add(StringUtil.firstLower(StringUtil.camelCase(t.getPrimaryKeys().get(0).getName()))).add("\"");
                }
                s.line(">");
                s.add("\t\tinsert into `").add(t.getName()).line("` (");
                s.line("\t\t<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\" >");
                for (JdbcMeta.Column c : t.getAllColumns()) {
                    pro = StringUtil.camelCase(c.getName());
                    s.add("\t\t\t<if test=\"" + pro + " != null\" >").add(c.getName()).line(",</if>");
                }
                s.line("\t\t</trim>");
                s.line("\t\t<trim prefix=\"values (\" suffix=\")\" suffixOverrides=\",\" >");
                for (JdbcMeta.Column c : t.getAllColumns()) {
                    pro = StringUtil.camelCase(c.getName());
                    s.add("\t\t\t<if test=\"" + pro + " != null\" >#{").add(pro).line("},</if>");
                }
                s.line("\t\t</trim>").line("\t</insert>");
                s.line("    <update id=\"update\">");
                s.add("\t\tupdate `").add(t.getName()).line("` set ");
                for (JdbcMeta.Column c : t.getColumns()) {
                    s0 = StringUtil.firstLower(StringUtil.camelCase(c.getName()));
                    s.add("\t\t`").add(c.getName()).add("` = #{").add(s0).add("},").newLine();
                }
                s.deleteLastChar();
                s.line("\t\twhere " + keyCol + " = #{" + keyProp + "}");
                s.line("\t</update>");
                s.line("    <update id=\"updateSelective\">");
                s.add("\t\tupdate ").line(t.getName());
                s.line("\t\t<set>");
                for (JdbcMeta.Column c : t.getColumns()) {
                    pro = StringUtil.camelCase(c.getName());
                    s.add("\t\t\t<if test=\"" + pro + " != null\" >").add(c.getName()).add("=#{").add(pro).line("},</if>");
                }
                s.line("\t\t</set>").line("\t\twhere " + keyCol + "=#{" + keyProp + "}");
                s.line("\t</update>");
                s.line("    <delete id=\"delete\">");
                s.add("\t\tupdate `").add(t.getName()).line("` set");
                s.line("\t\t`del_flag` =0");
                s.line("\t\twhere " + keyCol + " = #{" + keyProp + "}").line("\t</delete>");
                s.add("    <select id=\"get\" resultType=\"").add(this.entityPackage).add(".").add(className).line("\">");
                s.add("        select * from `").add(t.getName());
                s.line("` where `del_flag` = 0 and " + keyCol + " = #{" + keyProp + "}").line("    </select>");
                s.add("    <select id=\"findList\" resultType=\"").add(this.entityPackage).add(".").add(className).line("\">");
                s.add("        select * from `").add(t.getName());
                s.line("` where `del_flag` = 0 order by `created_at` desc");
                s.line("    </select>");
            }
            s.line("</mapper>");
            this.out(this.getPath().replaceFirst("java", "resources") + xmlPath + className + "Mapper.xml", s.toString(), replace);
        }
        return this;
    }

    public MvcGenerater createMapper(String mapperPackage) {
        this.mapperPackage = mapperPackage;
        for (JdbcMeta.Table t : this.tables) {
            Str s = new Str();
            String className = StringUtil.camelCase(this.replacePrefix(t.getName()));
            className = StringUtil.firstUpper(className);
            if (this.licenses != null && !this.licenses.isEmpty() && this.mapperLicenses) {
                s.line(this.licenses);
            }
            s.add("package ").add(mapperPackage).line(";").newLine();
            if (this.mapperBaseClass != null) {
                s.add("import ").add(this.mapperBaseClass.getName()).line(";");
            }
            s.add("import ").add(this.entityPackage).add(".").add(className).add(";").newLine().newLine();
            s.line("/**").add(" * ").line(t.getComment() + "Mapper\u63a5\u53e3").line(" * @author " + this.author);
            s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            s.line(" */");
            s.add("public interface ").add(className).add("Mapper");
            if (this.mapperBaseClass != null) {
                s.add(" extends ").add(this.mapperBaseClass.getSimpleName());
                if (this.hasParametersType(this.mapperBaseClass)) {
                    s.add("<").add(className).add(">");
                }
            }
            s.line(" {").newLine().add("}");
            this.out(this.path + mapperPackage.replace(".", "/") + "/" + className + "Mapper.java", s.toString());
        }
        return this;
    }

    public MvcGenerater createService(String servicePackage) {
        this.servicePackage = servicePackage;
        for (JdbcMeta.Table t : this.tables) {
            Str s = new Str();
            String className = StringUtil.camelCase(this.replacePrefix(t.getName()));
            className = StringUtil.firstUpper(className);
            if (this.licenses != null && !this.licenses.isEmpty() && this.serviceLicenses) {
                s.line(this.licenses);
            }
            s.add("package ").add(servicePackage).line(";").newLine();
            if (this.serviceBaseClass != null) {
                s.add("import ").add(this.serviceBaseClass.getName()).line(";");
            }
            s.add("import ").add(this.entityPackage).add(".").add(className).add(";").newLine();
            if (this.hasParametersType(this.serviceBaseClass) && this.serviceBaseClass.getTypeParameters().length == 2) {
                s.add("import ").add(this.mapperPackage).add(".").add(className).add("Mapper;").newLine().newLine();
            }
            s.line("/**").add(" * ").line(t.getComment() + "service").line(" * @author " + this.author);
            s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            s.line(" */");
            if (this.serviceBaseClass.isInterface()) {
                s.add("public interface ");
            } else {
                s.add("public class ");
            }
            s.add(className).add("Service");
            if (this.serviceBaseClass != null) {
                s.add(" extends ").add(this.serviceBaseClass.getSimpleName());
                if (this.hasParametersType(this.serviceBaseClass) && this.serviceBaseClass.getTypeParameters().length == 2) {
                    String name2 = this.serviceBaseClass.getTypeParameters()[0].getName();
                    String name = this.entityBaseClass.getTypeParameters()[0].getName();
                    if (name.equals(name2)) {
                        if (this.serviceBaseClass.getTypeParameters().length == 2) {
                            s.add("<").add(className).add(",").add(className).add("Mapper>");
                        }
                    } else if (this.serviceBaseClass.getTypeParameters().length == 2) {
                        s.add("<").add(className).add("Mapper,").add(className).add(">");
                    }
                } else if (this.hasParametersType(this.serviceBaseClass) && this.serviceBaseClass.getTypeParameters().length == 1) {
                    s.add("<").add(className).add(">");
                }
            }
            s.line(" {").newLine().add("}");
            this.out(this.path + servicePackage.replace(".", "/") + "/" + className + "Service.java", s.toString());
        }
        return this;
    }

    public MvcGenerater setServiceInterface(Class<?> serviceInterface) {
        this.serviceInterface = serviceInterface;
        return this;
    }

    public MvcGenerater createServiceInterface(String serviceInterfacePackage) {
        this.serviceInterfacePackage = serviceInterfacePackage;
        for (JdbcMeta.Table t : this.tables) {
            Str s = new Str();
            String className = StringUtil.camelCase(this.replacePrefix(t.getName()));
            className = StringUtil.firstUpper(className);
            if (this.licenses != null && !this.licenses.isEmpty() && this.serviceLicenses) {
                s.line(this.licenses);
            }
            s.add("package ").add(serviceInterfacePackage).line(";").newLine();
            if (this.serviceInterface != null) {
                s.add("import ").add(this.serviceInterface.getName()).line(";");
            }
            s.add("import ").add(this.entityPackage).add(".").add(className).add(";").newLine();
            s.line("/**").add(" * ").line(t.getComment() + "service").line(" * @author " + this.author);
            s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            s.line(" */");
            s.add("public interface ").add(className).add("Service");
            if (this.serviceInterface != null) {
                s.add(" extends ").add(this.serviceInterface.getSimpleName());
                if (this.hasParametersType(this.serviceInterface) && this.serviceInterface.getTypeParameters().length == 2) {
                    String name2 = this.serviceBaseClass.getTypeParameters()[0].getName();
                    String name = this.entityBaseClass.getTypeParameters()[0].getName();
                    if (name.equals(name2)) {
                        if (this.serviceBaseClass.getTypeParameters().length == 2) {
                            s.add("<").add(className).add(",").add(className).add("Mapper>");
                        }
                    } else if (this.serviceBaseClass.getTypeParameters().length == 2) {
                        s.add("<").add(className).add("Mapper,").add(className).add(">");
                    }
                } else if (this.hasParametersType(this.serviceInterface) && this.serviceInterface.getTypeParameters().length == 1) {
                    s.add("<").add(className).add(">");
                }
            }
            s.line(" {").newLine().add("}");
            this.out(this.path + serviceInterfacePackage.replace(".", "/") + "/" + className + "Service.java", s.toString());
        }
        return this;
    }

    public MvcGenerater setServiceImpl(Class<?> serviceImpl) {
        this.serviceImpl = serviceImpl;
        return this;
    }

    public MvcGenerater createServiceImpl(String serviceImplPackage) {
        this.serviceImplPackage = serviceImplPackage;
        for (JdbcMeta.Table t : this.tables) {
            String name;
            String name2;
            Str s = new Str();
            String className = StringUtil.camelCase(this.replacePrefix(t.getName()));
            className = StringUtil.firstUpper(className);
            if (this.licenses != null && !this.licenses.isEmpty() && this.serviceLicenses) {
                s.line(this.licenses);
            }
            s.add("package ").add(serviceImplPackage).line(";").newLine();
            if (this.serviceInterface != null) {
                s.add("import ").add(this.serviceInterfacePackage).add(".").add(className).line("Service;");
            }
            if (this.serviceImpl != null) {
                s.add("import ").add(this.serviceImpl.getName()).line(";");
                if (this.hasParametersType(this.serviceImpl) && this.serviceImpl.getTypeParameters().length == 2) {
                    s.add("import ").add(this.mapperPackage).add(".").add(className).line("Mapper;");
                }
            }
            s.add("import ").add(this.entityPackage).add(".").add(className).add(";").newLine();
            s.line("import org.springframework.stereotype.Service;");
            s.line("/**").add(" * ").line(t.getComment() + "service").line(" * @author " + this.author);
            s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            s.line(" */");
            s.add("@Service(\"").add(StringUtil.firstLower(className)).line("Service\")");
            s.add("public class ").add(className).add("ServiceImpl");
            if (this.serviceImpl != null) {
                s.add(" extends ").add(this.serviceImpl.getSimpleName());
                if (this.hasParametersType(this.serviceImpl) && this.serviceImpl.getTypeParameters().length == 2) {
                    name2 = this.serviceImpl.getTypeParameters()[0].getName();
                    name = this.entityBaseClass.getTypeParameters()[0].getName();
                    if (name.equals(name2)) {
                        if (this.serviceImpl.getTypeParameters().length == 2) {
                            s.add("<").add(className).add(",").add(className).add("Mapper>");
                        }
                    } else if (this.serviceImpl.getTypeParameters().length == 2) {
                        s.add("<").add(className).add("Mapper,").add(className).add(">");
                    }
                } else if (this.hasParametersType(this.serviceImpl) && this.serviceImpl.getTypeParameters().length == 1) {
                    s.add("<").add(className).add(">");
                }
            }
            if (this.serviceInterface != null) {
                s.add(" implements ").add(className).add("Service");
                if (this.hasParametersType(this.serviceInterface) && this.serviceInterface.getTypeParameters().length == 2) {
                    name2 = this.serviceInterface.getTypeParameters()[0].getName();
                    name = this.entityBaseClass.getTypeParameters()[0].getName();
                    if (name.equals(name2)) {
                        if (this.serviceInterface.getTypeParameters().length == 2) {
                            s.add("<").add(className).add(",").add(className).add("Mapper>");
                        }
                    } else if (this.serviceInterface.getTypeParameters().length == 2) {
                        s.add("<").add(className).add("Mapper,").add(className).add(">");
                    }
                } else if (!this.hasParametersType(this.serviceInterface) || this.serviceInterface.getTypeParameters().length == 1) {
                    // empty if block
                }
            }
            s.line(" {").newLine().add("}");
            this.out(this.path + serviceImplPackage.replace(".", "/") + "/" + className + "ServiceImpl.java", s.toString());
        }
        return this;
    }

    public MvcGenerater createControl(String controlPackage) {
        this.controlPackage = controlPackage;
        for (JdbcMeta.Table t : this.tables) {
            Str s = new Str();
            String className = StringUtil.camelCase(this.replacePrefix(t.getName()));
            className = StringUtil.firstUpper(className);
            String lowClassName = StringUtil.firstLower(className);
            if (this.licenses != null && !this.licenses.isEmpty() && this.controlLicenses) {
                s.line(this.licenses);
            }
            s.add("package ").add(controlPackage).line(";").newLine();
            if (this.controlBaseClass != null) {
                s.add("import ").add(this.controlBaseClass.getName()).line(";");
            }
            s.line("import org.springframework.beans.factory.annotation.Autowired;");
            s.line("import org.springframework.stereotype.Controller;");
            s.line("import org.springframework.ui.Model;");
            s.line("import org.springframework.web.bind.annotation.RequestMapping;");
            s.line("import org.springframework.web.bind.annotation.RequestParam;");
            s.line("import org.springframework.web.bind.annotation.ResponseBody;").newLine();
            s.line("import com.github.pagehelper.PageInfo;");
            s.add("import ").add(this.entityPackage).add(".").add(className).add(";").newLine();
            s.add("import ").add(this.servicePackage).add(".").add(className).add("Service;").newLine().newLine();
            s.line("/**").add(" * ").line(t.getComment() + "controller").line(" * @author " + this.author);
            s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date()));
            s.line(" */");
            s.line("@Controller");
            s.add("public class ").add(className).add("Controller");
            if (this.controlBaseClass != null) {
                s.add(" extends ").add(this.controlBaseClass.getSimpleName());
            }
            s.line(" {");
            s.line("\t@Autowired");
            s.add("\t").add(className).add("Service ").add(StringUtil.firstLower(className)).line("Service;").newLine();
            s.add("\t@RequestMapping(path = \"/").add(StringUtil.firstLower(className)).line("/list\")");
            s.line("\tpublic String list(@RequestParam(defaultValue = \"1\") int pageNum, @RequestParam(defaultValue = \"10\") int pageSize, Model model) {");
            s.add("\t\tPageInfo<").add(className).add("> pageInfo = ").add(lowClassName).add("Service.findPage(new ").add(className).line("(), pageNum, pageSize);");
            s.line("\t\tmodel.addAttribute(\"pageInfo\", pageInfo);");
            s.add("\t\treturn \"/").add(lowClassName).line("/list\";");
            s.line("\t}").newLine();
            s.add("\t@RequestMapping(path = \"/").add(lowClassName).line("/edit\")");
            s.line("\tpublic String edit(long id, Model model) {");
            s.add("\t\t").add(className).add(" ").add(lowClassName).add(" = ").add(lowClassName).line("Service.get(id);");
            s.add("\t\tmodel.addAttribute(\"").add(lowClassName).add("\", ").add(lowClassName).line(");");
            s.add("\t\treturn \"/").add(lowClassName).add("/edit\";").newLine();
            s.line("\t}").newLine();
            s.line("\t@ResponseBody");
            s.add("\t@RequestMapping(path = \"/").add(lowClassName).line("/save\")");
            s.add("\tpublic String save(").add(className).add(" ").add(lowClassName).line(") {");
            s.add("\t\t").add(lowClassName).add("Service.save(").add(lowClassName).line(");");
            s.line("\t\treturn \"{\\\"message\\\":\\\"success\\\"}\";");
            s.line("\t}");
            s.add("}");
            this.out(this.path + controlPackage.replace(".", "/") + "/" + className + "Controller.java", s.toString());
        }
        return this;
    }

    public MvcGenerater createView(String viewPath) {
        for (JdbcMeta.Table t : this.tables) {
            String cn;
            Str s = new Str();
            String className = StringUtil.camelCase(this.replacePrefix(t.getName()));
            if (this.viewHeader != null && !this.viewHeader.isEmpty()) {
                s.line(this.viewHeader);
            }
            s.line("<div class=\"container-fluid\">");
            s.line("    <div class=\"row\">");
            s.line("        <div class=\"col-md-12\">");
            s.line("            <form class=\"form-inline\" role=\"form\">");
            s.line("                <input type=\"hidden\" id=\"pageNum\" name=\"pageNum\" value=\"${pageInfo.pageNum}\">");
            s.line("                <input type=\"hidden\" id=\"pageSize\" name=\"pageSize\" value=\"${pageInfo.pageSize}\">");
            s.line("                <div class=\"form-group\">");
            s.line("                    <a type=\"button\" class=\"btn btn-primary\" onclick=\"edit(0)\">\u65b0\u5efa</a>");
            s.line("                </div>");
            s.line("            </form>");
            s.line("        </div>");
            s.line("    </div>");
            s.line("    <br/>");
            s.line("    <div class=\"row\" id=\"_ba\">");
            s.line("        <div class=\"col-md-12\" id=\"ba\">");
            s.line("            <table class=\"table table-bordered table-hover\">");
            s.line("                <thead>");
            s.line("                <tr>");
            for (JdbcMeta.Column c : t.getAllColumns()) {
                s.add("                    <th>").add(c.getRemark() == null || c.getRemark().isEmpty() ? c.getName() : c.getRemark()).line("</th>");
            }
            s.line("                    <th>\u64cd\u4f5c</th>");
            s.line("                </tr>");
            s.line("                </thead>");
            s.line("                <tbody>");
            s.line("                    <#list pageInfo.list as p>");
            s.line("                    <tr>");
            for (JdbcMeta.Column c : t.getAllColumns()) {
                String cn2 = StringUtil.firstLower(StringUtil.camelCase(c.getName()));
                if (c.getType().getJava().equals("java.util.Date")) {
                    s.add("                        <td>${p.").add(cn2).line("?string('yyyy-MM-dd HH:mm:ss')}</td>");
                    continue;
                }
                s.add("                        <td>${p.").add(cn2).line("!}</td>");
            }
            JdbcMeta.Column key = t.getPrimaryKeys().get(0);
            String kn = StringUtil.firstLower(StringUtil.camelCase(key.getName()));
            s.add("                        <td><a href=\"#\" class=\"btn btn-default btn-xs\" onclick=\"edit('${p.").add(kn).line("}')\">\u7f16\u8f91</a></td>");
            s.line("                    </tr>");
            s.line("                    </#list>");
            s.line("                </tbody>");
            s.line("            </table>");
            s.line("            <div class=\"col-xs-12\">");
            s.line("                <#if (pageInfo.pageNum>1)>");
            s.line("                    <a href=\"#\" onclick=\"pageTo('${pageInfo.prePage}')\">\u4e0a\u4e00\u9875</a>");
            s.line("                <#else>");
            s.line("                    \u4e0a\u4e00\u9875");
            s.line("                </#if>");
            s.line("                <#if (pageInfo.pageNum<pageInfo.pages)>");
            s.line("                    <a href=\"#\" onclick=\"pageTo('${pageInfo.nextPage}')\">\u4e0b\u4e00\u9875</a>");
            s.line("                <#else>");
            s.line("                    \u4e0b\u4e00\u9875");
            s.line("                </#if>");
            s.line("                ,\u5f53\u524d\u7b2c${pageInfo.pageNum}\u9875 \u5171 ${pageInfo.total} \u9879,${pageInfo.pages} \u9875,\u6bcf\u9875");
            s.line("                <select style=\"height: 32px;\" id=\"pgSize\" onchange=\"changePgSize()\">");
            s.line("                    <option value=\"10\" <#if pageInfo.pageSize==10>selected</#if>>10</option>");
            s.line("                    <option value=\"20\" <#if pageInfo.pageSize==20>selected</#if>>20</option>");
            s.line("                    <option value=\"50\" <#if pageInfo.pageSize==50>selected</#if>>50</option>");
            s.line("                </select> \u9879 \u5230\u7b2c <input type=\"text\"");
            s.line("                                      style=\"width:48px;height: 32px;\" id=\"pgNum\"> \u9875");
            s.line("                <button class=\"btn btn-default\" onclick=\"pageJunp()\">GO</button>");
            s.line("            </div>");
            s.line("        </div>");
            s.line("    </div>");
            s.line("</div>");
            s.line("<script>");
            s.line("    function changePgSize() {");
            s.line("        $(\"#pageSize\").val($(\"#pgSize\").val());");
            s.line("        pageTo(1);");
            s.line("    }");
            s.line("    function pageJunp() {");
            s.line("        pageTo($(\"#pgNum\").val());");
            s.line("    }");
            s.line("    function pageTo(num) {");
            s.line("        $(\"#pageNum\").val(num);");
            s.line("        $(\"#_ba\").load(\"list #ba\", $(\"form\").eq(0).serialize());");
            s.line("    }");
            s.line("    function edit(id) {");
            s.line("        window.location.href = \"edit?id=\" + id;");
            s.line("    }");
            s.line("</script>");
            if (this.viewFooter != null && !this.viewFooter.isEmpty()) {
                s.line(this.viewFooter);
            }
            this.createFile(this.path.replaceFirst("java", "webapp") + viewPath + className);
            this.out(this.path.replaceFirst("java", "webapp") + viewPath + className + "/list.ftl", s.toString());
            s = new Str();
            if (this.viewHeader != null && !this.viewHeader.isEmpty()) {
                s.line(this.viewHeader);
            }
            s.line("<div class=\"container-fluid\">");
            s.line("    <div class=\"row\">");
            s.line("        <div class=\"col-md-12\">");
            s.line("            <form class=\"form-inline\">");
            s.line("                <div class=\"form-group\">");
            s.line("                    <a href=\"#\" class=\"btn btn-info\" onclick=\"history.go(-1)\">\u8fd4\u56de</a>");
            s.line("                </div>");
            s.line("            </form>");
            s.line("        </div>");
            s.line("        <div class=\"col-md-12\">");
            s.line("            <form class=\"form-horizontal\">");
            s.add("                <input type=\"hidden\" name=\"").add(kn).add("\" value=\"${").add(className).add(".").add(kn).line("!}\">");
            for (JdbcMeta.Column c : t.getColumns()) {
                s.line("                <div class=\"form-group\">");
                cn = StringUtil.firstLower(StringUtil.camelCase(c.getName()));
                s.add("                    <label class=\"col-sm-2 control-label\" for=\"").add(cn).add("\">");
                s.add(c.getRemark() == null || c.getRemark().isEmpty() ? kn : c.getRemark()).line("</label>");
                s.line("                    <div class=\"col-sm-6\">");
                s.add("                        <input id=\"").add(cn).add("\" name=\"").add(cn).add("\" class=\"form-control\" type=\"text\"");
                s.add(" value=\"${");
                if (c.getType().getJava().equals("java.util.Date")) {
                    s.add("(").add(className).add(".").add(cn).add("?string(\"yyyy-MM-dd HH:mm:ss\"))!");
                } else {
                    s.add("(").add(className).add(".").add(cn).add(")!");
                }
                s.line("}\">");
                s.line("                    </div>");
                s.line("                </div>");
            }
            s.line("                <div class=\"form-group\">");
            s.line("                    <div class=\"col-sm-2\"></div>");
            s.line("                    <a href=\"#\" class=\"btn btn-primary\" onclick=\"save();\">\u4fdd\u5b58</a>");
            s.line("                </div>");
            s.line("            </form>");
            s.line("        </div>");
            s.line("    </div>");
            s.line("</div>");
            s.line("<script>");
            s.line("    function save() {");
            s.line("        var b = true;");
            s.line("        var msg = \"\u9519\u8bef\uff1a\";");
            for (JdbcMeta.Column c : t.getColumns()) {
                cn = StringUtil.firstLower(StringUtil.camelCase(c.getName()));
                s.add("        if ($(\"#").add(cn).line("\").val() == \"\") {");
                s.line("            b = false;");
                s.add("            msg += \"").add(c.getRemark() == null || c.getRemark().isEmpty() ? kn : c.getRemark()).line("\u4e0d\u80fd\u4e3a\u7a7a\uff1b\";");
                s.line("        }");
            }
            s.line("        if (b) {");
            s.line("            $.post(\"save\", $(\"form\").eq(0).serialize(), function (data) {");
            s.line("                if (data.message == \"success\") {");
            s.line("                    window.location.href = \"list?\";");
            s.line("                }");
            s.line("            }, 'json')");
            s.line("        } else {");
            s.line("            alert(msg);");
            s.line("        }");
            s.line("    }");
            s.line("</script>");
            if (this.viewFooter != null && !this.viewFooter.isEmpty()) {
                s.line(this.viewFooter);
            }
            if (this.war) {
                this.out(this.path.replaceFirst("java", "webapp") + viewPath + className + "/edit.ftl", s.toString());
                continue;
            }
            this.out(this.path.replaceFirst("java", "resources") + viewPath + className + "/edit.ftl", s.toString());
        }
        return this;
    }

    private void out(String path, String content) {
        this.out(path, content, false);
    }

    private void out(String path, String content, boolean replace) {
        File f = new File(path);
        if (f.exists() && !replace) {
            System.err.println("mvc generator error (exists path): " + path);
            return;
        }
        System.out.println(path);
        FileUtil.writeString(path, content);
    }

    private void createFile(String path) {
        File f = new File(path);
        if (!f.exists() || !f.isDirectory()) {
            f.mkdir();
        }
    }

    private String getPath() {
        return PathUtil.getMavenSrcPath() + "main/java/";
    }

    /*
     * WARNING - void declaration
     */
    public MvcGenerater createXmlReplaceable(String xmlPath, boolean selective) {
        for (JdbcMeta.Table t : this.tables) {
            String className = StringUtil.camelCase(this.replacePrefix(t.getName()));
            className = StringUtil.firstUpper(className);
            String pathname = this.path.replaceFirst("java", "resources") + xmlPath + className + "Mapper.xml";
            File f = new File(pathname);
            if (f.exists()) {
                void var16_30;
                void var15_15;
                XmlBuilder.Node node;
                XmlBuilder.Node update;
                String xml = FileUtil.readString(pathname, null);
                XmlBuilder builder = new XmlBuilder(xml);
                String keyCol = t.getPrimaryKeys() != null && t.getPrimaryKeys().size() > 0 ? t.getPrimaryKeys().get(0).getName() : "";
                String keyProp = StringUtil.camelCase(keyCol);
                Str s = new Str();
                XmlBuilder.Node insert = builder.getById("insert");
                if (insert == null) {
                    insert = builder.rootNode().createNode().name("insert");
                    insert.addAttribute("id", "insert");
                    if (this.persistence.isUseGeneratedKeys()) {
                        insert.addAttribute("useGeneratedKeys", "true");
                    }
                } else {
                    builder.rootNode().children().remove(insert);
                }
                s.add("insert into ").add(t.getName()).add(" (");
                for (JdbcMeta.Column column : t.getAllColumns()) {
                    s.add(column.getName()).add(",");
                }
                s.delLastChar().add(") values (");
                for (JdbcMeta.Column column : t.getAllColumns()) {
                    s.add("#{").add(StringUtil.camelCase(column.getName())).add("},");
                }
                s.delLastChar().add(")");
                insert.text(s.toString());
                builder.rootNode().children().add(insert);
                if (selective) {
                    String pro;
                    XmlBuilder.Node is = builder.getById("insertSelective");
                    if (is == null) {
                        is = builder.rootNode().createNode().name("insert");
                        is.addAttribute("id", "insertSelective");
                        if (this.persistence.isUseGeneratedKeys()) {
                            is.addAttribute("useGeneratedKeys", "true");
                        }
                    } else {
                        builder.rootNode().children().remove(is);
                    }
                    s.empty("insert into ").add(t.getName());
                    s.add("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\" >");
                    for (JdbcMeta.Column column : t.getAllColumns()) {
                        pro = StringUtil.camelCase(column.getName());
                        s.add("<if test=\"" + pro + " != null\" >").add(column.getName()).add(",</if>");
                    }
                    s.add("</trim>");
                    s.add("<trim prefix=\"values (\" suffix=\")\" suffixOverrides=\",\" >");
                    for (JdbcMeta.Column column : t.getAllColumns()) {
                        pro = StringUtil.camelCase(column.getName());
                        s.add("<if test=\"" + pro + " != null\" >#{").add(pro).add("},</if>");
                    }
                    s.add("</trim>");
                    is.text(s.toString());
                    builder.rootNode().children().add(is);
                }
                if ((update = builder.getById("update")) == null) {
                    update = builder.rootNode().createNode().name("update");
                    update.addAttribute("id", "update");
                } else {
                    builder.rootNode().children().remove(update);
                }
                s.empty("update ").add(t.getName()).add(" set ");
                for (JdbcMeta.Column column : t.getColumns()) {
                    s.add(column.getName()).add("=#{").add(StringUtil.camelCase(column.getName())).add("},");
                }
                s.delLastChar().add(" where " + keyCol + "=#{" + keyProp + "}");
                update.text(s.toString());
                builder.rootNode().children().add(update);
                if (selective) {
                    void var15_26;
                    XmlBuilder.Node node2 = builder.getById("updateSelective");
                    if (node2 == null) {
                        XmlBuilder.Node node3 = builder.rootNode().createNode().name("update");
                        node3.addAttribute("id", "updateSelective");
                    } else {
                        builder.rootNode().children().remove(node2);
                    }
                    s.empty("update ").add(t.getName());
                    s.add("<set>");
                    for (JdbcMeta.Column c4 : t.getColumns()) {
                        String pro = StringUtil.camelCase(c4.getName());
                        s.add("<if test=\"" + pro + " != null\" >").add(c4.getName()).add("=#{").add(pro).add("},</if>");
                    }
                    s.add("</set>").add(" where " + keyCol + "=#{" + keyProp + "}");
                    var15_26.text(s.toString());
                    builder.rootNode().children().add((XmlBuilder.Node)var15_26);
                }
                if ((node = builder.getById("delete")) == null) {
                    XmlBuilder.Node node4 = builder.rootNode().createNode().name("select");
                    node4.addAttribute("id", "delete");
                } else {
                    builder.rootNode().children().remove(node);
                }
                var15_15.text("update " + t.getName() + " set del=1 where " + keyCol + "=#{" + keyProp + "}");
                builder.rootNode().children().add((XmlBuilder.Node)var15_15);
                XmlBuilder.Node node5 = builder.getById("get");
                if (node5 == null) {
                    XmlBuilder.Node node6 = builder.rootNode().createNode().name("select");
                    node6.addAttribute("id", "get").addAttribute("resultType", className);
                } else {
                    builder.rootNode().children().remove(node5);
                }
                var16_30.text("select * from " + t.getName() + " where " + keyCol + "=#{" + keyProp + "}");
                builder.rootNode().children().add((XmlBuilder.Node)var16_30);
                XmlBuilder.Node list = builder.getById("list");
                if (list == null) {
                    list = builder.rootNode().createNode().name("select");
                    list.addAttribute("id", "list").addAttribute("resultType", className);
                } else {
                    builder.rootNode().children().remove(list);
                }
                list.text("select * from " + t.getName());
                builder.rootNode().children().add(list);
                s.empty("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                s.line("<!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\" >");
                s.add(builder.rootNode().toString());
                this.out(pathname, s.toString(), true);
                continue;
            }
            this.createXml(xmlPath);
        }
        return this;
    }

    public MvcGenerater sqlTypeAdaptor(JdbcMeta.Type t, Class<? extends Serializable> java) {
        this.tyeAdaptor.put(t, java);
        return this;
    }

    private String type(JdbcMeta.Column c) {
        JdbcMeta.Type type = c.getType();
        if (this.tyeAdaptor.containsKey((Object)type)) {
            Class<? extends Serializable> java = this.tyeAdaptor.get((Object)type);
            if (java.getName().startsWith("java.lang.")) {
                return java.getSimpleName();
            }
            return this.tyeAdaptor.get((Object)type).getName();
        }
        return type.getJavaString(!this.primitive || c.isNullable());
    }

    public static interface ViewStyle {
        public String edit(JdbcMeta.Table var1);

        public String list(JdbcMeta.Table var1);
    }

    public static enum ViewEnum {
        FREEMARKER("freemarker"),
        JSP("jsp"),
        VELOCITY("velocity");

        private String name;

        public String getName() {
            return this.name;
        }

        private ViewEnum(String name) {
            this.name = name;
        }

        public static ViewEnum getByName(String name) {
            for (ViewEnum p : ViewEnum.values()) {
                if (!p.getName().equalsIgnoreCase(name)) continue;
                return p;
            }
            return JSP;
        }
    }

    public static enum ControlEnum {
        SPRING_MVC("spring_mvc"),
        STRUTS("struts");

        private String name;

        public String getName() {
            return this.name;
        }

        private ControlEnum(String name) {
            this.name = name;
        }

        public static ControlEnum getByName(String name) {
            for (ControlEnum p : ControlEnum.values()) {
                if (!p.getName().equalsIgnoreCase(name)) continue;
                return p;
            }
            return SPRING_MVC;
        }
    }

    public static enum PersistenceEnum {
        HIBERNATE("hibernate"),
        JDBC("jdbc"),
        JDBC_MAPPER("jdbc_mapper"),
        JPA("jpa"),
        IBATIS("ibatis"),
        MYBATIS("mybatis");

        private String name;
        private boolean useGeneratedKeys = true;

        private PersistenceEnum(String name) {
            this.name = name;
        }

        public boolean isUseGeneratedKeys() {
            return this.useGeneratedKeys;
        }

        public PersistenceEnum setUseGeneratedKeys(boolean useGeneratedKeys) {
            this.useGeneratedKeys = useGeneratedKeys;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public static PersistenceEnum getByName(String name) {
            for (PersistenceEnum p : PersistenceEnum.values()) {
                if (!p.getName().equalsIgnoreCase(name)) continue;
                return p;
            }
            return JDBC;
        }
    }
}

