/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import com.di.kit.ClassUtil;
import com.di.kit.StringUtil;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SqlProvider {
    static final HashMap<String, String> sqls = new HashMap();
    static final HashMap<String, List<Field>> modelFieldsMap = new HashMap();
    static final HashMap<Class<?>, Field> idFieldsMap = new HashMap();

    public String insert(final Object bean) {
        return SqlProvider.getCachedSql(bean, "insert", new Func<Object>(){

            @Override
            public String apply(Object t) {
                return SqlProvider.this.getInsertSql(bean, false);
            }
        });
    }

    public String insertSelective(Object bean) {
        return this.getInsertSql(bean, true);
    }

    public String getInsertSql(Object bean, boolean selective) {
        int i;
        String tableName = SqlProvider.table(bean);
        StringBuilder sql = new StringBuilder();
        ArrayList<String> props = new ArrayList<String>();
        ArrayList<String> columns = new ArrayList<String>();
        sql.append("INSERT INTO ").append(tableName).append("(");
        try {
            for (Field field : SqlProvider.getCachedModelFields(bean.getClass())) {
                Object value;
                if (selective && (value = field.get(bean)) == null || field.isAnnotationPresent(Transient.class) || field.isAnnotationPresent(IgnoreInsert.class)) continue;
                columns.add(StringUtil.snakeCase(field.getName()));
                props.add("#{" + field.getName() + "}");
            }
        }
        catch (Exception e) {
            new RuntimeException(sql.toString(), e);
        }
        for (i = 0; i < columns.size(); ++i) {
            sql.append("`").append((String)columns.get(i)).append("`");
            if (i == columns.size() - 1) continue;
            sql.append(",");
        }
        sql.append(")").append(" VALUES(");
        for (i = 0; i < props.size(); ++i) {
            sql.append((String)props.get(i));
            if (i == props.size() - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        return sql.toString();
    }

    public String update(final Object bean) {
        return SqlProvider.getCachedSql(bean, "update", new Func<Object>(){

            @Override
            public String apply(Object t) {
                return SqlProvider.this.getUpdateSql(bean, false);
            }
        });
    }

    public String updateSelective(Object bean) {
        return this.getUpdateSql(bean, true);
    }

    public String getUpdateSql(Object bean, boolean selective) {
        String tableName = SqlProvider.table(bean);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tableName).append(" SET ");
        String id = "id";
        try {
            for (Field field : SqlProvider.getCachedModelFields(bean.getClass())) {
                Object value;
                if (selective && (value = field.get(bean)) == null) continue;
                if (field.isAnnotationPresent(Id.class)) {
                    id = field.getName();
                    continue;
                }
                if (field.isAnnotationPresent(Transient.class) || field.isAnnotationPresent(IgnoreUpdate.class)) continue;
                sql.append("`").append(StringUtil.snakeCase(field.getName())).append("`=#{").append(field.getName()).append("},");
            }
        }
        catch (Exception e) {
            new RuntimeException(sql.toString(), e);
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" where ").append(StringUtil.snakeCase(id)).append(" =#{").append(id).append("}");
        return sql.toString();
    }

    public String delete(final Object bean) {
        return SqlProvider.getCachedSql(bean, "delete", new Func<Object>(){

            @Override
            public String apply(Object t) {
                String tableName = SqlProvider.table(bean);
                List<Field> fields = SqlProvider.getCachedModelFields(bean.getClass());
                StringBuilder sql = new StringBuilder();
                sql.append(" DELETE FROM ").append(tableName).append(" WHERE ");
                try {
                    for (int i = 0; i < fields.size(); ++i) {
                        Field field = fields.get(i);
                        if (!field.isAnnotationPresent(Id.class)) continue;
                        sql.append(StringUtil.snakeCase(field.getName())).append("=#{").append(field.getName()).append("}");
                        break;
                    }
                }
                catch (Exception e) {
                    new RuntimeException(sql.toString(), e);
                }
                return sql.toString();
            }
        });
    }

    public String deleteMark(final Object bean) {
        return SqlProvider.getCachedSql(bean, "deleteMark", new Func<Object>(){

            @Override
            public String apply(Object t) {
                String tableName = SqlProvider.table(bean);
                List<Field> fields = ClassUtil.getDeclaredFields(bean.getClass());
                StringBuilder sql = new StringBuilder();
                sql.append(" UPDATE ").append(tableName).append(" SET ");
                String delete = "";
                String id = "";
                try {
                    for (Field field : fields) {
                        if (field.isAnnotationPresent(DeleteMark.class)) {
                            delete = StringUtil.snakeCase(field.getName());
                            continue;
                        }
                        if (!field.isAnnotationPresent(Id.class)) continue;
                        id = field.getName();
                    }
                }
                catch (Exception e) {
                    new RuntimeException(sql.toString(), e);
                }
                sql.append(delete).append("=1 WHERE ").append(StringUtil.snakeCase(id)).append("=#{").append(id).append("}");
                return sql.toString();
            }
        });
    }

    public String get(final Object bean) {
        return SqlProvider.getCachedSql(bean, "get", new Func<Object>(){

            @Override
            public String apply(Object t) {
                String tableName = SqlProvider.table(bean);
                List<Field> fields = ClassUtil.getDeclaredFields(bean.getClass());
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT * FROM ").append(tableName).append(" WHERE ");
                try {
                    for (int i = 0; i < fields.size(); ++i) {
                        Field field = fields.get(i);
                        if (!field.isAnnotationPresent(Id.class)) continue;
                        sql.append(StringUtil.snakeCase(field.getName())).append("=#{").append(field.getName()).append("} and");
                    }
                    sql.delete(sql.toString().length() - 3, sql.toString().length());
                }
                catch (Exception e) {
                    new RuntimeException(sql.toString(), e);
                }
                return sql.toString();
            }
        });
    }

    public String getById(final Class<?> bean, Serializable id) {
        return SqlProvider.getCachedSql(bean, "get", new Func<Class<?>>(){

            @Override
            public String apply(Class<?> t) {
                String tableName = SqlProvider.table(bean);
                List<Field> fields = ClassUtil.getDeclaredFields(bean);
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT * FROM ").append(tableName).append(" WHERE ");
                try {
                    for (int i = 0; i < fields.size(); ++i) {
                        Field field = fields.get(i);
                        if (!field.isAnnotationPresent(Id.class)) continue;
                        sql.append(StringUtil.snakeCase(field.getName())).append("=#{param1}");
                        break;
                    }
                }
                catch (Exception e) {
                    new RuntimeException(sql.toString(), e);
                }
                return sql.toString();
            }
        });
    }

    public String listAll(final Class<?> bean) {
        return SqlProvider.getCachedSql(bean, "listAll", new Func<Class<?>>(){

            @Override
            public String apply(Class<?> t) {
                String tableName = SqlProvider.table(bean);
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT * FROM ").append(tableName);
                return sql.toString();
            }
        });
    }

    public String countAll(final Class<?> bean) {
        return SqlProvider.getCachedSql(bean, "countAll", new Func<Class<?>>(){

            @Override
            public String apply(Class<?> t) {
                String tableName = SqlProvider.table(bean);
                StringBuilder getSql = new StringBuilder();
                getSql.append("SELECT count(0) FROM ").append(tableName);
                return getSql.toString();
            }
        });
    }

    public String listByIds(Class<?> entity, Iterable<Serializable> ids) {
        StringBuilder s = new StringBuilder();
        s.append("SELECT * FROM ").append(SqlProvider.table(entity));
        s.append(" WHERE ").append(StringUtil.snakeCase(SqlProvider.id(entity).getName())).append(" IN ( ");
        for (Serializable id : ids) {
            s.append("'").append(id).append("',");
        }
        s.deleteCharAt(s.length() - 1).append(" )");
        return s.toString();
    }

    public static Field id(Class<?> entity) {
        Field id = null;
        if (idFieldsMap.containsKey(entity)) {
            id = idFieldsMap.get(entity);
        } else {
            List<Field> fields = ClassUtil.getDeclaredFields(entity);
            for (Field f : fields) {
                if (!f.isAnnotationPresent(Id.class)) continue;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                id = f;
                idFieldsMap.put(entity, f);
                break;
            }
        }
        if (id == null) {
            throw new RuntimeException(entity.getName() + "\u6ca1\u6709\u4e3b\u952e!");
        }
        return id;
    }

    private static String getCachedSql(Object bean, String method, Func<Object> func) {
        String key = bean.getClass().getName() + "_" + method;
        if (sqls.containsKey(key)) {
            return sqls.get(key);
        }
        String apply = func.apply(bean);
        sqls.put(key, apply);
        return apply;
    }

    private static String getCachedSql(Class<?> bean, String method, Func<Class<?>> func) {
        String key = bean.getName() + "_" + method;
        if (sqls.containsKey(key)) {
            return sqls.get(key);
        }
        String apply = func.apply(bean);
        sqls.put(key, apply);
        return apply;
    }

    public static List<Field> getCachedModelFields(Class<?> beanClass) {
        if (modelFieldsMap.containsKey(beanClass.getName())) {
            return modelFieldsMap.get(beanClass.getName());
        }
        List<Field> fields = ClassUtil.getDeclaredFields(beanClass);
        fields.forEach(f -> f.setAccessible(true));
        modelFieldsMap.put(beanClass.getName(), fields);
        return fields;
    }

    private static String table(Object bean) {
        return SqlProvider.table(bean.getClass());
    }

    private static String table(Class<?> bean) {
        if (bean.isAnnotationPresent(Table.class) && !bean.getAnnotation(Table.class).value().isEmpty()) {
            return bean.getAnnotation(Table.class).value();
        }
        return StringUtil.snakeCase(bean.getSimpleName());
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IgnoreUpdate {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IgnoreInsert {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DeleteMark {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Transient {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Id {
        public boolean autoGenerated() default false;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Table {
        public String value() default "";
    }

    @FunctionalInterface
    public static interface Func<T> {
        public String apply(T var1);
    }
}

