/*
 * Decompiled with CFR 0.152.
 */
package com.di.kit;

import com.di.kit.Xml;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class XmlBuilder {
    private Map<String, Object> xmlMap;
    private Node node;

    public XmlBuilder() {
    }

    public XmlBuilder(String xml) {
        this.parse(xml);
    }

    public XmlBuilder parse(String xml) {
        this.xmlMap = Xml.toMap(xml);
        this.node = this.fromMapObject(this.xmlMap);
        return this;
    }

    public Node getById(String id) {
        return this.getById(this.node, id);
    }

    public Node getById(Node nod, String id) {
        List<Node> list = this.getByAttrValue(nod, "id", id);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    public List<Node> getByAttrName(String attrName) {
        return this.getByAttrName(this.node, attrName);
    }

    public List<Node> getByAttrName(Node nod, String attrName) {
        return this.getByAttrValue(nod, attrName, null);
    }

    public List<Node> getByAttrValue(String attrName, String attrValue) {
        return this.getByAttrValue(this.node, attrName, attrValue);
    }

    public List<Node> getByAttrValue(Node nod, String attrName, String attrValue) {
        if (nod != null && attrName != null) {
            ArrayList<Node> ns = new ArrayList<Node>();
            if (nod.attributes() != null && nod.attributes().containsKey(attrName) && (attrValue == null || attrValue.equals(nod.attribute(attrName)))) {
                ns.add(nod);
            }
            if (nod.children() != null && nod.children().size() > 0) {
                for (Node n : nod.children()) {
                    ns.addAll(this.getByAttrValue(n, attrName, attrValue));
                }
            }
            return ns;
        }
        return null;
    }

    public List<Node> getByNodeName(String name) {
        return this.getByNodeName(this.node, name);
    }

    public List<Node> getByNodeName(Node node, String name) {
        ArrayList<Node> ns = new ArrayList<Node>();
        if (node.name().equals(name)) {
            ns.add(node);
        } else if (node.children() != null && node.children().size() > 0) {
            for (Node n : node.children()) {
                ns.addAll(this.getByNodeName(n, name));
            }
        }
        return ns;
    }

    public Node fromMapObject(Object mapObject) {
        Node node = new Node();
        node.parent = null;
        if (mapObject.getClass() == LinkedHashMap.class) {
            Map map = (Map)mapObject;
            node.attributes = (LinkedHashMap)map.get("element attributes");
            node.name = String.valueOf(map.get("element name"));
            if (map.size() > 0) {
                ArrayList<Node> ns = new ArrayList<Node>();
                for (String k : map.keySet()) {
                    if (k.equals("element attributes") || k.equals("element name")) continue;
                    Node n = null;
                    if (map.get(k).getClass() == LinkedHashMap.class) {
                        n = this.fromMapObject(map.get(k));
                        n.parent = node;
                        ns.add(n);
                        continue;
                    }
                    if (map.get(k).getClass() == ArrayList.class) {
                        List os = (List)map.get(k);
                        for (Object o : os) {
                            n = this.fromMapObject(o);
                            n.parent = node;
                            ns.add(n);
                        }
                        continue;
                    }
                    node.text = String.valueOf(map.get(k));
                }
                node.nodes = ns;
            }
        } else {
            node.text = String.valueOf(mapObject);
        }
        return node;
    }

    public Map<String, Object> toMap() {
        return this.xmlMap;
    }

    public Node rootNode() {
        return this.node;
    }

    public Node createRootNode(String ... name) {
        this.node = new Node();
        if (name != null && name.length > 0) {
            this.node.name = name[0];
        }
        return this.node;
    }

    public static class Node {
        private Node parent;
        private LinkedHashMap<String, String> attributes;
        private List<Node> nodes;
        private String name;
        private String text;

        public Node() {
        }

        public Node(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public Node name(String name) {
            this.name = name;
            return this;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("<").append(this.name);
            if (this.attributes != null && !this.attributes.isEmpty()) {
                for (String k : this.attributes.keySet()) {
                    s.append(" ").append(k).append("=\"").append(this.attribute(k)).append("\"");
                }
            }
            s.append(">");
            if (!this.children().isEmpty()) {
                for (Node n : this.children()) {
                    s.append(n.toString());
                }
            } else if (this.text != null && (this.text.contains("<") || this.text.contains(">"))) {
                s.append("<![CDATA[ ").append(this.text).append(" ]]>");
            } else {
                s.append(this.text);
            }
            s.append("</").append(this.name).append(">");
            return s.toString();
        }

        public String toFormatString() {
            StringBuilder s = new StringBuilder();
            String blank = "";
            Node p = this.parent;
            while (p != null) {
                blank = blank + "  ";
                p = p.parent;
            }
            s.append("<").append(this.name);
            if (this.attributes != null && !this.attributes.isEmpty()) {
                for (String k : this.attributes.keySet()) {
                    s.append(" ").append(k).append("=\"").append(this.attribute(k)).append("\"");
                }
            }
            s.append(">\n");
            if (!this.children().isEmpty()) {
                for (Node n : this.children()) {
                    String b = "";
                    p = n.parent;
                    while (p != null) {
                        b = b + "  ";
                        p = p.parent;
                    }
                    s.append(b).append(n.toFormatString()).append("\n");
                }
            } else {
                s.append(blank).append("  ");
                if (this.text != null && (this.text.contains("<") || this.text.contains(">")) && this.children().size() == 0) {
                    s.append("<![CDATA[ ").append(this.text).append(" ]]>");
                } else {
                    s.append(this.text);
                }
                s.append("\n");
            }
            s.append(blank).append("</").append(this.name).append(">");
            return s.toString();
        }

        public String text() {
            return this.text;
        }

        public Node text(String text) {
            this.text = text;
            return this;
        }

        public Node parent() {
            return this.parent;
        }

        public String attribute(String name) {
            return this.attributes == null ? null : this.attributes.get(name);
        }

        public LinkedHashMap<String, String> attributes() {
            return this.attributes;
        }

        public Node addAttribute(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap();
            }
            this.attributes.put(name, value);
            return this;
        }

        public List<Node> children() {
            if (this.nodes == null) {
                this.nodes = new ArrayList<Node>();
            }
            return this.nodes;
        }

        public Node createNode() {
            Node n = new Node();
            n.parent = this;
            return n;
        }

        public Node append(Node node) {
            this.children().add(node);
            return this;
        }

        public Node appendNode(Node nod) {
            return this.appendNodes(nod);
        }

        public Node appendNodes(Node ... nodes) {
            return this.appendNodes(Arrays.asList(nodes));
        }

        public Node appendNodes(List<Node> nodes) {
            this.children().addAll(nodes);
            return this;
        }
    }
}

