/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

public class ClassesUtil {
    public static ArrayList<Class> getAllClassByInterface(Class clazz) {
        ArrayList<Class> list = new ArrayList<Class>();
        if (clazz.isInterface()) {
            try {
                ArrayList<Class> allClass = ClassesUtil.getAllClass(clazz.getPackage().getName());
                for (int i = 0; i < allClass.size(); ++i) {
                    if (!clazz.isAssignableFrom(allClass.get(i)) || clazz.equals(allClass.get(i))) continue;
                    list.add(allClass.get(i));
                }
            }
            catch (Exception e) {
                System.out.println("\u51fa\u73b0\u5f02\u5e38");
            }
        }
        return list;
    }

    public static ArrayList<Class> getAllClass(String packagename) {
        ArrayList<Class> list = new ArrayList<Class>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packagename.replace('.', '/');
        try {
            ArrayList<File> fileList = new ArrayList<File>();
            Enumeration<URL> enumeration = classLoader.getResources("" + path);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                fileList.add(new File(url.getFile()));
            }
            for (int i = 0; i < fileList.size(); ++i) {
                list.addAll(ClassesUtil.findClass((File)fileList.get(i), packagename));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static ArrayList<Class> findClass(File file, String packagename) {
        File[] files;
        ArrayList<Class> list = new ArrayList<Class>();
        if (!file.exists()) {
            return list;
        }
        for (File file2 : files = file.listFiles()) {
            if (file2.isDirectory()) {
                assert (!file2.getName().contains("."));
                ArrayList<Class> arrayList = ClassesUtil.findClass(file2, packagename + "." + file2.getName());
                list.addAll(arrayList);
                continue;
            }
            if (!file2.getName().endsWith(".class")) continue;
            try {
                list.add(Class.forName(packagename + '.' + file2.getName().substring(0, file2.getName().length() - 6)));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

