/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtil {
    public static Date getCurrentDate() {
        return new Date();
    }

    public static Date getCurrentZeroDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.getCurrentDate());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDaysLater(int days) {
        return DateUtil.getDaysLater(DateUtil.getCurrentDate(), days);
    }

    public static Date getDaysLater(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    public static Date getWeeksLater(int weeks) {
        return DateUtil.getWeeksLater(DateUtil.getCurrentDate(), weeks);
    }

    public static Date getWeeksLater(Date date, int weeks) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(3, weeks);
        return calendar.getTime();
    }

    public static Date getMonthsLater(int months) {
        return DateUtil.getMonthsLater(DateUtil.getCurrentDate(), months);
    }

    public static Date getMonthsLater(Date date, int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static Date getYearsLater(int years) {
        return DateUtil.getYearsLater(DateUtil.getCurrentDate(), years);
    }

    public static Date getYearsLater(Date date, int years) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        return calendar.getTime();
    }

    public static Date getPreviousYear() {
        return DateUtil.getYearsLater(-1);
    }

    public static Date getNextYear() {
        return DateUtil.getYearsLater(1);
    }

    public static Date getPreviousMonth() {
        return DateUtil.getMonthsLater(-1);
    }

    public static Date getNextMonth() {
        return DateUtil.getMonthsLater(1);
    }

    public static Date getPreviousDay() {
        return DateUtil.getDaysLater(-1);
    }

    public static Date getNextDay() {
        return DateUtil.getDaysLater(1);
    }

    public static int daysBetween1(Date date1, Date date2) {
        long time1 = date1.getTime();
        long time2 = date2.getTime();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static int daysBetween2(Date date1, Date date2) {
        Calendar can1 = Calendar.getInstance();
        can1.setTime(date1);
        Calendar can2 = Calendar.getInstance();
        can2.setTime(date2);
        int year1 = can1.get(1);
        int year2 = can2.get(1);
        int days = 0;
        Calendar can = null;
        if (can1.before(can2)) {
            days -= can1.get(6);
            days += can2.get(6);
            can = can1;
        } else {
            days -= can2.get(6);
            days += can1.get(6);
            can = can2;
        }
        for (int i = 0; i < Math.abs(year2 - year1); ++i) {
            days += can.getActualMaximum(6);
            can.add(1, 1);
        }
        return days;
    }

    public static Date getSecondsLater(int seconds) {
        return new Date(new Date().getTime() + (long)(seconds * 1000));
    }

    public static Date getMinutesLater(int minutes) {
        return DateUtil.getSecondsLater(minutes * 60);
    }

    public static Date getHoursLater(int hours) {
        return DateUtil.getMinutesLater(hours * 60);
    }

    public static Date getCurrentMonthFirstDate() {
        return DateUtil.getMonthFirstDate(0);
    }

    public static Date getCurrentMonthLastDate() {
        return DateUtil.getMonthLastDate(0);
    }

    public static Date getMonthFirstDate(int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, months);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getMonthLastDate(int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, months);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static int getCurrentMonthIndex() {
        SimpleDateFormat sdf = new SimpleDateFormat("MM");
        String format = sdf.format(new Date());
        return Integer.valueOf(format);
    }

    public static List<Date[]> getCurrentYearMonts() {
        ArrayList<Date[]> dates = new ArrayList<Date[]>();
        int monthIndex = DateUtil.getCurrentMonthIndex();
        for (int i = 0; i < 12; ++i) {
            Date[] dts = new Date[]{DateUtil.getMonthFirstDate(i - monthIndex + 1), DateUtil.getMonthLastDate(i - monthIndex + 1)};
            dates.add(dts);
        }
        return dates;
    }

    public static List<Date[]> getPreviousYearMonts() {
        ArrayList<Date[]> dates = new ArrayList<Date[]>();
        int monthIndex = DateUtil.getCurrentMonthIndex();
        for (int i = 0; i < 12; ++i) {
            int month = monthIndex + 11 - i;
            Date[] dts = new Date[]{DateUtil.getMonthFirstDate(-month), DateUtil.getMonthLastDate(-month)};
            dates.add(dts);
        }
        return dates;
    }
}

