/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit;

import com.di.toolkit.data.annotation.Alias;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    public static List<String> split(String json) {
        int ang1 = 0;
        int ang2 = 0;
        int squa1 = 0;
        int squa2 = 0;
        int quot = 0;
        ArrayList<Integer> is = new ArrayList<Integer>();
        ArrayList<String> ss = new ArrayList<String>();
        block8: for (int off = 0; off < json.length(); ++off) {
            char c = json.charAt(off);
            switch (c) {
                case '\"': {
                    if (off != 0 && json.charAt(off - 1) == '\\') continue block8;
                    ++quot;
                    continue block8;
                }
                case '{': {
                    if (quot % 2 != 0) continue block8;
                    ++ang1;
                    continue block8;
                }
                case '}': {
                    if (quot % 2 != 0) continue block8;
                    ++ang2;
                    continue block8;
                }
                case '[': {
                    if (quot % 2 != 0) continue block8;
                    ++squa1;
                    continue block8;
                }
                case ']': {
                    if (quot % 2 != 0) continue block8;
                    ++squa2;
                    continue block8;
                }
                case ',': {
                    if (quot % 2 != 0 || ang1 != ang2 || squa1 != squa2) continue block8;
                    is.add(off);
                    continue block8;
                }
            }
        }
        if (is.size() > 1) {
            ss.add(json.substring(0, (Integer)is.get(0)));
            for (int i = 0; i < is.size() - 1; ++i) {
                ss.add(json.substring((Integer)is.get(i) + 1, (Integer)is.get(i + 1)));
            }
            ss.add(json.substring((Integer)is.get(is.size() - 1) + 1));
        } else if (is.size() == 1) {
            ss.add(json.substring(0, (Integer)is.get(0)));
            ss.add(json.substring((Integer)is.get(0) + 1));
        } else {
            ss.add(json);
        }
        return ss;
    }

    public static List<String> splitList(String str) {
        int ang1 = 0;
        int ang2 = 0;
        int squa1 = 0;
        int squa2 = 0;
        int quot = 0;
        ArrayList<Integer> is = new ArrayList<Integer>();
        ArrayList<String> ss = new ArrayList<String>();
        block8: for (int off = 0; off < str.length(); ++off) {
            char c = str.charAt(off);
            switch (c) {
                case '\"': {
                    if (off != 0 && str.charAt(off - 1) == '\\') continue block8;
                    ++quot;
                    continue block8;
                }
                case '{': {
                    if (quot % 2 != 0) continue block8;
                    ++ang1;
                    continue block8;
                }
                case '}': {
                    if (quot % 2 != 0) continue block8;
                    ++ang2;
                    continue block8;
                }
                case '[': {
                    if (quot % 2 != 0) continue block8;
                    ++squa1;
                    continue block8;
                }
                case ']': {
                    if (quot % 2 != 0) continue block8;
                    ++squa2;
                    continue block8;
                }
                case ',': {
                    if (quot % 2 != 0 || ang1 != ang2 || squa1 != squa2 || str.charAt(off - 1) != '}' || str.charAt(off + 1) != '{') continue block8;
                    is.add(off);
                    continue block8;
                }
            }
        }
        if (is.size() > 1) {
            ss.add(str.substring(0, (Integer)is.get(0)));
            for (int i = 0; i < is.size() - 1; ++i) {
                ss.add(str.substring((Integer)is.get(i) + 1, (Integer)is.get(i + 1)));
            }
            ss.add(str.substring((Integer)is.get(is.size() - 1) + 1));
        } else if (is.size() == 1) {
            ss.add(str.substring(0, (Integer)is.get(0)));
            ss.add(str.substring((Integer)is.get(0) + 1));
        } else {
            ss.add(str);
        }
        return ss;
    }

    private static Map<String, Object> toMap(String str) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        String s0 = str.substring(str.indexOf("{") + 1, str.lastIndexOf("}")).trim();
        for (String s : JsonUtil.split(s0)) {
            m.put(s.substring(0, s.indexOf(":") - 1).replaceAll("\"", "").trim(), JsonUtil.val(s.substring(s.indexOf(":") + 1).trim()));
        }
        return m;
    }

    private static List<Object> toList(String str) {
        ArrayList<Object> ls;
        block3: {
            String s0;
            block2: {
                s0 = str.substring(str.indexOf("[") + 1, str.lastIndexOf("]")).trim();
                ls = new ArrayList<Object>();
                if (!s0.startsWith("{")) break block2;
                for (String s1 : JsonUtil.splitList(s0)) {
                    ls.add(JsonUtil.toMap(s1));
                }
                break block3;
            }
            if (!s0.startsWith("\"")) break block3;
            for (String s : s0.split(",")) {
                ls.add(s.replaceAll("\"", ""));
            }
        }
        return ls;
    }

    private static Object val(String str) {
        if (str.startsWith("\"")) {
            return str.replaceAll("\"", "");
        }
        if (str.startsWith("{")) {
            return JsonUtil.toMap(str);
        }
        if (str.startsWith("[")) {
            return JsonUtil.toList(str);
        }
        return str;
    }

    public static String toJson(Object o) {
        StringBuilder s = new StringBuilder("{");
        try {
            Field[] fs;
            if (o.getClass() == Map.class || o.getClass() == HashMap.class) {
                Map m = (Map)o;
                for (Object key : m.keySet()) {
                    Object val = m.get(key);
                    if (val.getClass() == String.class) {
                        s.append("\"").append(key).append("\":\"").append(val).append("\",");
                        continue;
                    }
                    if (val.getClass() == Byte.class || val.getClass() == Short.class || val.getClass() == Integer.class || val.getClass() == Long.class || val.getClass() == Double.class || val.getClass() == Float.class || val.getClass() == Boolean.class || val.getClass() == Boolean.TYPE || val.getClass() == Byte.TYPE || val.getClass() == Short.TYPE || val.getClass() == Integer.TYPE || val.getClass() == Long.TYPE || val.getClass() == Double.TYPE || val.getClass() == Float.TYPE) {
                        s.append("\"").append(key).append("\":").append(val).append(",");
                        continue;
                    }
                    if (val.getClass() == Date.class) {
                        s.append("\"").append(key).append("\":\"").append(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(val)).append("\",");
                        continue;
                    }
                    s.append("\"").append(key).append("\":").append(JsonUtil.toJson(val)).append(",");
                }
                s = new StringBuilder(s.toString().substring(0, s.length() - 1));
                s.append("}");
                return s.toString();
            }
            for (Field f : fs = o.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                String n = f.getName();
                if (f.isAnnotationPresent(Alias.class)) {
                    if (!f.getAnnotation(Alias.class).json().isEmpty()) {
                        n = f.getAnnotation(Alias.class).json();
                    } else if (!f.getAnnotation(Alias.class).value().isEmpty()) {
                        n = f.getAnnotation(Alias.class).value();
                    }
                }
                if (f.get(o) == null) continue;
                if (f.getType() == Byte.TYPE || f.getType() == Byte.class) {
                    s.append("\"").append(n).append("\":").append(String.valueOf(f.getByte(o))).append(",");
                    continue;
                }
                if (f.getType() == Short.TYPE || f.getType() == Short.class) {
                    s.append("\"").append(n).append("\":").append(String.valueOf(f.getShort(o))).append(",");
                    continue;
                }
                if (f.getType() == Integer.TYPE || f.getType() == Integer.class) {
                    s.append("\"").append(n).append("\":").append(String.valueOf(f.getInt(o))).append(",");
                    continue;
                }
                if (f.getType() == Long.TYPE || f.getType() == Long.class) {
                    s.append("\"").append(n).append("\":").append(String.valueOf(f.getLong(o))).append(",");
                    continue;
                }
                if (f.getType() == Double.TYPE || f.getType() == Double.class) {
                    s.append("\"").append(n).append("\":").append(String.valueOf(f.getDouble(o))).append(",");
                    continue;
                }
                if (f.getType() == Float.TYPE || f.getType() == Float.class) {
                    s.append("\"").append(n).append("\":").append(String.valueOf(f.getFloat(o))).append(",");
                    continue;
                }
                if (f.getType() == Boolean.TYPE || f.getType() == Boolean.class) {
                    s.append("\"").append(n).append("\":").append(String.valueOf(f.getBoolean(o))).append(",");
                    continue;
                }
                if (f.getType() == Date.class) {
                    s.append("\"").append(n).append("\":\"").append(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(f.get(o))).append("\",");
                    continue;
                }
                if (f.getType() == Collection.class || f.getType() == List.class || f.getType() == ArrayList.class) {
                    List os = (List)f.get(o);
                    StringBuilder s1 = new StringBuilder();
                    for (Object object : os) {
                        s1.append(JsonUtil.toJson(object)).append(",");
                    }
                    s.append("\"").append(n).append("\":[").append(s1.toString().substring(0, s1.length() - 1)).append("],");
                    continue;
                }
                if (f.getType() == String.class) {
                    s.append("\"").append(n).append("\":\"").append((String)f.get(o)).append("\",");
                    continue;
                }
                if (!(f.getType() instanceof Object)) continue;
                s.append("\"").append(n).append("\":").append(JsonUtil.toJson(f.get(o))).append(",");
            }
            s = new StringBuilder(s.toString().substring(0, s.length() - 1));
            s.append("}");
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return s.toString();
    }

    public static <T> T toObject(String json, Class<T> cl) {
        T o = null;
        try {
            if (json.startsWith("{")) {
                Map<String, Object> map = JsonUtil.toMap(json);
                if (cl == Map.class || cl == HashMap.class) {
                    return (T)map;
                }
                o = cl.newInstance();
                JsonUtil.set(map, o);
            } else if (json.startsWith("[")) {
                List<Object> list = JsonUtil.toList(json);
                return (T)list;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return o;
    }

    private static <T> void set(Map<String, Object> m, T o) {
        try {
            for (Field f : o.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                if (m.get(f.getName()) == null) continue;
                if (f.getType() == Boolean.TYPE || f.getType() == Boolean.class) {
                    f.set(o, Boolean.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Byte.TYPE || f.getType() == Byte.class) {
                    f.set(o, Byte.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Short.TYPE || f.getType() == Short.class) {
                    f.set(o, Short.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Integer.TYPE || f.getType() == Integer.class) {
                    f.set(o, Integer.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Long.TYPE || f.getType() == Long.class) {
                    f.set(o, Long.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Double.TYPE || f.getType() == Double.class) {
                    f.set(o, Double.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == Float.TYPE || f.getType() == Float.class) {
                    f.set(o, Float.valueOf(m.get(f.getName()).toString()));
                    continue;
                }
                if (f.getType() == String.class) {
                    f.set(o, m.get(f.getName()).toString());
                    continue;
                }
                if (f.getType() == List.class || f.getType() == ArrayList.class) {
                    Type type = f.getGenericType();
                    ParameterizedType pt = (ParameterizedType)type;
                    Type type2 = pt.getActualTypeArguments()[0];
                    String typeName = type2.getTypeName();
                    List os = (List)m.get(f.getName());
                    ArrayList os_ = new ArrayList();
                    for (Object oo : os) {
                        Map m0 = (Map)oo;
                        Object o0 = Class.forName(typeName).newInstance();
                        JsonUtil.set(m0, o0);
                        os_.add(o0);
                    }
                    f.set(o, os_);
                    continue;
                }
                if (!(f.getType() instanceof Object)) continue;
                Object fo = f.getType().newInstance();
                Map m0 = (Map)m.get(f.getName());
                JsonUtil.set(m0, fo);
                f.set(o, fo);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            e.printStackTrace();
        }
    }
}

