/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit;

import com.di.toolkit.FileUtil;
import com.di.toolkit.IdWorker;
import com.di.toolkit.JdbcMetaUtil;
import com.di.toolkit.Str;
import com.di.toolkit.StringUtil;
import java.io.File;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MvcGenerater {
    private PersistenceEnum persistence;
    private ControlEnum control;
    private ViewEnum view;
    private Class<?> entityBaseClass;
    private Class<?> mapperBaseClass;
    private Class<?> serviceBaseClass;
    private Class<?> controlBaseClass;
    private List<JdbcMetaUtil.Table> tables = new ArrayList<JdbcMetaUtil.Table>();
    private String entityPackage;
    private String mapperPackage;
    private String servicePackage;
    private String controlPackage;
    String path = null;

    public MvcGenerater() {
        this.path = this.getPath();
    }

    public MvcGenerater(String url, String username, String password) {
        JdbcMetaUtil.setConfig(url, username, password);
        this.path = this.getPath();
    }

    public MvcGenerater setPersistence(PersistenceEnum persistence) {
        this.persistence = persistence;
        return this;
    }

    public MvcGenerater setControl(ControlEnum control) {
        this.control = control;
        return this;
    }

    public MvcGenerater setView(ViewEnum view) {
        this.view = view;
        return this;
    }

    public <T> MvcGenerater setEntityBaseClass(Class<T> entityBaseClass) {
        this.entityBaseClass = entityBaseClass;
        return this;
    }

    public <T> MvcGenerater setMapperBaseClass(Class<T> mapperBaseClass) {
        this.mapperBaseClass = mapperBaseClass;
        return this;
    }

    public <T> MvcGenerater setServiceBaseClass(Class<T> serviceBaseClass) {
        this.serviceBaseClass = serviceBaseClass;
        return this;
    }

    public <T> MvcGenerater setControlBaseClass(Class<T> controlBaseClass) {
        this.controlBaseClass = controlBaseClass;
        return this;
    }

    public MvcGenerater setTables(String ... tableNames) {
        try {
            if (tableNames == null || tableNames.length == 0) {
                this.tables = JdbcMetaUtil.getAllTables();
            } else {
                for (String n : tableNames) {
                    this.tables.add(JdbcMetaUtil.getTable(n));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this;
    }

    public MvcGenerater createEntity(String entityPackage) {
        this.entityPackage = entityPackage;
        for (JdbcMetaUtil.Table t : this.tables) {
            Str s = new Str();
            String className = StringUtil.trimUnderlinedFirstCharUpper(t.getName());
            className = StringUtil.firstCharUpper(className);
            s.add("package ").add(entityPackage).line(";").newLine();
            if (this.entityBaseClass == null) {
                s.line("/**").add(" * ").line(t.getComment()).line(" * @author MvcGenerator");
                s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd hh:mm").format(new Date()));
                s.line(" */");
                s.add("public class ").add(className).line(" implements Serializable {");
                s.add("\tprivate static final long serialVersionUID = ").add(IdWorker.nextId()).line("L;");
                for (JdbcMetaUtil.Column c1 : t.getAllColumns()) {
                    if (!c1.getRemark().isEmpty()) {
                        s.line("    /**").add("\t * ").line(c1.getRemark()).line("\t */");
                    }
                    s.add("    private ").add(c1.getType().getJava()).add(" ");
                    s.add(StringUtil.firstCharLower(StringUtil.trimUnderlinedFirstCharUpper(c1.getName()))).line(";");
                }
            } else {
                s.add("import ").add(this.entityBaseClass.getName()).line(";");
                s.line("/**").add(" * ").line(t.getComment()).line(" * @author MvcGenerator");
                s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd hh:mm").format(new Date()));
                s.line(" */");
                s.add("public class ").add(className).add(" extends ").add(this.entityBaseClass.getSimpleName()).line(" {");
                s.add("\tprivate static final long serialVersionUID = ").add(IdWorker.nextId()).line("L;");
                for (JdbcMetaUtil.Column c1 : t.getAllColumns()) {
                    String fn = StringUtil.firstCharLower(StringUtil.trimUnderlinedFirstCharUpper(c1.getName()));
                    if (this.contain(this.entityBaseClass, fn)) continue;
                    if (!c1.getRemark().isEmpty()) {
                        s.line("    /**").add("\t * ").line(c1.getRemark()).line("\t */");
                    }
                    s.add("    private ").add(c1.getType().getJava()).add(" ");
                    s.add(fn).line(";");
                }
            }
            s.add("}");
            String epath = this.getPath() + entityPackage.replace(".", "/");
            this.out(epath + "/" + className + ".java", s.toString());
        }
        return this;
    }

    private boolean contain(Class<?> o, String n) {
        boolean b = false;
        try {
            if (o.getSuperclass() != Object.class) {
                b = this.contain(o.getSuperclass(), n);
            }
            if (!b) {
                b = o.getDeclaredField(n) != null;
            }
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return b;
    }

    public MvcGenerater createXml(String xmlPath) {
        for (JdbcMetaUtil.Table t : this.tables) {
            String s0;
            Str s = new Str();
            String className = StringUtil.trimUnderlinedFirstCharUpper(t.getName());
            className = StringUtil.firstCharUpper(className);
            s.line("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            s.line("<!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\" >");
            s.add("<mapper namespace=\"").add(this.mapperPackage).add(".").add(className).line("Mapper\">");
            s.line("\t<insert id=\"insert\">");
            s.add("\t\tinsert into `").add(t.getName()).line("` (");
            for (JdbcMetaUtil.Column c : t.getAllColumns()) {
                s.add("\t\t`").add(c.getName()).add("`,").newLine();
            }
            s.deleteLastChar();
            s.line("\t\t)values (");
            for (JdbcMetaUtil.Column c : t.getAllColumns()) {
                s0 = StringUtil.firstCharLower(StringUtil.trimUnderlinedFirstCharUpper(c.getName()));
                s.add("\t\t#{").add(s0).add("},").newLine();
            }
            s.deleteLastChar();
            s.line("\t\t)").line("\t</insert>");
            s.line("    <update id=\"update\">");
            s.add("\t\tupdate `").add(t.getName()).line("` set ");
            for (JdbcMetaUtil.Column c : t.getColumns()) {
                s0 = StringUtil.firstCharLower(StringUtil.trimUnderlinedFirstCharUpper(c.getName()));
                s.add("\t\t`").add(c.getName()).add("` = #{").add(s0).add("},").newLine();
            }
            s.deleteLastChar();
            s.line("\t\tWHERE id = #{id}");
            s.line("\t</update>");
            s.line("    <delete id=\"delete\">");
            s.add("\t\tupdate `").add(t.getName()).line("` set");
            s.line("\t\t`del_flag` =#{DEL_FLAG_DELETE}");
            s.line("\t\tWHERE id = #{id}").line("\t</delete>");
            s.add("    <select id=\"get\" resultType=\"").add(className).line("\">");
            s.add("        SELECT * FROM `").add(t.getName());
            s.line("` WHERE `del_flag` = 0 AND `id` = #{id}").line("    </select>");
            s.add("    <select id=\"findList\" resultType=\"").add(className).line("\">");
            s.add("        SELECT * FROM `").add(t.getName());
            s.line("` WHERE `del_flag` = #{DEL_FLAG_NORMAL} ORDER BY `updated_at` DESC");
            s.line("    </select>").line("</mapper>");
            this.out(this.path.replaceFirst("java", "resources") + xmlPath + className + "Mapper.xml", s.toString());
        }
        return this;
    }

    public MvcGenerater createMapper(String mapperPackage) {
        this.mapperPackage = mapperPackage;
        for (JdbcMetaUtil.Table t : this.tables) {
            Str s = new Str();
            String className = StringUtil.trimUnderlinedFirstCharUpper(t.getName());
            className = StringUtil.firstCharUpper(className);
            s.add("package ").add(mapperPackage).line(";").newLine();
            if (this.mapperBaseClass != null) {
                s.add("import ").add(this.mapperBaseClass.getName()).line(";");
            }
            s.add("import ").add(this.entityPackage).add(".").add(className).add(";").newLine().newLine();
            s.line("/**").add(" * ").line(t.getComment() + "Mapper\u63a5\u53e3").line(" * @author Generator");
            s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd hh:mm").format(new Date()));
            s.line(" */");
            s.add("public interface ").add(className).add("Mapper");
            if (this.mapperBaseClass != null) {
                s.add(" extends ").add(this.mapperBaseClass.getSimpleName());
            }
            s.line(" {").newLine().add("}");
            this.out(this.path + mapperPackage.replace(".", "/") + "/" + className + "Mapper.java", s.toString());
        }
        return this;
    }

    public MvcGenerater createService(String servicePackage) {
        this.servicePackage = servicePackage;
        for (JdbcMetaUtil.Table t : this.tables) {
            Str s = new Str();
            String className = StringUtil.trimUnderlinedFirstCharUpper(t.getName());
            className = StringUtil.firstCharUpper(className);
            s.add("package ").add(servicePackage).line(";").newLine();
            if (this.serviceBaseClass != null) {
                s.add("import ").add(this.serviceBaseClass.getName()).line(";");
            }
            s.add("import ").add(this.entityPackage).add(".").add(className).add(";").newLine();
            s.add("import ").add(this.mapperPackage).add(".").add(className).add("Mapper;").newLine().newLine();
            s.line("/**").add(" * ").line(t.getComment() + "service").line(" * @author Generator");
            s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd hh:mm").format(new Date()));
            s.line(" */");
            s.add("public class ").add(className).add("Service");
            if (this.serviceBaseClass != null) {
                s.add(" extends ").add(this.serviceBaseClass.getSimpleName());
            }
            s.line(" {").newLine().add("}");
            this.out(this.path + servicePackage.replace(".", "/") + "/" + className + "Service.java", s.toString());
        }
        return this;
    }

    public MvcGenerater createControl(String controlPackage) {
        this.controlPackage = controlPackage;
        for (JdbcMetaUtil.Table t : this.tables) {
            Str s = new Str();
            String className = StringUtil.trimUnderlinedFirstCharUpper(t.getName());
            className = StringUtil.firstCharUpper(className);
            s.add("package ").add(controlPackage).line(";").newLine();
            if (this.controlBaseClass != null) {
                s.add("import ").add(this.controlBaseClass.getName()).line(";");
            }
            s.add("import ").add(this.entityPackage).add(".").add(className).add(";").newLine();
            s.add("import ").add(this.servicePackage).add(".").add(className).add("Service;").newLine().newLine();
            s.line("/**").add(" * ").line(t.getComment() + "controller").line(" * @author Generator");
            s.add(" * @date ").line(new SimpleDateFormat("yyyy-MM-dd hh:mm").format(new Date()));
            s.line(" */");
            s.add("public class ").add(className).add("Controller");
            if (this.controlBaseClass != null) {
                s.add(" extends ").add(this.controlBaseClass.getSimpleName());
            }
            s.line(" {").newLine().add("}");
            this.out(this.path + controlPackage.replace(".", "/") + "/" + className + "Controller.java", s.toString());
        }
        return this;
    }

    public MvcGenerater createView(String viewPath) {
        for (JdbcMetaUtil.Table t : this.tables) {
            String cn;
            Str s = new Str();
            String className = StringUtil.trimUnderlinedFirstCharUpper(t.getName());
            s.line("<div class=\"container-fluid\">");
            s.line("    <div class=\"row\">");
            s.line("        <div class=\"col-md-12\">");
            s.line("            <form class=\"form-inline\" role=\"form\">");
            s.line("                <input type=\"hidden\" id=\"pageNum\" name=\"pageNum\" value=\"${pageInfo.pageNum}\">");
            s.line("                <input type=\"hidden\" id=\"pageSize\" name=\"pageSize\" value=\"${pageInfo.pageSize}\">");
            s.line("                <div class=\"form-group\">");
            s.line("                    <a type=\"button\" class=\"btn btn-primary\" onclick=\"edit(0)\">\u65b0\u5efa</a>");
            s.line("                </div>");
            s.line("            </form>");
            s.line("        </div>");
            s.line("    </div>");
            s.line("    <br/>");
            s.line("    <div class=\"row\" id=\"_ba\">");
            s.line("        <div class=\"col-md-12\" id=\"ba\">");
            s.line("            <table class=\"table table-bordered table-hover\">");
            s.line("                <thead>");
            s.line("                <tr>");
            for (JdbcMetaUtil.Column c : t.getAllColumns()) {
                s.add("                    <th>").add(c.getRemark() == null || c.getRemark().isEmpty() ? c.getName() : c.getRemark()).line("</th>");
            }
            s.line("                    <th>\u64cd\u4f5c</th>");
            s.line("                </tr>");
            s.line("                </thead>");
            s.line("                <tbody>");
            s.line("                    <#list pageInfo.list as p>");
            s.line("                    <tr>");
            for (JdbcMetaUtil.Column c : t.getAllColumns()) {
                String cn2 = StringUtil.firstCharLower(StringUtil.trimUnderlinedFirstCharUpper(c.getName()));
                if (c.getType().getJava().equals("java.util.Date")) {
                    s.add("                        <td>${p.").add(cn2).line("?string('yyyy-MM-dd HH:mm:ss')}</td>");
                    continue;
                }
                s.add("                        <td>${p.").add(cn2).line("!}</td>");
            }
            JdbcMetaUtil.Column key = t.getPrimaryKeys().get(0);
            String kn = StringUtil.firstCharLower(StringUtil.trimUnderlinedFirstCharUpper(key.getName()));
            s.add("                        <td><a href=\"#\" class=\"btn btn-default btn-xs\" onclick=\"edit('${p.").add(kn).line("}')\">\u7f16\u8f91</a></td>");
            s.line("                    </tr>");
            s.line("                    </#list>");
            s.line("                </tbody>");
            s.line("            </table>");
            s.line("            <div class=\"col-xs-12\">");
            s.line("                <#if (pageInfo.pageNum>1)>");
            s.line("                    <a href=\"#\" onclick=\"pageTo('${pageInfo.prePage}')\">\u4e0a\u4e00\u9875</a>");
            s.line("                <#else>");
            s.line("                    \u4e0a\u4e00\u9875");
            s.line("                </#if>");
            s.line("                <#if (pageInfo.pageNum<pageInfo.pages)>");
            s.line("                    <a href=\"#\" onclick=\"pageTo('${pageInfo.nextPage}')\">\u4e0b\u4e00\u9875</a>");
            s.line("                <#else>");
            s.line("                    \u4e0b\u4e00\u9875");
            s.line("                </#if>");
            s.line("                ,\u5f53\u524d\u7b2c${pageInfo.pageNum}\u9875 \u5171 ${pageInfo.total} \u9879,${pageInfo.pages} \u9875,\u6bcf\u9875");
            s.line("                <select style=\"height: 32px;\" id=\"pgSize\" onchange=\"changePgSize()\">");
            s.line("                    <option value=\"10\" <#if pageInfo.pageSize==10>selected</#if>>10</option>");
            s.line("                    <option value=\"20\" <#if pageInfo.pageSize==20>selected</#if>>20</option>");
            s.line("                    <option value=\"50\" <#if pageInfo.pageSize==50>selected</#if>>50</option>");
            s.line("                </select> \u9879 \u5230\u7b2c <input type=\"text\"");
            s.line("                                      style=\"width:48px;height: 32px;\" id=\"pgNum\"> \u9875");
            s.line("                <button class=\"btn btn-default\" onclick=\"pageJunp()\">GO</button>");
            s.line("            </div>");
            s.line("        </div>");
            s.line("    </div>");
            s.line("</div>");
            s.line("<script>");
            s.line("    function changePgSize() {");
            s.line("        $(\"#pageSize\").val($(\"#pgSize\").val());");
            s.line("        pageTo(1);");
            s.line("    }");
            s.line("    function pageJunp() {");
            s.line("        pageTo($(\"#pgNum\").val());");
            s.line("    }");
            s.line("    function pageTo(num) {");
            s.line("        $(\"#pageNum\").val(num);");
            s.line("        $(\"#_ba\").load(\"list #ba\", $(\"form\").eq(0).serialize());");
            s.line("    }");
            s.line("    function edit(id) {");
            s.line("        window.location.href = \"edit?id=\" + id;");
            s.line("    }");
            s.line("</script>");
            this.createFile(this.path.replaceFirst("java", "webapp") + viewPath + className);
            this.out(this.path.replaceFirst("java", "webapp") + viewPath + className + "/list.ftl", s.toString());
            s = new Str();
            s.line("<div class=\"container-fluid\">");
            s.line("    <div class=\"row\">");
            s.line("        <div class=\"col-md-12\">");
            s.line("            <form class=\"form-inline\">");
            s.line("                <div class=\"form-group\">");
            s.line("                    <a href=\"#\" class=\"btn btn-info\" onclick=\"history.go(-1)\">\u8fd4\u56de</a>");
            s.line("                </div>");
            s.line("            </form>");
            s.line("        </div>");
            s.line("        <div class=\"col-md-12\">");
            s.line("            <form class=\"form-horizontal\">");
            s.add("                <input type=\"hidden\" name=\"").add(kn).add("\" value=\"${").add(className).add(".").add(kn).line("!}\">");
            for (JdbcMetaUtil.Column c : t.getColumns()) {
                s.line("                <div class=\"form-group\">");
                cn = StringUtil.firstCharLower(StringUtil.trimUnderlinedFirstCharUpper(c.getName()));
                s.add("                    <label class=\"col-sm-2 control-label\" for=\"").add(cn).add("\">");
                s.add(c.getRemark() == null || c.getRemark().isEmpty() ? kn : c.getRemark()).line("</label>");
                s.line("                    <div class=\"col-sm-6\">");
                s.add("                        <input id=\"").add(cn).add("\" name=\"").add(cn).add("\" class=\"form-control\" type=\"text\"");
                s.add(" value=\"${");
                if (c.getType().getJava().equals("java.util.Date")) {
                    s.add("(").add(className).add(".").add(cn).add("?string(\"yyyy-MM-dd HH:mm:ss\"))!");
                } else {
                    s.add("(").add(className).add(".").add(cn).add(")!");
                }
                s.line("}\">");
                s.line("                    </div>");
                s.line("                </div>");
            }
            s.line("                <div class=\"form-group\">");
            s.line("                    <div class=\"col-sm-2\"></div>");
            s.line("                    <a href=\"#\" class=\"btn btn-primary\" onclick=\"save();\">\u4fdd\u5b58</a>");
            s.line("                </div>");
            s.line("            </form>");
            s.line("        </div>");
            s.line("    </div>");
            s.line("</div>");
            s.line("<script>");
            s.line("    function save() {");
            s.line("        var b = true;");
            s.line("        var msg = \"\u9519\u8bef\uff1a\";");
            for (JdbcMetaUtil.Column c : t.getColumns()) {
                cn = StringUtil.firstCharLower(StringUtil.trimUnderlinedFirstCharUpper(c.getName()));
                s.add("        if ($(\"#").add(cn).line("\").val() == \"\") {");
                s.line("            b = false;");
                s.add("            msg += \"").add(c.getRemark() == null || c.getRemark().isEmpty() ? kn : c.getRemark()).line("\u4e0d\u80fd\u4e3a\u7a7a\uff1b\";");
                s.line("        }");
            }
            s.line("        if (b) {");
            s.line("            $.post(\"save\", $(\"form\").eq(0).serialize(), function (data) {");
            s.line("                if (data.message == \"success\") {");
            s.line("                    window.location.href = \"list?\";");
            s.line("                }");
            s.line("            }, 'json')");
            s.line("        } else {");
            s.line("            alert(msg);");
            s.line("        }");
            s.line("    }");
            s.line("</script>");
            this.out(this.path.replaceFirst("java", "webapp") + viewPath + className + "/edit.ftl", s.toString());
        }
        return this;
    }

    private void out(String path, String content) {
        File f = new File(path);
        if (f.exists()) {
            System.err.println("mvc generator error (exists path): " + path);
            return;
        }
        System.out.println(path);
        FileUtil.writeToFile(path, content);
    }

    private void createFile(String path) {
        File f = new File(path);
        if (!f.exists() || !f.isDirectory()) {
            f.mkdir();
        }
    }

    private String getPath() {
        if (this.path == null) {
            this.path = "";
            try {
                this.path = Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            if (this.path.indexOf("target") != -1) {
                this.path = this.path.substring(0, this.path.indexOf("target")) + "src/main/java/";
            }
        }
        return this.path;
    }

    public static enum ViewEnum {
        FREEMARKER("freemarker"),
        JSP("jsp"),
        VELOCITY("velocity");

        private String name;

        public String getName() {
            return this.name;
        }

        private ViewEnum(String name) {
            this.name = name;
        }

        public static ViewEnum getByName(String name) {
            for (ViewEnum p : ViewEnum.values()) {
                if (!p.getName().equalsIgnoreCase(name)) continue;
                return p;
            }
            return JSP;
        }
    }

    public static enum ControlEnum {
        SPRING_MVC("spring_mvc"),
        STRUTS("struts");

        private String name;

        public String getName() {
            return this.name;
        }

        private ControlEnum(String name) {
            this.name = name;
        }

        public static ControlEnum getByName(String name) {
            for (ControlEnum p : ControlEnum.values()) {
                if (!p.getName().equalsIgnoreCase(name)) continue;
                return p;
            }
            return SPRING_MVC;
        }
    }

    public static enum PersistenceEnum {
        HIBERNATE("hibernate"),
        JDBC("jdbc"),
        JDBC_MAPPER("jdbc_mapper"),
        JPA("jpa"),
        IBATIS("ibatis"),
        MYBATIS("mybatis");

        private String name;

        private PersistenceEnum(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static PersistenceEnum getByName(String name) {
            for (PersistenceEnum p : PersistenceEnum.values()) {
                if (!p.getName().equalsIgnoreCase(name)) continue;
                return p;
            }
            return JDBC;
        }
    }
}

