/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PoiXlsxUtil {
    public static List<LinkedHashMap<String, String>> getColumns(String path) throws IOException {
        ArrayList<LinkedHashMap<String, String>> list = new ArrayList<LinkedHashMap<String, String>>();
        XSSFWorkbook workbook = new XSSFWorkbook((InputStream)new FileInputStream(path));
        XSSFSheet sheet = workbook.getSheetAt(0);
        int lastRowNum = sheet.getLastRowNum();
        XSSFRow row0 = sheet.getRow(0);
        for (int i = 1; i <= lastRowNum; ++i) {
            XSSFRow row1 = sheet.getRow(i);
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            for (int j = 0; j < row0.getLastCellNum(); ++j) {
                try {
                    m.put(row0.getCell(j).getStringCellValue(), row1.getCell(j) == null ? "" : row1.getCell(j).getStringCellValue());
                    continue;
                }
                catch (IllegalStateException ill) {
                    m.put(row0.getCell(j).getStringCellValue(), row1.getCell(j).getNumericCellValue() + "");
                }
            }
            list.add(m);
        }
        workbook.close();
        return list;
    }

    public static void writeToXlsx(List<LinkedHashMap<String, String>> list, String path) throws FileNotFoundException, IOException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        XSSFRow row0 = sheet.createRow(0);
        int columnIndex = 0;
        for (String string : list.get(0).keySet()) {
            row0.createCell(columnIndex++).setCellValue(string);
        }
        int rowindex = 1;
        for (LinkedHashMap<String, String> linkedHashMap : list) {
            XSSFRow row1 = sheet.createRow(rowindex++);
            int i = 0;
            for (String s : linkedHashMap.keySet()) {
                row1.createCell(i++).setCellValue(linkedHashMap.get(s));
            }
        }
        File file = new File(path);
        workbook.write((OutputStream)new FileOutputStream(file));
        workbook.close();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        List<LinkedHashMap<String, String>> columns = PoiXlsxUtil.getColumns("d:/tmp/a.xlsx");
        System.out.println(columns.get(1).get("a"));
    }
}

