/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;

public class RobotUtil {
    private static Robot robot;
    static Dimension d;

    public static BufferedImage screenshots() {
        return RobotUtil.getRobot().createScreenCapture(new Rectangle(0, 0, (int)d.getWidth(), (int)d.getHeight()));
    }

    public static BufferedImage screenshots(int x, int y, int width, int height) {
        return RobotUtil.getRobot().createScreenCapture(new Rectangle(x, y, width, height));
    }

    public static void mouseMove(int x, int y) {
        RobotUtil.getRobot().mouseMove(x, y);
    }

    public static void mouseClick() {
        RobotUtil.getRobot().mousePress(1024);
        RobotUtil.getRobot().mouseRelease(1024);
    }

    public static void moveClick(int x, int y) {
        RobotUtil.mouseMove(x, y);
        RobotUtil.mouseClick();
    }

    public static void moveDbClick(int x, int y) {
        RobotUtil.mouseMove(x, y);
        RobotUtil.mouseClick();
        RobotUtil.mouseClick();
    }

    public static void moveRightClick(int x, int y) {
        RobotUtil.mouseMove(x, y);
        RobotUtil.getRobot().mousePress(4096);
        RobotUtil.getRobot().mouseRelease(4096);
    }

    public static void mouseDrag(int x1, int y1, int x2, int y2) {
        RobotUtil.mouseMove(x1, y1);
        RobotUtil.getRobot().mousePress(1024);
        RobotUtil.mouseMove(x2, y2);
        RobotUtil.getRobot().mouseRelease(1024);
    }

    public static void press(int keycode) {
        RobotUtil.getRobot().keyPress(keycode);
        RobotUtil.getRobot().keyRelease(keycode);
    }

    public static void pressWithAlt(int keycode) {
        RobotUtil.getRobot().keyPress(18);
        RobotUtil.getRobot().keyPress(keycode);
        RobotUtil.getRobot().keyRelease(keycode);
        RobotUtil.getRobot().keyRelease(18);
    }

    public static void pressWithShift(int keycode) {
        RobotUtil.getRobot().keyPress(16);
        RobotUtil.getRobot().keyPress(keycode);
        RobotUtil.getRobot().keyRelease(keycode);
        RobotUtil.getRobot().keyRelease(16);
    }

    public static void pressWithCtrl(int keycode) {
        RobotUtil.getRobot().keyPress(17);
        RobotUtil.getRobot().keyPress(keycode);
        RobotUtil.getRobot().keyRelease(keycode);
        RobotUtil.getRobot().keyRelease(17);
    }

    public static void mouseWheel(int times) {
        for (int i = 0; i < times; ++i) {
            RobotUtil.getRobot().mouseWheel(1);
        }
    }

    public static void press(int ... keycodes) {
        for (int i : keycodes) {
            RobotUtil.press(i);
        }
    }

    public static void press(String s) {
        for (char c : s.toCharArray()) {
            if (Character.isUpperCase(c)) {
                RobotUtil.pressWithShift(KeyEvent.getExtendedKeyCodeForChar(c));
                continue;
            }
            RobotUtil.getRobot().keyPress(KeyEvent.getExtendedKeyCodeForChar(c));
        }
    }

    public static void inputString(String str) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(str), null);
        robot.keyPress(17);
        robot.keyPress(86);
        robot.keyRelease(86);
        robot.keyRelease(17);
    }

    public static Robot getRobot() {
        if (robot == null) {
            try {
                robot = new Robot();
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
        }
        return robot;
    }

    static {
        d = Toolkit.getDefaultToolkit().getScreenSize();
    }
}

