/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StringUtil {
    public static final String lineSeparator = System.getProperty("line.separator", "\n");

    public static String firstCharLower(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static String firstCharUpper(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String trimUnderlinedFirstCharUpper(String s) {
        if (s.indexOf("_") != -1) {
            String[] ss = s.split("_");
            StringBuilder sb = new StringBuilder(ss[0]);
            if (ss.length > 1) {
                for (int i = 1; i < ss.length; ++i) {
                    sb.append(StringUtil.firstCharUpper(ss[i]));
                }
            }
            return sb.toString();
        }
        return s;
    }

    public static boolean isBlank(Object ... objects) {
        Boolean result = false;
        for (Object object : objects) {
            if (object != null && !"".equals(object.toString().trim()) && !"null".equals(object.toString().trim()) && !"[null]".equals(object.toString().trim()) && !"[]".equals(object.toString().trim())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String mapToGet(Map<? extends Object, ? extends Object> map) {
        String result = "";
        if (map == null || map.size() == 0) {
            return result;
        }
        Set<? extends Object> keys = map.keySet();
        for (Object object : keys) {
            result = result + (String)object + "=" + (String)map.get(object) + "&";
        }
        return StringUtil.isBlank(result) ? result : result.substring(0, result.length() - 1);
    }

    public static Map<String, ? extends Object> getToMap(String args) {
        if (StringUtil.isBlank(args)) {
            return null;
        }
        if ((args = args.trim()).startsWith("?")) {
            args = args.substring(1, args.length());
        }
        String[] argsArray = args.split("&");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String ag : argsArray) {
            if (StringUtil.isBlank(ag) || ag.indexOf("=") <= 0) continue;
            String[] keyValue = ag.split("=");
            String key = keyValue[0];
            String value = "";
            for (int i = 1; i < keyValue.length; ++i) {
                value = value + keyValue[i] + "=";
            }
            value = value.length() > 0 ? value.substring(0, value.length() - 1) : value;
            result.put(key, value);
        }
        return result;
    }

    public static String toUnicode(String str) {
        String[] as = new String[str.length()];
        String s1 = "";
        for (int i = 0; i < str.length(); ++i) {
            as[i] = Integer.toHexString(str.charAt(i) & 0xFFFF);
            s1 = s1 + "\\u" + as[i];
        }
        return s1;
    }

    public static String getDoubleTOString(Double str) {
        String money = str.toString();
        try {
            Double.parseDouble(money);
        }
        catch (Exception e) {
            BigDecimal bDecimal = new BigDecimal(str);
            money = bDecimal.toPlainString();
        }
        return money;
    }

    public static String strToUrlcode(String value, String encode) {
        try {
            value = URLEncoder.encode(value, encode == null ? "utf-8" : encode);
            return value;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String urlcodeToStr(String value, String encode) {
        try {
            value = URLDecoder.decode(value, encode == null ? "utf-8" : encode);
            return value;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

