/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit;

import com.di.toolkit.ClassUtil;
import com.di.toolkit.Str;
import com.di.toolkit.StringUtil;
import com.di.toolkit.data.annotation.Alias;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XmlUtil {
    public static String start = "<![CDATA[";
    public static String end = "]]>";

    public static <T> String toXml(T o) {
        String n = StringUtil.firstCharLower(o.getClass().getSimpleName());
        if (o.getClass().isAnnotationPresent(Alias.class)) {
            if (!o.getClass().getAnnotation(Alias.class).xml().isEmpty()) {
                n = o.getClass().getAnnotation(Alias.class).xml();
            } else if (!o.getClass().getAnnotation(Alias.class).value().isEmpty()) {
                n = o.getClass().getAnnotation(Alias.class).value();
            }
        }
        Str str = new Str();
        str.add("<").add(n).add(">");
        if (o.getClass() == Byte.TYPE || o.getClass() == Short.TYPE || o.getClass() == Integer.TYPE || o.getClass() == Long.TYPE || o.getClass() == Double.TYPE || o.getClass() == Float.TYPE || o.getClass() == Byte.class || o.getClass() == Short.class || o.getClass() == Integer.class || o.getClass() == Long.class || o.getClass() == Double.class || o.getClass() == Float.class || o.getClass() == Boolean.TYPE || o.getClass() == Boolean.class || o.getClass() == String.class || o.getClass() == Character.class) {
            str.add(o).add("</").add(n).add(">");
            return str.toString();
        }
        if (o.getClass().isArray()) {
            str.add("<").add(n).add(">");
            List os = (List)o;
            for (Object o0 : os) {
                str.add(XmlUtil.toXml(o0));
            }
            str.add("</").add(n).add(">");
        } else if (o.getClass() == Map.class || o.getClass() == HashMap.class) {
            Map m0 = (Map)o;
            for (Object key : m0.keySet()) {
                str.add(XmlUtil.toXml(m0.get(key)));
            }
        } else if (o instanceof Object) {
            try {
                for (Field f : o.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    if (f.get(o) == null) continue;
                    String n0 = f.getName();
                    if (n0.equals("attributes")) {
                        Object attr = f.get(o);
                        Str str1 = new Str();
                        for (Field ff : attr.getClass().getDeclaredFields()) {
                            ff.setAccessible(true);
                            String nn = ff.getName();
                            if (ff.isAnnotationPresent(Alias.class)) {
                                if (!ff.getAnnotation(Alias.class).xml().isEmpty()) {
                                    nn = ff.getAnnotation(Alias.class).xml();
                                } else if (!ff.getAnnotation(Alias.class).value().isEmpty()) {
                                    nn = ff.getAnnotation(Alias.class).value();
                                }
                            }
                            str1.add(nn).add("=\"").add(ff.get(attr)).add("\" ");
                        }
                        str.replaceFirst("<" + n + ">", "<" + n + " " + str1.deleteLastChar().toString() + ">");
                        continue;
                    }
                    if (f.isAnnotationPresent(Alias.class)) {
                        if (!f.getAnnotation(Alias.class).xml().isEmpty()) {
                            n0 = f.getAnnotation(Alias.class).xml();
                        } else if (!f.getAnnotation(Alias.class).value().isEmpty()) {
                            n0 = f.getAnnotation(Alias.class).value();
                        }
                    }
                    if (f.getType() == Byte.TYPE || f.getType() == Short.TYPE || f.getType() == Integer.TYPE || f.getType() == Long.TYPE || f.getType() == Double.TYPE || f.getType() == Float.TYPE || f.getType() == Byte.class || f.getType() == Short.class || f.getType() == Integer.class || f.getType() == Long.class || f.getType() == Double.class || f.getType() == Float.class || f.getType() == Boolean.TYPE || f.getType() == Boolean.class || f.getType() == String.class || f.getType() == Character.class) {
                        str.add("<").add(n0).add(">").add(f.get(o)).add("</").add(n0).add(">");
                        continue;
                    }
                    if (f.getType() == List.class || f.getType() == ArrayList.class) {
                        str.add("<").add(n0).add(">");
                        List os = (List)f.get(o);
                        for (Object o0 : os) {
                            str.add(XmlUtil.toXml(o0));
                        }
                        str.add("</").add(n0).add(">");
                        continue;
                    }
                    if (f.getType() == Map.class || f.getType() == HashMap.class) {
                        Map m0 = (Map)f.get(o);
                        for (Object key : m0.keySet()) {
                            str.add(m0.get(key));
                        }
                        continue;
                    }
                    if (!(f.getType() instanceof Object)) continue;
                    str.add(XmlUtil.toXml(f.get(o)));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        str.add("</").add(n).add(">");
        return str.toString();
    }

    public static <T> T toObject(String xml, Class<T> cl) {
        Map<String, Object> o = null;
        if (cl == Collection.class || cl == List.class || cl == ArrayList.class) {
            List<Object> l = XmlUtil.toList(xml);
            return (T)l;
        }
        if (cl == Map.class || cl == HashMap.class) {
            Map<String, Object> m;
            o = m = XmlUtil.toMap(xml);
        } else {
            try {
                Map<String, Object> m = XmlUtil.toMap(xml);
                o = cl.newInstance();
                XmlUtil.set(m, o);
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return (T)o;
    }

    private static <T> void set(Map<String, Object> m, T o) {
        ClassUtil.setObjectFieldsValue(m, o);
    }

    public static Map<String, Object> toMap(String xml) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("attributes", XmlUtil.getAttributes(xml));
        m.put("element name", XmlUtil.getWrapperName(xml));
        if (XmlUtil.getWrapperValue(xml).indexOf("<") == -1) {
            m.put(XmlUtil.getWrapperName(xml), XmlUtil.getWrapperValue(xml));
            return m;
        }
        xml = XmlUtil.getWrapperValue(xml);
        List<String> split = XmlUtil.split(xml);
        for (String s : split) {
            String value = XmlUtil.getWrapperValue(s);
            String name = XmlUtil.getWrapperName(s);
            if (!value.startsWith("<") && !value.startsWith(start)) {
                m.put(name, value);
                continue;
            }
            if (value.startsWith(start)) {
                m.put(name, XmlUtil.replaceEscape(value));
                continue;
            }
            if (value.startsWith("<") && !XmlUtil.isList(value)) {
                m.put(name, XmlUtil.toMap(s));
                continue;
            }
            if (!XmlUtil.isList(value)) continue;
            m.put(name, XmlUtil.toList(value));
        }
        return m;
    }

    private static boolean isList(String xml) {
        String n1 = XmlUtil.getWrapperName(xml);
        if (xml.indexOf("</" + n1 + ">") == -1) {
            return false;
        }
        return xml.substring(xml.indexOf("</" + n1 + ">")).indexOf("<" + n1 + ">") > -1;
    }

    private static List<Object> toList(String xml) {
        ArrayList<Object> ls = new ArrayList<Object>();
        for (String s : XmlUtil.split(xml)) {
            if (XmlUtil.isList(s)) {
                ls.add(XmlUtil.toList(s));
                continue;
            }
            ls.add(XmlUtil.toMap(s));
        }
        return ls;
    }

    private static Map<String, String> getAttributes(String xml) {
        String s = xml.substring(xml.indexOf("<") + 1, xml.indexOf(">"));
        String[] ss = s.split(" ");
        if (ss.length == 1) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 1; i < ss.length; ++i) {
            String s0 = ss[i].trim();
            if (s0.isEmpty()) continue;
            m.put(s0.split("=")[0], XmlUtil.delQuot(s0.split("=")[1]));
        }
        return m;
    }

    private static String delQuot(String s) {
        return s.substring(s.indexOf(34) + 1, s.lastIndexOf(34));
    }

    private static String getWrapperName(String xml) {
        return xml.substring(xml.indexOf("<") > -1 ? xml.indexOf("<") + 1 : 0, xml.indexOf(">") > -1 ? xml.indexOf(">") : xml.length()).split(" ")[0];
    }

    private static String getWrapperValue(String xml) {
        return xml.substring(xml.indexOf(">") > -1 ? xml.indexOf(">") + 1 : 0, xml.lastIndexOf("<") > -1 ? xml.lastIndexOf("<") : xml.length());
    }

    private static String replaceEscape(String xml) {
        return xml.substring(xml.indexOf(start) + 9, xml.lastIndexOf(end));
    }

    private static List<String> split(String xml) {
        int i = 0;
        int left = 0;
        int right = 0;
        int close = 0;
        char[] cs = xml.toCharArray();
        ArrayList<Integer> ls = new ArrayList<Integer>();
        block4: while (i < cs.length) {
            switch (cs[i]) {
                case '<': {
                    if (i == 0 || xml.indexOf(start, i - 1) != i) {
                        if (cs[i + 1] != '/') {
                            ++left;
                            break;
                        }
                        ++close;
                        break;
                    }
                    if (xml.indexOf(start, i - 1) != i) break;
                    i = xml.indexOf(end, i) + 3;
                    continue block4;
                }
                case '>': {
                    if (cs[i - 1] != ']' && cs[i - 2] != ']') {
                        ++right;
                    }
                    if (left + close != right || left != close) break;
                    ls.add(i);
                    break;
                }
            }
            ++i;
        }
        ArrayList<String> ss = new ArrayList<String>();
        if (ls.size() == 0) {
            ss.add(xml);
        } else if (ls.size() == 1) {
            ss.add(xml.substring(0, (Integer)ls.get(0)));
            ss.add(xml.substring((Integer)ls.get(0) + 1));
        } else if (ls.size() > 1) {
            ss.add(xml.substring(0, (Integer)ls.get(0) + 1));
            for (int j = 0; j < ls.size() - 1; ++j) {
                ss.add(xml.substring((Integer)ls.get(j) + 1, (Integer)ls.get(j + 1) + 1));
            }
        }
        return ss;
    }

    public static enum XmlEscape {
        AND('&', "a"),
        LESS('<', "&lt;"),
        GREAT('>', "&gt;"),
        QUOT('\"', "&quot;"),
        APOS('\'', "&apos;");

        private char ch;
        private String value;

        private XmlEscape(char ch, String value) {
            this.value = value;
            this.ch = ch;
        }

        public static String escape(char c) {
            for (XmlEscape xe : XmlEscape.values()) {
                if (xe.ch != c) continue;
                return xe.value;
            }
            return null;
        }

        public static char unEscape(String s) {
            for (XmlEscape xe : XmlEscape.values()) {
                if (!xe.value.equals(s)) continue;
                return xe.ch;
            }
            return ' ';
        }
    }
}

