/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit.csv;

import com.di.toolkit.ClassUtil;
import com.di.toolkit.StringUtil;
import com.di.toolkit.data.annotation.DataColumn;
import com.di.toolkit.data.annotation.DateFormat;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class CsvMapper {
    public static <T> String pojoToCsvWithoutHead(T t) {
        StringBuilder s = new StringBuilder();
        for (Field f : t.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(DataColumn.class)) continue;
            if (f.isAnnotationPresent(DateFormat.class)) {
                s.append(new SimpleDateFormat(f.getAnnotation(DateFormat.class).pattern()).format(ClassUtil.getFieldValueByGetMethod(f, t))).append(",");
                continue;
            }
            if (f.isAnnotationPresent(com.di.toolkit.data.annotation.DecimalFormat.class)) {
                if (f.getType() == Long.class || f.getType() == Long.TYPE) {
                    s.append(new DecimalFormat(f.getAnnotation(com.di.toolkit.data.annotation.DecimalFormat.class).pattern()).format(new Date((Long)ClassUtil.getFieldValueByGetMethod(f, t)))).append(",");
                    continue;
                }
                s.append(new DecimalFormat(f.getAnnotation(com.di.toolkit.data.annotation.DecimalFormat.class).pattern()).format(ClassUtil.getFieldValueByGetMethod(f, t))).append(",");
                continue;
            }
            s.append(ClassUtil.getFieldValueByGetMethod(f, t)).append(",");
        }
        return s.toString();
    }

    public static <T> String getPojoToCsvHead(T t) {
        StringBuilder s = new StringBuilder();
        for (Field f : t.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(DataColumn.class)) continue;
            if (f.getAnnotation(DataColumn.class).name().isEmpty()) {
                s.append(f.getName()).append(",");
                continue;
            }
            s.append(f.getAnnotation(DataColumn.class).name()).append(",");
        }
        return s.toString();
    }

    public static <T> String pojosToCsvWithoutHead(List<T> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        for (T t : list) {
            s.append(CsvMapper.pojoToCsvWithoutHead(t));
            s.append(StringUtil.lineSeparator);
        }
        return s.toString();
    }

    public static <T> String pojosToCsvWithHead(List<T> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(CsvMapper.getPojoToCsvHead(list.get(0)));
        s.append(StringUtil.lineSeparator);
        for (T t : list) {
            s.append(CsvMapper.pojoToCsvWithoutHead(t));
            s.append(StringUtil.lineSeparator);
        }
        return s.toString();
    }
}

