/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit.img;

import com.di.toolkit.img.ImageLocation;
import com.di.toolkit.img.Pixel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;

public class BufferedImageUtil {
    public static final int BLACK_RGB = -16777216;
    public static final int WHITE_RGB = -1;

    public static Pixel getPixel(BufferedImage img, int x, int y) {
        try {
            Object data = img.getRaster().getDataElements(x, y, null);
            Pixel p = new Pixel(x, y);
            p.setRed(img.getColorModel().getRed(data));
            p.setGreen(img.getColorModel().getGreen(data));
            p.setBlue(img.getColorModel().getBlue(data));
            return p;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static void setColor(BufferedImage img, int x, int y, int red, int green, int blue) {
        int rgb = (red * 256 + green) * 256 + blue;
        if (rgb > 0x800000) {
            rgb -= 0x1000000;
        }
        img.setRGB(x, y, rgb);
    }

    public static BufferedImage binary(BufferedImage img) {
        BufferedImage bi = new BufferedImage(img.getWidth(), img.getHeight(), 12);
        for (int i = 0; i < img.getWidth(); ++i) {
            for (int j = 0; j < img.getHeight(); ++j) {
                int rgb = img.getRGB(i, j);
                bi.setRGB(i, j, rgb);
            }
        }
        return bi;
    }

    public static BufferedImage gray(BufferedImage img) {
        BufferedImage bi = new BufferedImage(img.getWidth(), img.getHeight(), 10);
        for (int i = 0; i < img.getWidth(); ++i) {
            for (int j = 0; j < img.getHeight(); ++j) {
                int rgb = img.getRGB(i, j);
                bi.setRGB(i, j, rgb);
            }
        }
        return bi;
    }

    public static BufferedImage read(String path) {
        try {
            return ImageIO.read(new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void save(BufferedImage img, String path) {
        try {
            ImageIO.write((RenderedImage)img, path.substring(path.lastIndexOf(".") + 1), new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BufferedImage binary(BufferedImage img, int range) {
        BufferedImage bi = new BufferedImage(img.getWidth(), img.getHeight(), 12);
        for (int i = 0; i < img.getWidth(); ++i) {
            for (int j = 0; j < img.getHeight(); ++j) {
                Pixel p = BufferedImageUtil.getPixel(img, i, j);
                if (255 - p.getRed() <= range && 255 - p.getGreen() <= range && 255 - p.getBlue() <= range) {
                    bi.setRGB(i, j, -1);
                    continue;
                }
                bi.setRGB(i, j, -16777216);
            }
        }
        return bi;
    }

    public static BufferedImage readByRelativePath(String relativePath) {
        try {
            String pathname = Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath();
            pathname = pathname.replaceFirst("test-classes", "classes");
            return ImageIO.read(new File(pathname + relativePath));
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isSimilar(Pixel p1, Pixel p2, int range) {
        return Math.abs(p1.getRed() - p2.getRed()) < range && Math.abs(p1.getRed() - p2.getRed()) < range && Math.abs(p1.getRed() - p2.getRed()) < range;
    }

    public static BufferedImage cutImage(BufferedImage img, int x, int y, int width, int height) {
        int h;
        int w = img.getWidth() >= x + width ? width : img.getWidth() - x;
        int n = h = img.getHeight() >= y + height ? height : img.getHeight() - y;
        if (x < img.getWidth() && y < img.getHeight()) {
            BufferedImage b = new BufferedImage(w, h, 1);
            for (int x0 = x; x0 < w + x; ++x0) {
                for (int y0 = y; y0 < h + y; ++y0) {
                    Pixel p = BufferedImageUtil.getPixel(img, x0, y0);
                    BufferedImageUtil.setColor(b, x0 - x, y0 - y, p.getRed(), p.getGreen(), p.getBlue());
                }
            }
            return b;
        }
        return img;
    }

    public static boolean isContains(BufferedImage small, BufferedImage large) {
        int[] locate = ImageLocation.locate(small, large);
        return locate[0] < locate[2] && locate[1] < locate[3];
    }
}

