/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit.img;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageFind {
    BufferedImage screenShotImage;
    BufferedImage keyImage;
    int scrShotImgWidth;
    int scrShotImgHeight;
    int keyImgWidth;
    int keyImgHeight;
    int[][] screenShotImageRGBData;
    int[][] keyImageRGBData;
    int[][][] findImgData;

    public ImageFind() {
    }

    public ImageFind(String keyImagePath) {
        this.screenShotImage = this.getFullScreenShot();
        this.keyImage = this.getBfImageFromPath(keyImagePath);
        this.screenShotImageRGBData = this.getImageGRB(this.screenShotImage);
        this.keyImageRGBData = this.getImageGRB(this.keyImage);
        this.scrShotImgWidth = this.screenShotImage.getWidth();
        this.scrShotImgHeight = this.screenShotImage.getHeight();
        this.keyImgWidth = this.keyImage.getWidth();
        this.keyImgHeight = this.keyImage.getHeight();
        this.findImage();
    }

    public ImageFind(BufferedImage screenShotImage, BufferedImage keyImage) {
        this.keyImage = keyImage;
        this.screenShotImage = screenShotImage;
        this.screenShotImageRGBData = this.getImageGRB(screenShotImage);
        this.keyImageRGBData = this.getImageGRB(keyImage);
        this.scrShotImgWidth = screenShotImage.getWidth();
        this.scrShotImgHeight = screenShotImage.getHeight();
        this.keyImgWidth = keyImage.getWidth();
        this.keyImgHeight = keyImage.getHeight();
        this.findImage();
    }

    public BufferedImage getFullScreenShot() {
        BufferedImage bfImage = null;
        int width = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int height = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        try {
            Robot robot = new Robot();
            bfImage = robot.createScreenCapture(new Rectangle(0, 0, width, height));
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        return bfImage;
    }

    public BufferedImage getBfImageFromPath(String keyImagePath) {
        BufferedImage bfImage = null;
        try {
            bfImage = ImageIO.read(new File(keyImagePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bfImage;
    }

    public int[][] getImageGRB(BufferedImage bfImage) {
        int width = bfImage.getWidth();
        int height = bfImage.getHeight();
        int[][] result = new int[height][width];
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                result[h][w] = bfImage.getRGB(w, h) & 0xFFFFFF;
            }
        }
        return result;
    }

    public void findImage() {
        this.findImgData = new int[this.keyImgHeight][this.keyImgWidth][2];
        for (int y = 0; y < this.scrShotImgHeight - this.keyImgHeight; ++y) {
            for (int x = 0; x < this.scrShotImgWidth - this.keyImgWidth; ++x) {
                boolean isFinded;
                if ((this.keyImageRGBData[0][0] ^ this.screenShotImageRGBData[y][x]) != 0 || (this.keyImageRGBData[0][this.keyImgWidth - 1] ^ this.screenShotImageRGBData[y][x + this.keyImgWidth - 1]) != 0 || (this.keyImageRGBData[this.keyImgHeight - 1][this.keyImgWidth - 1] ^ this.screenShotImageRGBData[y + this.keyImgHeight - 1][x + this.keyImgWidth - 1]) != 0 || (this.keyImageRGBData[this.keyImgHeight - 1][0] ^ this.screenShotImageRGBData[y + this.keyImgHeight - 1][x]) != 0 || !(isFinded = this.isMatchAll(y, x))) continue;
                for (int h = 0; h < this.keyImgHeight; ++h) {
                    for (int w = 0; w < this.keyImgWidth; ++w) {
                        this.findImgData[h][w][0] = y + h;
                        this.findImgData[h][w][1] = x + w;
                    }
                }
                return;
            }
        }
    }

    public boolean isMatchAll(int y, int x) {
        int biggerY = 0;
        int biggerX = 0;
        int xor = 0;
        for (int smallerY = 0; smallerY < this.keyImgHeight; ++smallerY) {
            biggerY = y + smallerY;
            for (int smallerX = 0; smallerX < this.keyImgWidth; ++smallerX) {
                biggerX = x + smallerX;
                if (biggerY >= this.scrShotImgHeight || biggerX >= this.scrShotImgWidth) {
                    return false;
                }
                xor = this.keyImageRGBData[smallerY][smallerX] ^ this.screenShotImageRGBData[biggerY][biggerX];
                if (xor == 0) continue;
                return false;
            }
            biggerX = x;
        }
        return true;
    }

    public void printFindData() {
        System.out.println("(" + this.findImgData[0][0][1] + "," + this.findImgData[0][0][0] + ")->(" + this.findImgData[this.keyImgHeight - 1][this.keyImgWidth - 1][1] + "," + this.findImgData[this.keyImgHeight - 1][this.keyImgWidth - 1][0] + ")");
    }

    public boolean contains() {
        return this.findImgData[this.keyImgHeight - 1][this.keyImgWidth - 1][1] > this.findImgData[0][0][1] && this.findImgData[this.keyImgHeight - 1][this.keyImgWidth - 1][0] > this.findImgData[0][0][0];
    }
}

