/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit.img;

import com.di.toolkit.FileUtil;
import com.di.toolkit.Str;
import com.di.toolkit.img.BufferedImageUtil;
import com.di.toolkit.img.ImageTrain;
import com.di.toolkit.img.Pixel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ShapeRecognition {
    public static int range = 60;
    private static List<SimpleShape> shapes;

    public static void train(String path) {
        File f = new File(path);
        if (!f.isDirectory() || !f.exists()) {
            throw new RuntimeException("");
        }
        String[] files = f.list();
        ArrayList<SimpleShape> shapes = new ArrayList<SimpleShape>();
        for (String n : files) {
            String pa = f.getAbsolutePath() + File.separator + n;
            if (new File(pa).isDirectory()) continue;
            String name = n.substring(0, n.lastIndexOf("."));
            if (!pa.endsWith("jpg") && !pa.endsWith("bmp") && !pa.endsWith("png") && !pa.endsWith("tif")) continue;
            BufferedImage img = BufferedImageUtil.read(pa);
            Pixel background = BufferedImageUtil.getPixel(img, 0, 0);
            int count = 0;
            int minX = 0;
            int minY = 0;
            int maxX = 0;
            int maxY = 0;
            ArrayList<SimplePoint> ps = new ArrayList<SimplePoint>();
            for (int x = 0; x < img.getWidth(); ++x) {
                for (int y = 0; y < img.getHeight(); ++y) {
                    Pixel pixel = BufferedImageUtil.getPixel(img, x, y);
                    if (BufferedImageUtil.isSimilar(background, pixel, range)) continue;
                    ++count;
                    if (minX == 0 || pixel.getX() < minX) {
                        minX = pixel.getX();
                    }
                    if (minY == 0 || pixel.getY() < minY) {
                        minY = pixel.getY();
                    }
                    if (maxX == 0 || maxX < pixel.getX()) {
                        maxX = pixel.getX();
                    }
                    if (maxY == 0 || maxY < pixel.getY()) {
                        maxY = pixel.getY();
                    }
                    SimplePoint sp = new SimplePoint();
                    sp.setX(x);
                    sp.setY(y);
                    ps.add(sp);
                }
            }
            ArrayList<SimplePoint> temps = new ArrayList<SimplePoint>();
            for (SimplePoint simplePoint : ps) {
                simplePoint.setX(simplePoint.getX() - minX);
                simplePoint.setY(simplePoint.getY() - minY);
                temps.add(simplePoint);
            }
            SimpleShape ss = new SimpleShape();
            ss.setHeight(maxY - minY);
            ss.setWidth(maxX - minX);
            ss.setName(name);
            ss.setCount(count);
            ss.setPoints(temps);
            shapes.add(ss);
            System.out.println(name + " -> " + pa + " " + count);
        }
        FileUtil.writeToFile(path + "train.sd", ShapeRecognition.serilize(shapes));
    }

    public static String parseBest(String dataPath, BufferedImage img) {
        String content = FileUtil.readAsString(dataPath, "GBK");
        List<SimpleShape> td = ShapeRecognition.deserilize(content);
        HashMap<String, Double> map = new HashMap<String, Double>();
        Pixel background = BufferedImageUtil.getPixel(img, 0, 0);
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                Pixel p = BufferedImageUtil.getPixel(img, x, y);
                if (BufferedImageUtil.isSimilar(p, background, ImageTrain.range)) continue;
                for (SimpleShape c : td) {
                    SimplePoint p0 = c.getPoints().get(0);
                    SimplePoint p1 = c.getPoints().get(1);
                    Pixel $p = BufferedImageUtil.getPixel(img, x + (p1.getX() - p0.getX()), y + (p1.getY() - p0.getY()));
                    if (BufferedImageUtil.isSimilar(p, $p, range)) continue;
                    int count = 1;
                    for (int i = 1; i < c.getPoints().size(); ++i) {
                        Pixel p_;
                        SimplePoint pi = c.getPoints().get(i);
                        int x_ = pi.getX() - p0.getX();
                        int y_ = pi.getY() - p0.getY();
                        if (x + x_ < img.getWidth() && y + y_ < img.getHeight() && (p_ = BufferedImageUtil.getPixel(img, x + x_, y + y_)) != null && !BufferedImageUtil.isSimilar(background, p_, range)) {
                            ++count;
                        }
                        double d = (double)count / (double)c.getCount();
                        if (map.get(c.getName()) != null && (map.get(c.getName()) == null || !((Double)map.get(c.getName()) < d))) continue;
                        map.put(c.getName(), d);
                    }
                }
            }
        }
        double max = 0.0;
        String key = " ";
        for (String s : map.keySet()) {
            if (!((Double)map.get(s) > max)) continue;
            max = (Double)map.get(s);
            key = s;
        }
        if (key.indexOf("L") != -1 && map.get("U") != null && (Double)map.get("U") > 0.9) {
            if (map.get("D") != null && (Double)map.get("D") > 0.9) {
                return "D";
            }
            if (map.get("U") != null && (Double)map.get("U") > 0.9) {
                return "U";
            }
        } else {
            System.out.println("best match is " + key + " ratio is " + max * 100.0 + "%");
        }
        return key.substring(0, 1);
    }

    private static String serilize(List<SimpleShape> sh) {
        Str s = new Str();
        for (SimpleShape ss : shapes) {
            s.add(ss.getName()).add(" ").add(ss.getWidth()).add(" ").add(ss.getHeight()).add(" ").add(ss.getCount()).add(":");
            for (SimplePoint p : ss.getPoints()) {
                s.add(p.getX()).add(",").add(p.getY()).add(" ");
            }
            s.add(";");
        }
        return s.toString();
    }

    private static List<SimpleShape> deserilize(String res) {
        ArrayList<SimpleShape> tmps = new ArrayList<SimpleShape>();
        for (String s : res.split(";")) {
            if ((s = s.trim()).isEmpty()) continue;
            SimpleShape ss = new SimpleShape();
            String s0 = s.split(":")[0];
            ss.setName(s0.split(" ")[0]);
            ss.setWidth(Integer.valueOf(s0.split(" ")[1]));
            ss.setHeight(Integer.valueOf(s0.split(" ")[2]));
            ss.setCount(Integer.valueOf(s0.split(" ")[3]));
            String s1 = s.split(":")[1];
            ArrayList<SimplePoint> sps = new ArrayList<SimplePoint>();
            for (String s_ : s1.split(" ")) {
                SimplePoint sp = new SimplePoint();
                sp.setX(Integer.valueOf(s_.split(",")[0]));
                sp.setY(Integer.valueOf(s_.split(",")[1]));
                sps.add(sp);
            }
            ss.setPoints(sps);
            tmps.add(ss);
        }
        return tmps;
    }

    static class SimpleShape {
        private String name;
        private int width;
        private int height;
        private int count;
        List<SimplePoint> points;

        SimpleShape() {
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public List<SimplePoint> getPoints() {
            return this.points;
        }

        public void setPoints(List<SimplePoint> points) {
            this.points = points;
        }
    }

    static class SimplePoint {
        private int x;
        private int y;

        SimplePoint() {
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }
    }
}

