/*
 * Decompiled with CFR 0.152.
 */
package com.di.toolkit.img;

import com.di.toolkit.img.BufferedImageUtil;
import com.di.toolkit.img.Pixel;
import com.di.toolkit.img.RgbUtil;
import java.awt.image.BufferedImage;

public class TwoColorCompare {
    public static Result compare(BufferedImage img, int range) {
        Result r = new Result();
        r.setWidth(img.getWidth());
        int y = img.getHeight() / 2;
        int count = 0;
        for (int i = 0; i < r.getWidth(); ++i) {
            int[] b;
            int[] a = RgbUtil.srgbToRgb(img.getRGB(i, y));
            if (Math.abs(a[0] - (b = RgbUtil.srgbToRgb(img.getRGB(0, y)))[0]) >= range || Math.abs(a[1] - b[1]) >= range || Math.abs(a[2] - b[2]) >= range) continue;
            ++count;
        }
        r.setLeft(count);
        r.setRight(r.getWidth() - count);
        r.setLeftPercent((float)count / (float)r.getWidth());
        r.setRightPercent(1.0f - r.getLeftPercent());
        return r;
    }

    public static Result compare_(BufferedImage img, int range) {
        Result r = new Result();
        r.setWidth(img.getWidth());
        int y = img.getHeight() / 2;
        int count = 0;
        for (int i = 0; i < r.getWidth(); ++i) {
            Pixel p0 = BufferedImageUtil.getPixel(img, 0, y);
            Pixel p1 = BufferedImageUtil.getPixel(img, i, y);
            if (Math.abs(p1.getRed() - p0.getRed()) >= range || Math.abs(p1.getGreen() - p0.getGreen()) >= range || Math.abs(p1.getBlue() - p0.getBlue()) >= range) continue;
            ++count;
        }
        r.setLeft(count);
        r.setRight(r.getWidth() - count);
        r.setLeftPercent((float)count / (float)r.getWidth());
        r.setRightPercent(1.0f - r.getLeftPercent());
        return r;
    }

    public static Result compare(BufferedImage img) {
        return TwoColorCompare.compare(img, 5);
    }

    public static class Result {
        int width;
        int left;
        int right;
        float leftPercent;
        float rightPercent;

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getLeft() {
            return this.left;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public int getRight() {
            return this.right;
        }

        public void setRight(int right) {
            this.right = right;
        }

        public float getLeftPercent() {
            return this.leftPercent;
        }

        public void setLeftPercent(float leftPercent) {
            this.leftPercent = leftPercent;
        }

        public float getRightPercent() {
            return this.rightPercent;
        }

        public void setRightPercent(float rightPercent) {
            this.rightPercent = rightPercent;
        }
    }
}

