/*
 * Decompiled with CFR 0.152.
 */
package com.github.dmgcodevil.jmspy.agent;

import com.github.dmgcodevil.jmspy.agent.AgentConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JmspyAgentConfig {
    private static final String INSTRUMENTED_RESOURCES_PROP = "instrumentedResources";
    private static final String EMPTY = "";
    private static final String CLASS_SUFFIX = "/class";
    private static final String JMSPY_AGENT_PROPERTIES = "jmspy_agent.properties";
    private Set<String> instrumentedPackages = Collections.emptySet();
    private Set<String> instrumentedClasses = Collections.emptySet();

    public JmspyAgentConfig(String agentArgs) {
        if (StringUtils.isNotBlank((CharSequence)agentArgs)) {
            this.init(agentArgs);
        } else {
            agentArgs = this.loadFromPropertyFile();
            if (StringUtils.isNotBlank((CharSequence)agentArgs)) {
                this.init(agentArgs);
            }
        }
    }

    public Set<String> getInstrumentedPackages() {
        return Collections.unmodifiableSet(this.instrumentedPackages);
    }

    public Set<String> getInstrumentedClasses() {
        return Collections.unmodifiableSet(this.instrumentedClasses);
    }

    private String loadFromPropertyFile() {
        String result = EMPTY;
        Properties prop = new Properties();
        String propFileName = JMSPY_AGENT_PROPERTIES;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(propFileName);
        if (inputStream != null) {
            try {
                prop.load(inputStream);
                result = prop.getProperty(INSTRUMENTED_RESOURCES_PROP);
            }
            catch (IOException e) {
                throw new AgentConfigurationException(e);
            }
        }
        return result;
    }

    private void init(String data) {
        if (StringUtils.isNotBlank((CharSequence)data)) {
            data = data.replace(".", "/");
            String[] elements = (data = data.replaceAll("\\s", EMPTY)).split(",");
            if (elements.length > 0) {
                this.instrumentedPackages = new HashSet<String>();
                this.instrumentedClasses = new HashSet<String>();
                for (String el : elements) {
                    if (el.endsWith(CLASS_SUFFIX)) {
                        this.instrumentedClasses.add(el.replace(CLASS_SUFFIX, EMPTY));
                        continue;
                    }
                    this.instrumentedPackages.add(el);
                }
            }
        }
    }
}

