/*
 * Decompiled with CFR 0.152.
 */
package com.github.dmgcodevil.jmspy.agent;

import com.github.dmgcodevil.jmspy.agent.IdleClassVisitor;
import com.github.dmgcodevil.jmspy.agent.JmspyAgentConfig;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Agent {
    private static final Logger LOGGER = LoggerFactory.getLogger(Agent.class);

    public static void premain(String agentArgs, Instrumentation inst) {
        inst.addTransformer(new JmspyClassFileTransformer(new JmspyAgentConfig(agentArgs)));
    }

    private static void createDefaultConstructor(ClassWriter classWriter) {
        MethodVisitor mv = classWriter.visitMethod(1, "<init>", "()V", null, null);
        mv.visitMaxs(2, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitEnd();
    }

    private static class JmspyClassFileTransformer
    implements ClassFileTransformer {
        private static final byte[] NO_TRANSFORM = null;
        private Set<String> instrumentedPackages = Collections.emptySet();
        private Set<String> instrumentedClasses = Collections.emptySet();

        private JmspyClassFileTransformer(JmspyAgentConfig agentConfig) {
            this.instrumentedClasses = agentConfig.getInstrumentedClasses();
            this.instrumentedPackages = agentConfig.getInstrumentedPackages();
        }

        private boolean isInstrumented(String className) {
            if (this.instrumentedClasses.isEmpty() && this.instrumentedPackages.isEmpty()) {
                return true;
            }
            if (this.instrumentedClasses.contains(className)) {
                return true;
            }
            for (String instrumentedPkg : this.instrumentedPackages) {
                if (!className.startsWith(instrumentedPkg)) continue;
                return true;
            }
            return false;
        }

        @Override
        public byte[] transform(ClassLoader classLoader, String className, Class<?> aClass, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
            if (this.isInstrumented(className)) {
                try {
                    ClassReader classReader = new ClassReader(bytes);
                    ClassWriter classWriter = new ClassWriter(0);
                    ClassInfoReader classInfoReader = new ClassInfoReader();
                    classReader.accept((ClassVisitor)classInfoReader, 0);
                    if (!classInfoReader.isDefaultConstructor()) {
                        Agent.createDefaultConstructor(classWriter);
                    }
                    ClassAdapter classVisitor = new ClassAdapter((ClassVisitor)classWriter){

                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                            int removeFinal = access & 0xFFFFFFEF;
                            super.visit(version, removeFinal, name, signature, superName, interfaces);
                        }

                        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                            int removeFinal = access & 0xFFFFFFEF;
                            return super.visitMethod(removeFinal, name, desc, signature, exceptions);
                        }
                    };
                    classReader.accept((ClassVisitor)classVisitor, 0);
                    return classWriter.toByteArray();
                }
                catch (Throwable e) {
                    LOGGER.error("failed transform class. message: '{}'", (Object)e.getMessage());
                }
            }
            return NO_TRANSFORM;
        }
    }

    private static class ClassInfoReader
    extends IdleClassVisitor {
        private static final String DEFAULT_CONSTRUCTOR_SIGNATURE = "<init>()V";
        private boolean defaultConstructor;

        private ClassInfoReader() {
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (DEFAULT_CONSTRUCTOR_SIGNATURE.equals(name + desc)) {
                this.defaultConstructor = true;
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public boolean isDefaultConstructor() {
            return this.defaultConstructor;
        }
    }
}

