/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.discovery.consul;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerunit.core.annotation.ContainerBuilder;
import com.github.dockerunit.core.annotation.Svc;
import com.github.dockerunit.discovery.consul.annotation.UseConsulDns;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

@Svc(name="consul", image="")
public class ConsulDescriptor {
    private static final Logger logger = Logger.getLogger(ConsulDescriptor.class.getSimpleName());
    static final int CONSUL_DNS_PORT = 53;
    static final int CONSUL_PORT = 8500;

    @ContainerBuilder
    public CreateContainerCmd setup(CreateContainerCmd cmd) {
        boolean enableDnsFlag;
        ArrayList<Object> ports = new ArrayList<Object>(Arrays.asList((Object[])Objects.requireNonNull(cmd.getExposedPorts())));
        ExposedPort consulPort = ExposedPort.tcp((int)8500);
        ports.add(consulPort);
        Ports bindings = Objects.requireNonNull(cmd.getHostConfig()).getPortBindings();
        if (bindings == null) {
            bindings = new Ports();
        }
        if (enableDnsFlag = Boolean.parseBoolean(System.getProperty("consul.dns.enabled", "true"))) {
            this.activateDns(ports);
        } else {
            logger.warning("Consul DNS has been disabled. Usages of @" + UseConsulDns.class.getSimpleName() + " will be ignored.");
        }
        bindings.bind(consulPort, Ports.Binding.bindPort((int)8500));
        HostConfig hc = cmd.getHostConfig().withPortBindings(bindings);
        return cmd.withHostConfig(hc).withExposedPorts(ports).withImage(System.getProperty("consul.image", "consul:1.4.4")).withCmd(new String[]{"sh", "-c", "exec consul agent -dev -client=0.0.0.0 -enable-script-checks -dns-port=53"});
    }

    private void activateDns(List<ExposedPort> ports) {
        ExposedPort dnsPort = ExposedPort.udp((int)53);
        ports.add(dnsPort);
    }
}

