/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.discovery.consul;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerunit.core.Service;
import com.github.dockerunit.core.ServiceContext;
import com.github.dockerunit.core.ServiceInstance;
import com.github.dockerunit.core.discovery.DiscoveryProvider;
import com.github.dockerunit.core.internal.ServiceDescriptor;
import com.github.dockerunit.core.internal.docker.DefaultDockerClientProvider;
import com.github.dockerunit.core.internal.service.DefaultServiceContext;
import com.github.dockerunit.discovery.consul.ConsulDiscoveryConfig;
import com.github.dockerunit.discovery.consul.ConsulHttpResolver;
import com.github.dockerunit.discovery.consul.ConsulRegistrator;
import com.github.dockerunit.discovery.consul.ContainerUtils;
import com.github.dockerunit.discovery.consul.ServiceRecord;
import com.github.dockerunit.discovery.consul.annotation.TCPHealthCheck;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ConsulDiscoveryProvider
implements DiscoveryProvider {
    private static final String DOCKER_HOST = System.getProperty("docker.host", System.getProperty("docker.bridge.ip", "172.17.42.1"));
    private final ConsulHttpResolver resolver = new ConsulHttpResolver(DOCKER_HOST, 8500);
    private final ConsulRegistrator registrator;
    private final DockerClient dockerClient;
    private final int discoveryTimeout = Integer.parseInt(System.getProperty("service.discovery.timeout", "30"));
    private final int consulPollingPeriod = Integer.parseInt(System.getProperty("consul.polling.period", "1"));
    static final String CONSUL_DNS_SUFFIX = ".service.consul";

    public ConsulDiscoveryProvider() {
        this.dockerClient = new DefaultDockerClientProvider().getClient();
        this.registrator = new ConsulRegistrator(this.dockerClient, this.consulPollingPeriod, DOCKER_HOST, 8500);
    }

    public Class<?> getDiscoveryConfig() {
        return ConsulDiscoveryConfig.class;
    }

    public ServiceContext populateRegistry(ServiceContext context) {
        this.trackContext(context);
        Set services = context.getServices().stream().map(this::doDiscovery).collect(Collectors.toSet());
        return new DefaultServiceContext(services);
    }

    private void trackContext(ServiceContext context) {
        context.getServices().forEach(svc -> svc.getInstances().forEach(si -> this.registrator.trackContainer(si.getContainerId())));
    }

    public ServiceContext clearRegistry(ServiceContext currentContext, ServiceContext globalContext) {
        Set services = currentContext.getServices().stream().map(s -> this.doCleanup((Service)s, globalContext.getService(s.getName()))).collect(Collectors.toSet());
        return new DefaultServiceContext(services);
    }

    private Service doDiscovery(Service s) {
        List<ServiceRecord> records;
        try {
            records = this.resolver.resolveService(s.getName(), s.getInstances().size(), this.discoveryTimeout, this.consulPollingPeriod, this.extractInitialDelay(s.getDescriptor()));
        }
        catch (Exception e) {
            return s.withInstances(s.getInstances().stream().map(i -> i.withStatus(ServiceInstance.Status.ABORTED).withStatusDetails(e.getMessage())).collect(Collectors.toSet()));
        }
        Set withPorts = s.getInstances().stream().map(si -> {
            InspectContainerResponse r = this.dockerClient.inspectContainerCmd(si.getContainerId()).exec();
            return si.withGatewayPort(this.findPort(r, records).orElse(0).intValue()).withContainerPort(records.stream().findFirst().map(sr -> sr.getPort()).orElse(0).intValue()).withGatewayAddress(DOCKER_HOST).withContainerName(r.getName()).withContainerIp(ContainerUtils.extractBridgeIpAddress(r.getNetworkSettings()).orElse("")).withStatus(ServiceInstance.Status.DISCOVERED).withStatusDetails("Discovered via consul");
        }).collect(Collectors.toSet());
        return s.withInstances(withPorts);
    }

    private int extractInitialDelay(ServiceDescriptor descriptor) {
        return descriptor.getOptions().stream().filter(TCPHealthCheck.class::isInstance).findFirst().map(TCPHealthCheck.class::cast).map(TCPHealthCheck::initialDelay).orElse(0);
    }

    private Service doCleanup(Service current, Service global) {
        try {
            int expectedRecords = global != null ? global.getInstances().size() : 0;
            this.resolver.verifyCleanup(current.getName() + CONSUL_DNS_SUFFIX, expectedRecords, this.discoveryTimeout, this.consulPollingPeriod);
            return current;
        }
        catch (Exception e) {
            return current.withInstances(current.getInstances().stream().map(si -> si.withStatus(ServiceInstance.Status.TERMINATION_FAILED).withStatusDetails(e.getMessage())).collect(Collectors.toSet()));
        }
    }

    private Optional<Integer> findPort(InspectContainerResponse response, List<ServiceRecord> records) {
        return records.stream().filter(r -> this.matchRecord((ServiceRecord)r, response)).findFirst().flatMap(r -> ContainerUtils.extractMappedPort(r.getPort(), response.getNetworkSettings()));
    }

    private boolean matchRecord(ServiceRecord record, InspectContainerResponse r) {
        return this.matchIP(record.getServiceAddress(), r) && this.matchPort(record.getPort(), r);
    }

    private boolean matchPort(int port, InspectContainerResponse r) {
        return r.getNetworkSettings().getPorts().getBindings().keySet().stream().map(ExposedPort::getPort).anyMatch(p -> p == port);
    }

    private boolean matchIP(String address, InspectContainerResponse r) {
        return null != address && address.equals(ContainerUtils.extractBridgeIpAddress(r.getNetworkSettings()).orElse(null));
    }

    private Optional<Integer> parsePort(String s) {
        try {
            return Optional.of(Integer.parseInt(s));
        }
        catch (NumberFormatException nfe) {
            return Optional.empty();
        }
    }
}

