/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.discovery.consul;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerunit.discovery.consul.ServiceRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class ConsulHttpResolver {
    private final HttpClient httpClient;
    private final String host;
    private final int port;
    private final ObjectMapper mapper = new ObjectMapper();

    public ConsulHttpResolver(String host, int port) {
        this.host = host;
        this.port = port;
        this.httpClient = HttpClientBuilder.create().build();
    }

    public Void verifyCleanup(String serviceName, int expectedRecords, int timeoutInSeconds, int frequencyInSeconds) {
        BiConsumer errorConsumer = (fut, t) -> fut.complete(null);
        BiConsumer matchingConsumer = (fut, records) -> fut.complete(null);
        return (Void)this.performQuerying(serviceName, expectedRecords, timeoutInSeconds, frequencyInSeconds, errorConsumer, matchingConsumer);
    }

    public List<ServiceRecord> resolveService(final String serviceName, final int expectedRecords, final int timeoutInSeconds, final int frequencyInSeconds, int initialDelayInSeconds) {
        final CompletableFuture result = new CompletableFuture();
        TimerTask discovery = new TimerTask(){

            @Override
            public void run() {
                BiConsumer<CompletableFuture, Throwable> errorConsumer = (fut, t) -> {};
                BiConsumer<CompletableFuture, List> matchingConsumer = (fut, records) -> fut.complete(records);
                try {
                    List serviceRecords = (List)ConsulHttpResolver.this.performQuerying(serviceName, expectedRecords, timeoutInSeconds, frequencyInSeconds, errorConsumer, matchingConsumer);
                    result.complete(serviceRecords);
                }
                catch (Exception e) {
                    result.completeExceptionally(e.getCause());
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(discovery, initialDelayInSeconds * 1000);
        return (List)result.join();
    }

    private <T> T performQuerying(final String serviceName, final int expectedRecords, final int timeoutInSeconds, final int pollingPeriodInSeconds, BiConsumer<CompletableFuture<T>, Throwable> errorConsumer, final BiConsumer<CompletableFuture<T>, List<ServiceRecord>> matchingConsumer) {
        final CompletableFuture result = new CompletableFuture();
        final AtomicInteger counter = new AtomicInteger(0);
        TimerTask repeatedTask = new TimerTask(){

            @Override
            public void run() {
                List records = null;
                try {
                    records = ConsulHttpResolver.this.getHealthyRecords(serviceName);
                }
                catch (Exception e) {
                    result.completeExceptionally(e);
                }
                int counterValue = counter.incrementAndGet();
                if (records != null && records.size() == expectedRecords) {
                    this.cancel();
                    matchingConsumer.accept(result, records);
                } else if (ConsulHttpResolver.this.timedout(timeoutInSeconds, pollingPeriodInSeconds, counterValue)) {
                    this.cancel();
                    result.completeExceptionally(new RuntimeException("Discovery timed out."));
                }
            }
        };
        Timer timer = new Timer("consul-polling-" + serviceName);
        timer.scheduleAtFixedRate(repeatedTask, 0L, (long)(pollingPeriodInSeconds * 1000));
        result.exceptionally(ex -> {
            throw new RuntimeException("Discovery/cleanup failed for svc " + serviceName);
        });
        return result.join();
    }

    private List<ServiceRecord> getHealthyRecords(String serviceName) throws IOException, ClientProtocolException {
        List<ServiceRecord> allRecords = this.getCatalog(serviceName);
        List<ServiceRecord> unhealthy = this.getUnhealthy(serviceName);
        return allRecords.stream().filter(r -> unhealthy.stream().filter(uh -> uh.getPort() == r.getPort()).collect(Collectors.toList()).size() == 0).collect(Collectors.toList());
    }

    private List<ServiceRecord> getUnhealthy(String serviceName) throws ClientProtocolException, IOException {
        HttpResponse response = null;
        HttpGet get = new HttpGet("http://" + this.host + ":" + this.port + "/v1/health/service/" + serviceName);
        response = this.httpClient.execute((HttpUriRequest)get);
        List<ServiceRecord> records = this.parseUnhealthy(response);
        return records;
    }

    private List<ServiceRecord> getCatalog(String serviceName) throws ClientProtocolException, IOException {
        HttpResponse response = null;
        HttpGet get = new HttpGet("http://" + this.host + ":" + this.port + "/v1/catalog/service/" + serviceName);
        response = this.httpClient.execute((HttpUriRequest)get);
        return (List)this.mapper.reader().forType((TypeReference)new TypeReference<List<ServiceRecord>>(){}).readValue(response.getEntity().getContent());
    }

    private List<ServiceRecord> parseUnhealthy(HttpResponse response) throws UnsupportedOperationException, IOException {
        List records = (List)this.mapper.reader().forType((TypeReference)new TypeReference<List<ServiceRecord>>(){}).readValue(response.getEntity().getContent());
        if (records != null) {
            records = records.stream().filter(r -> {
                List<Object> failingChecks = new ArrayList();
                if (r.getChecks() != null) {
                    failingChecks = r.getChecks().stream().filter(c -> !c.getStatus().equalsIgnoreCase("passing")).collect(Collectors.toList());
                }
                return failingChecks.size() > 0;
            }).collect(Collectors.toList());
        }
        return records;
    }

    private boolean timedout(int timeoutInSeconds, int frequencyInSeconds, int counterValue) {
        return counterValue * frequencyInSeconds >= timeoutInSeconds;
    }
}

