/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.discovery.consul;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import com.github.dockerunit.discovery.consul.ConsulService;
import com.github.dockerunit.discovery.consul.ConsulServiceFactory;
import com.github.dockerunit.discovery.consul.ContainerTracker;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;

public class ConsulRegistrator {
    public static final String ACCEPT = "Accept";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_JSON = "application/json";
    private static final Logger logger = Logger.getLogger(ConsulRegistrator.class.getSimpleName());
    private final DockerClient client;
    private final Map<String, ContainerTracker> trackers = new ConcurrentHashMap<String, ContainerTracker>();
    private final Map<String, ConsulService> services = new ConcurrentHashMap<String, ConsulService>();
    private final int pollingPeriod;
    private final HttpClient httpClient;
    private final String host;
    private final int port;
    private final ObjectWriter objectWriter;
    private final ConsulServiceFactory svcFactory;

    public ConsulRegistrator(DockerClient client, int pollingPeriod, String consulHost, int consulPort) {
        this.client = client;
        this.pollingPeriod = pollingPeriod;
        this.host = consulHost;
        this.port = consulPort;
        this.httpClient = HttpClientBuilder.create().build();
        this.objectWriter = new ObjectMapper().writerFor(ConsulService.class);
        this.svcFactory = new ConsulServiceFactory(client);
    }

    public void trackContainer(String containerId) {
        Optional<ContainerTracker> tracker = Optional.ofNullable(this.trackers.get(containerId));
        this.trackers.put(containerId, tracker.orElse(new ContainerTracker(this.client, containerId, this.pollingPeriod, this::onDetectHook, this::onDestroyHook)));
    }

    private void onDetectHook(Container container) {
        ConsulService svc = this.svcFactory.createSvc(container.getId());
        this.registerSvc(svc);
        this.services.put(container.getId(), svc);
    }

    private void onDestroyHook(Container container) {
        if (container != null && this.services.containsKey(container.getId())) {
            this.deregisterSvc(this.services.get(container.getId()));
            this.trackers.remove(container.getId());
            this.services.remove(container.getId());
        }
    }

    private void registerSvc(ConsulService svc) {
        Supplier<String> errorMessage = () -> "Could not register container " + svc.getContainerId() + " on Consul.";
        try {
            this.executePut("/v1/agent/service/register", this.objectWriter.writeValueAsString((Object)svc), errorMessage, ex -> {
                throw new RuntimeException((String)errorMessage.get(), (Throwable)ex);
            });
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(errorMessage.get(), e);
        }
    }

    private void deregisterSvc(ConsulService svc) {
        Supplier<String> errorMessage = () -> "Could not deregister container " + svc.getContainerId() + " from Consul.";
        this.executePut("/v1/agent/service/deregister/" + svc.getId(), null, errorMessage, ex -> logger.info("Consul has already stopped. Service de-registration aborted."));
    }

    private void executePut(String endpoint, String body, Supplier<String> errorMessage, Consumer<Exception> onFailure) {
        int statusCode;
        HttpPut put = new HttpPut("http://" + this.host + ":" + this.port + endpoint);
        put.setHeader(ACCEPT, APPLICATION_JSON);
        put.setHeader(CONTENT_TYPE, APPLICATION_JSON);
        if (body != null) {
            try {
                put.setEntity((HttpEntity)new StringEntity(body));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(errorMessage.get(), e);
            }
        }
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)put);
        }
        catch (Exception e) {
            onFailure.accept(e);
        }
        if (response != null && (statusCode = response.getStatusLine().getStatusCode()) != 200) {
            throw new RuntimeException(errorMessage.get() + " Unexpected status code " + statusCode);
        }
    }
}

