/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.discovery.consul;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ConsulService {
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="Name")
    private String name;
    @JsonIgnore
    private String containerId;
    @JsonProperty(value="Address")
    private String address;
    @JsonProperty(value="Port")
    private int port;
    @JsonProperty(value="Check")
    private ConsulCheck check;

    ConsulService(String id, String name, String containerId, String address, int port, ConsulCheck check) {
        this.id = id;
        this.name = name;
        this.containerId = containerId;
        this.address = address;
        this.port = port;
        this.check = check;
    }

    public static ConsulServiceBuilder builder() {
        return new ConsulServiceBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public ConsulCheck getCheck() {
        return this.check;
    }

    public static class ConsulServiceBuilder {
        private String id;
        private String name;
        private String containerId;
        private String address;
        private int port;
        private ConsulCheck check;

        ConsulServiceBuilder() {
        }

        @JsonProperty(value="Id")
        public ConsulServiceBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="Name")
        public ConsulServiceBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonIgnore
        public ConsulServiceBuilder containerId(String containerId) {
            this.containerId = containerId;
            return this;
        }

        @JsonProperty(value="Address")
        public ConsulServiceBuilder address(String address) {
            this.address = address;
            return this;
        }

        @JsonProperty(value="Port")
        public ConsulServiceBuilder port(int port) {
            this.port = port;
            return this;
        }

        @JsonProperty(value="Check")
        public ConsulServiceBuilder check(ConsulCheck check) {
            this.check = check;
            return this;
        }

        public ConsulService build() {
            return new ConsulService(this.id, this.name, this.containerId, this.address, this.port, this.check);
        }

        public String toString() {
            return "ConsulService.ConsulServiceBuilder(id=" + this.id + ", name=" + this.name + ", containerId=" + this.containerId + ", address=" + this.address + ", port=" + this.port + ", check=" + this.check + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ConsulCheck {
        @JsonProperty(value="Args")
        private List<String> args;
        @JsonProperty(value="HTTP")
        private String http;
        @JsonProperty(value="TCP")
        private String tcp;
        @JsonProperty(value="Method")
        private String method;
        @JsonProperty(value="Interval")
        private String interval;
        @JsonProperty(value="Status")
        private String status;
        @JsonProperty(value="TTL")
        private String ttl;
        @JsonProperty(value="Shell")
        private String shell;
        @JsonProperty(value="TLSSkipVerify")
        private boolean tlsSkipVerify;

        ConsulCheck(List<String> args, String http, String tcp, String method, String interval, String status, String ttl, String shell, boolean tlsSkipVerify) {
            this.args = args;
            this.http = http;
            this.tcp = tcp;
            this.method = method;
            this.interval = interval;
            this.status = status;
            this.ttl = ttl;
            this.shell = shell;
            this.tlsSkipVerify = tlsSkipVerify;
        }

        public static ConsulCheckBuilder builder() {
            return new ConsulCheckBuilder();
        }

        public List<String> getArgs() {
            return this.args;
        }

        public String getHttp() {
            return this.http;
        }

        public String getTcp() {
            return this.tcp;
        }

        public String getMethod() {
            return this.method;
        }

        public String getInterval() {
            return this.interval;
        }

        public String getStatus() {
            return this.status;
        }

        public String getTtl() {
            return this.ttl;
        }

        public String getShell() {
            return this.shell;
        }

        public boolean isTlsSkipVerify() {
            return this.tlsSkipVerify;
        }

        public static class ConsulCheckBuilder {
            private List<String> args;
            private String http;
            private String tcp;
            private String method;
            private String interval;
            private String status;
            private String ttl;
            private String shell;
            private boolean tlsSkipVerify;

            ConsulCheckBuilder() {
            }

            @JsonProperty(value="Args")
            public ConsulCheckBuilder args(List<String> args) {
                this.args = args;
                return this;
            }

            @JsonProperty(value="HTTP")
            public ConsulCheckBuilder http(String http) {
                this.http = http;
                return this;
            }

            @JsonProperty(value="TCP")
            public ConsulCheckBuilder tcp(String tcp) {
                this.tcp = tcp;
                return this;
            }

            @JsonProperty(value="Method")
            public ConsulCheckBuilder method(String method) {
                this.method = method;
                return this;
            }

            @JsonProperty(value="Interval")
            public ConsulCheckBuilder interval(String interval) {
                this.interval = interval;
                return this;
            }

            @JsonProperty(value="Status")
            public ConsulCheckBuilder status(String status) {
                this.status = status;
                return this;
            }

            @JsonProperty(value="TTL")
            public ConsulCheckBuilder ttl(String ttl) {
                this.ttl = ttl;
                return this;
            }

            @JsonProperty(value="Shell")
            public ConsulCheckBuilder shell(String shell) {
                this.shell = shell;
                return this;
            }

            @JsonProperty(value="TLSSkipVerify")
            public ConsulCheckBuilder tlsSkipVerify(boolean tlsSkipVerify) {
                this.tlsSkipVerify = tlsSkipVerify;
                return this;
            }

            public ConsulCheck build() {
                return new ConsulCheck(this.args, this.http, this.tcp, this.method, this.interval, this.status, this.ttl, this.shell, this.tlsSkipVerify);
            }

            public String toString() {
                return "ConsulService.ConsulCheck.ConsulCheckBuilder(args=" + this.args + ", http=" + this.http + ", tcp=" + this.tcp + ", method=" + this.method + ", interval=" + this.interval + ", status=" + this.status + ", ttl=" + this.ttl + ", shell=" + this.shell + ", tlsSkipVerify=" + this.tlsSkipVerify + ")";
            }
        }
    }
}

