/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.discovery.consul;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class ContainerTracker {
    private static final Logger logger = Logger.getLogger(ContainerTracker.class.getSimpleName());
    private final DockerClient client;
    private final String containerId;
    private final int pollingPeriod;
    private final Consumer<Container> onDetect;
    private final Consumer<Container> onDestroy;
    private Container latestContainer;

    public ContainerTracker(DockerClient client, String containerId, int pollingPeriod, Consumer<Container> onDetect, Consumer<Container> onDestroy) {
        this.client = client;
        this.containerId = containerId;
        this.pollingPeriod = pollingPeriod;
        this.onDetect = onDetect;
        this.onDestroy = onDestroy;
        this.init();
    }

    public ContainerTracker(DockerClient client, String containerId, int pollingPeriod) {
        this(client, containerId, pollingPeriod, c -> logger.info("Detected container with id: " + c.getId()), c -> logger.info("Container with id " + c.getId() + " has been destroyed."));
    }

    private void init() {
        this.latestContainer = this.findContainer().orElseThrow(() -> new RuntimeException("Could not detect container with id: " + this.containerId));
        this.onDetect.accept(this.latestContainer);
        this.track();
    }

    private Optional<Container> findContainer() {
        return ((List)this.client.listContainersCmd().withIdFilter(Collections.singletonList(this.containerId)).exec()).stream().findFirst();
    }

    private void track() {
        TimerTask repeatedTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    ContainerTracker.this.latestContainer = (Container)ContainerTracker.this.findContainer().orElseThrow(() -> new RuntimeException("Container " + ContainerTracker.this.containerId + " has been removed."));
                }
                catch (Exception e) {
                    this.cancel();
                    ContainerTracker.this.onDestroy.accept(ContainerTracker.this.latestContainer);
                }
            }
        };
        Timer timer = new Timer("Container " + this.containerId + " monitor");
        timer.scheduleAtFixedRate(repeatedTask, 0L, (long)(this.pollingPeriod * 1000));
    }
}

