/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.discovery.consul;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ContainerNetworkSettings;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerunit.core.internal.docker.DefaultDockerClientProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ContainerUtils {
    private static final DockerClient dockerClient = new DefaultDockerClientProvider().getClient();

    public static Optional<String> extractBridgeIpAddress(ContainerNetworkSettings settings) {
        return ContainerUtils.extractIp(settings.getNetworks());
    }

    public static Optional<String> extractBridgeIpAddress(NetworkSettings settings) {
        return ContainerUtils.extractIp(settings.getNetworks());
    }

    public static Optional<Integer> extractMappedPort(int port, NetworkSettings networkSettings) {
        return networkSettings.getPorts().getBindings().entrySet().stream().filter(entry -> ((ExposedPort)entry.getKey()).getPort() == port).map(Map.Entry::getValue).filter(bindings -> bindings != null && ((Ports.Binding[])bindings).length > 0).findFirst().flatMap(bindings -> ContainerUtils.parsePort(bindings[0].getHostPortSpec()));
    }

    public static Container getConsulContainer() {
        return ((List)dockerClient.listContainersCmd().exec()).stream().filter(ContainerUtils::isConsul).findFirst().orElseThrow(() -> new RuntimeException("Could not detect the Consul container."));
    }

    private static boolean isConsul(Container c) {
        return Arrays.asList(c.getNames()).contains("/consul");
    }

    private static Optional<String> extractIp(Map<String, ContainerNetwork> networks) {
        return Optional.ofNullable(((ContainerNetwork)networks.entrySet().stream().filter(network -> "bridge".equals(network.getKey())).findFirst().orElseThrow(() -> new RuntimeException("Container is not connected to the bridge network.")).getValue()).getIpAddress());
    }

    private static Optional<Integer> parsePort(String s) {
        try {
            return Optional.of(Integer.parseInt(s));
        }
        catch (NumberFormatException nfe) {
            return Optional.empty();
        }
    }

    private ContainerUtils() {
    }
}

