/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.discovery.consul.annotation.impl;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerunit.core.annotation.ExtensionInterpreter;
import com.github.dockerunit.core.internal.ServiceDescriptor;
import com.github.dockerunit.discovery.consul.annotation.WebHealthCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WebHealthCheckExtensionInterpreter
implements ExtensionInterpreter<WebHealthCheck> {
    private static final String SERVICE_NAME_SUFFIX = "_NAME";
    private static final String SERVICE_PREFIX = "SERVICE_";
    private static final String SERVICE_CHECK_HTTP = "SERVICE_CHECK_HTTP";
    private static final String SERVICE_CHECK_INTERVAL = "SERVICE_CHECK_INTERVAL";
    private static final String SERVICE_CHECK_METHOD = "SERVICE_CHECK_METHOD";

    public CreateContainerCmd build(ServiceDescriptor sd, CreateContainerCmd cmd, WebHealthCheck whc) {
        String serviceNameEnv = SERVICE_PREFIX + whc.port() + SERVICE_NAME_SUFFIX + "=" + sd.getSvcName();
        String serviceCheckIntervalEnv = "SERVICE_CHECK_INTERVAL=" + whc.pollingInterval() + "s";
        String serviceCheckEnv = "SERVICE_CHECK_HTTP=" + whc.protocol().toString().toLowerCase() + "://$SERVICE_IP:$SERVICE_PORT" + whc.endpoint();
        String serviceCheckMethodEnv = "SERVICE_CHECK_METHOD=GET";
        ArrayList<String> finalEnv = new ArrayList<String>();
        List<String> healthCheckEnv = Arrays.asList(serviceNameEnv, serviceCheckEnv, serviceCheckIntervalEnv);
        finalEnv.addAll(healthCheckEnv);
        String[] env = cmd.getEnv();
        if (env != null) {
            finalEnv.addAll(Arrays.asList(env));
        }
        return cmd.withEnv(finalEnv);
    }
}

