/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerunit.internal.lifecycle;

import com.github.dockerunit.core.ServiceContext;
import com.github.dockerunit.junit4.DockerUnitRunner;
import java.lang.reflect.Method;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class InvokeDockerUnitMethod
extends Statement {
    private final FrameworkMethod testMethod;
    private final Object target;
    private final DockerUnitRunner runner;

    public void evaluate() throws Throwable {
        Method method = this.testMethod.getMethod();
        if (method.getParameterCount() == 0) {
            this.testMethod.invokeExplosively(this.target, new Object[0]);
        } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0].isAssignableFrom(ServiceContext.class)) {
            ServiceContext context = this.runner.getContext(this.testMethod);
            this.testMethod.invokeExplosively(this.target, new Object[]{context});
        } else {
            throw new IllegalArgumentException("Test methods must have either zero arguments or one argument of type " + ServiceContext.class.getName());
        }
    }

    public InvokeDockerUnitMethod(FrameworkMethod testMethod, Object target, DockerUnitRunner runner) {
        this.testMethod = testMethod;
        this.target = target;
        this.runner = runner;
    }
}

